---
UID: NF:p2p.PeerGetNextItem
title: PeerGetNextItem function (p2p.h)
description: The PeerGetNextItem function returns a specific number of items from a peer enumeration.
old-location: p2p\peergetnextitem.htm
tech.root: P2PSdk
ms.assetid: 015faeb3-82d9-49e5-a451-7394bf83240f
ms.date: 12/05/2018
ms.keywords: PeerGetNextItem, PeerGetNextItem function [Peer Networking], p2p.peergetnextitem, p2p/PeerGetNextItem
f1_keywords:
- p2p/PeerGetNextItem
dev_langs:
- c++
req.header: p2p.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP with SP2 [desktop apps only],Windows XP with SP1 with the Advanced Networking Pack forWindows XP
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: P2P.lib
req.dll: P2P.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- P2P.dll
api_name:
- PeerGetNextItem
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# PeerGetNextItem function


## -description


The <b>PeerGetNextItem</b> function returns a specific number of items from a peer enumeration.


## -parameters




### -param hPeerEnum [in]

Handle to the peer enumeration from which items are retrieved. This handle is generated by a peer enumeration function.


### -param pCount [in, out]

Pointer to an integer that specifies the number of items to be retrieved from the peer enumeration. When returned, it contains the number of items in <i>ppvItems</i>. This parameter cannot be <b>NULL</b>.


### -param pppvItems [out]

Receives a pointer to an array of pointers to the next <i>pCount</i> items in the peer enumeration. The  data, for example, a record or member information block, depends on the actual peer enumeration type. 


## -returns



Returns <b>S_OK</b> if the operation succeeds. Otherwise, the function returns one of the following values.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
One of the parameters is not valid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_OUTOFMEMORY</b></dt>
</dl>
</td>
<td width="60%">
There is not enough memory to perform a specified operation.

</td>
</tr>
</table>
 




## -remarks



The <b>PeerGetNextItem</b> function returns  the following: 

<ul>
<li>Items that are equal to or less than the amount specified in <i>pCount</i>.</li>
<li>A list of items that are less than the amount specified when the amount is greater than the number of items available.</li>
</ul>
<div class="alert"><b>Note</b>  For example, when the inbound value of <i>pCount</i> is 10 and the remainder of the enumeration is 5 items, only 5 items are returned and the value pointed to by <i>pCount</i> is set to 5.</div>
<div> </div>
All items returned must be freed by passing a pointer to the array of pointers  to the <a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peerfreedata">PeerFreeData</a> function.

The end of an enumeration is indicated when the function returns with the <i>pCount</i> parameter set to zero (0).




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peerenumgroups">PeerEnumGroups</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peerenumidentities">PeerEnumIdentities</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peerendenumeration">PeerGetEndEnumeration</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peergetitemcount">PeerGetItemCount</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peergroupenumconnections">PeerGroupEnumConnections</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peergroupenummembers">PeerGroupEnumMembers</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peergroupenumrecords">PeerGroupEnumRecords</a>
 

 

