---
UID: NN:peninputpanel.ITextInputPanelRunInfo
title: ITextInputPanelRunInfo (peninputpanel.h)
description: Provides a method to determine if the Text Input Panel is currently running.
old-location: tablet\itextinputpanelruninfo.htm
tech.root: tablet
ms.assetid: 9269a94f-c33f-4e25-bab8-be68e6ead63f
ms.date: 12/05/2018
ms.keywords: 9269a94f-c33f-4e25-bab8-be68e6ead63f, ITextInputPanelRunInfo, ITextInputPanelRunInfo interface [Tablet PC], ITextInputPanelRunInfo interface [Tablet PC],described, peninputpanel/ITextInputPanelRunInfo, tablet.itextinputpanelruninfo
f1_keywords:
- peninputpanel/ITextInputPanelRunInfo
dev_langs:
- c++
req.header: peninputpanel.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Tiptsf.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- tiptsf.dll
api_name:
- ITextInputPanelRunInfo
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ITextInputPanelRunInfo interface


## -description



Provides a method to determine if the Text Input Panel is currently running.




## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">ITextInputPanelRunInfo</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>ITextInputPanelRunInfo</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>ITextInputPanelRunInfo</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/peninputpanel/nf-peninputpanel-itextinputpanelruninfo-istiprunning">IsTipRunning</a>
</td>
<td align="left" width="63%">
Indicates if the Tablet PC Input Panel is running at the time the method is called.

</td>
</tr>
</table> 


## -remarks



This element is declared in Peninputpanel.h.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/tablet/programming-the-text-input-panel">Programming the Text Input Panel</a>



<a href="https://docs.microsoft.com/windows/desktop/tablet/text-input-panel-reference">Text Input Panel Reference</a>
 

 

