---
UID: NE:pla.__MIDL___MIDL_itf_pla_0001_0043_0007
title: CommitMode (pla.h)
description: Defines the action to take when committing changes to the data collector set.
old-location: pla\commitmode.htm
tech.root: PLA
ms.assetid: 3c485b4d-ba0b-456a-b942-27829371d7fb
ms.date: 12/05/2018
ms.keywords: CommitMode, CommitMode enumeration [PLA], base.commitmode, pla.commitmode, pla/CommitMode, pla/plaCreateNew, pla/plaCreateOrModify, pla/plaFlushTrace, pla/plaModify, pla/plaUpdateRunningInstance, pla/plaValidateOnly, plaCreateNew, plaCreateOrModify, plaFlushTrace, plaModify, plaUpdateRunningInstance, plaValidateOnly
f1_keywords:
- pla/CommitMode
dev_langs:
- c++
req.header: pla.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Pla.h
api_name:
- CommitMode
targetos: Windows
req.typenames: CommitMode
req.redist: 
ms.custom: 19H1
---

# CommitMode enumeration


## -description


Defines the action to take when committing changes to the data collector set.


## -enum-fields




### -field plaCreateNew

Save the set. The set must not already exist. 

The set is not saved if it is a trace session.


### -field plaModify

Update a previously saved set.


### -field plaCreateOrModify

Save the set. If the set already exists, update the set.

The set is not saved if it is a trace session.


### -field plaUpdateRunningInstance

Apply the updated property values to the currently running data set.


### -field plaFlushTrace

Flush the buffers for an Event Tracing for Windows trace session. This action applies only to sets that contain trace data collectors.


### -field plaValidateOnly

Perform validation only on the set.


## -remarks



All commit modes validate the set.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/pla/nf-pla-idatacollectorset-commit">IDataCollectorSet::Commit</a>
 

 

