---
UID: NS:projectedfslib.PRJ_PLACEHOLDER_VERSION_INFO
title: PRJ_PLACEHOLDER_VERSION_INFO (projectedfslib.h)
description: Information that uniquely identifies the contents of a placeholder file.
old-location: projfs\prj_placeholder_version_info.htm
tech.root: ProjFS
ms.assetid: 4F2156AC-087B-4FF6-8566-25D9DC2A8C06
ms.date: 12/05/2018
ms.keywords: PRJ_PLACEHOLDER_VERSION_INFO, PRJ_PLACEHOLDER_VERSION_INFO structure, ProjFS.prj_placeholder_version_info, projectedfslib/PRJ_PLACEHOLDER_VERSION_INFO
f1_keywords:
- projectedfslib/PRJ_PLACEHOLDER_VERSION_INFO
dev_langs:
- c++
req.header: projectedfslib.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10, version 1809 [desktop apps only]
req.target-min-winversvr: Windows Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- projectedfslib.h
api_name:
- PRJ_PLACEHOLDER_VERSION_INFO
targetos: Windows
req.typenames: PRJ_PLACEHOLDER_VERSION_INFO
req.redist: 
ms.custom: RS5, 19H1
---

# PRJ_PLACEHOLDER_VERSION_INFO structure


## -description


Information that uniquely identifies the contents of a placeholder file.


## -struct-fields




### -field ProviderID

A provider specific identifier.


### -field ContentID

A content identifier, generated by the provider.


## -remarks



A provider uses <b>PRJ_PLACEHOLDER_VERSION_INFO</b> to provide information that uniquely identifies the contents of a placeholder file. ProjFS stores the contents of this struct with the file and returns it when invoking callbacks. 


<b>PRJ_PLACEHOLDER_VERSION_INFO</b>.ProviderID is a provider-specific identifier. The provider may use this value as its own unique identifier, for example as a version number for the format of the ContentID field. 


<b>PRJ_PLACEHOLDER_VERSION_INFO</b>.ContentID is a content identifier, generated by the provider. This value is used to distinguish different versions of the same file, i.e. different file contents and/or metadata (e.g. timestamps) for the same file path. 



