---
UID: NS:propidl.tagSTATPROPSTG
title: STATPROPSTG (propidl.h)
description: Contains data about a single property in a property set. This data is the property ID and type tag, and the optional string name that may be associated with the property.
old-location: stg\statpropstg.htm
tech.root: Stg
ms.assetid: 3b8de6d3-18a3-4c0a-94d1-04bcec05d41a
ms.date: 12/05/2018
ms.keywords: STATPROPSTG, STATPROPSTG [Strctd Stg], STATPROPSTG structure [Structured Storage], _stg_statpropstg, propidlbase/STATPROPSTG, stg.statpropstg, tagSTATPROPSTG
f1_keywords:
- propidl/STATPROPSTG
dev_langs:
- c++
req.header: propidl.h
req.include-header: Propidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps \| UWP apps]
req.target-min-winversvr: Windows 2000 Server [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- propidlbase.h
api_name:
- STATPROPSTG
targetos: Windows
req.typenames: STATPROPSTG
req.redist: 
ms.custom: 19H1
---

# STATPROPSTG structure


## -description


The 
<b>STATPROPSTG</b> structure contains data about a single property in a property set. This data is the property ID and type tag, and the optional string name that may be associated with the property.


<a href="https://docs.microsoft.com/windows/desktop/api/propidl/nf-propidl-ipropertystorage-enum">IPropertyStorage::Enum</a> supplies a pointer to the 
<a href="https://docs.microsoft.com/windows/desktop/api/propidl/nn-propidl-ienumstatpropstg">IEnumSTATPROPSTG</a> interface on an enumerator object that can be used to enumerate the 
<b>STATPROPSTG</b> structures for the properties in the current property set. 
<b>STATPROPSTG</b> is defined as:


## -struct-fields




### -field lpwstrName

A wide-character null-terminated Unicode string that contains the optional string name associated with the property. May be <b>NULL</b>. This member must be freed using 
<a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cotaskmemfree">CoTaskMemFree</a>.


### -field propid

A 32-bit identifier that uniquely identifies the property within the property set. All properties within property sets must have unique property identifiers.


### -field vt

The property type.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/propidl/nn-propidl-ienumstatpropstg">IEnumSTATPROPSTG</a>



<a href="https://docs.microsoft.com/windows/desktop/api/propidl/nf-propidl-ipropertystorage-enum">IPropertyStorage::Enum</a>
 

 

