---
UID: NE:propsys.PROPDESC_RELATIVEDESCRIPTION_TYPE
title: PROPDESC_RELATIVEDESCRIPTION_TYPE (propsys.h)
description: Describes the relative description type for a property description, as determined by the relativeDescriptionType attribute of the displayInfo element.
old-location: properties\PROPDESC_RELATIVEDESCRIPTION_TYPE.htm
tech.root: properties
ms.assetid: cc9d59db-88d6-4726-ac1e-15b483afd637
ms.date: 12/05/2018
ms.keywords: PDRDT_COUNT, PDRDT_DATE, PDRDT_DURATION, PDRDT_GENERAL, PDRDT_LENGTH, PDRDT_PRIORITY, PDRDT_RATE, PDRDT_RATING, PDRDT_REVISION, PDRDT_SIZE, PDRDT_SPEED, PROPDESC_RELATIVEDESCRIPTION_TYPE, PROPDESC_RELATIVEDESCRIPTION_TYPE enumeration [Windows Properties], properties.PROPDESC_RELATIVEDESCRIPTION_TYPE, propsys/PDRDT_COUNT, propsys/PDRDT_DATE, propsys/PDRDT_DURATION, propsys/PDRDT_GENERAL, propsys/PDRDT_LENGTH, propsys/PDRDT_PRIORITY, propsys/PDRDT_RATE, propsys/PDRDT_RATING, propsys/PDRDT_REVISION, propsys/PDRDT_SIZE, propsys/PDRDT_SPEED, propsys/PROPDESC_RELATIVEDESCRIPTION_TYPE, shell.PROPDESC_RELATIVEDESCRIPTION_TYPE, shell_PROPDESC_RELATIVEDESCRIPTION_TYPE
f1_keywords:
- propsys/PROPDESC_RELATIVEDESCRIPTION_TYPE
dev_langs:
- c++
req.header: propsys.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Propsys.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Propsys.h
api_name:
- PROPDESC_RELATIVEDESCRIPTION_TYPE
targetos: Windows
req.typenames: PROPDESC_RELATIVEDESCRIPTION_TYPE
req.redist: 
ms.custom: 19H1
---

# PROPDESC_RELATIVEDESCRIPTION_TYPE enumeration


## -description


Describes the relative description type for a property description, as determined by the <i>relativeDescriptionType</i> attribute of the <a href="https://docs.microsoft.com/windows/desktop/properties/propdesc-schema-displayinfo">displayInfo</a> element.


## -enum-fields




### -field PDRDT_GENERAL

General type.


### -field PDRDT_DATE

Date type.


### -field PDRDT_SIZE

Size type.


### -field PDRDT_COUNT

Count type.


### -field PDRDT_REVISION

Revision type.


### -field PDRDT_LENGTH

Length type.


### -field PDRDT_DURATION

Duration type.


### -field PDRDT_SPEED

Speed type.


### -field PDRDT_RATE

Rate type.


### -field PDRDT_RATING

Rating type.


### -field PDRDT_PRIORITY

Priority type.


## -remarks



These values are defined in propsys.h and propsys.idl.



