---
UID: NF:propsys.IPersistSerializedPropStorage.SetPropertyStorage
title: IPersistSerializedPropStorage::SetPropertyStorage (propsys.h)
description: Initializes the property store instance from the specified serialized property storage data.
old-location: shell\IPersistSerializedPropStorage_SetPropertyStorage.htm
tech.root: shell
ms.assetid: 5b6d14ba-3de3-493e-8551-0f3caa02f339
ms.date: 12/05/2018
ms.keywords: IPersistSerializedPropStorage interface [Windows Shell],SetPropertyStorage method, IPersistSerializedPropStorage.SetPropertyStorage, IPersistSerializedPropStorage::SetPropertyStorage, SetPropertyStorage, SetPropertyStorage method [Windows Shell], SetPropertyStorage method [Windows Shell],IPersistSerializedPropStorage interface, _shell_IPersistSerializedPropStorage_SetPropertyStorage, propsys/IPersistSerializedPropStorage::SetPropertyStorage, shell.IPersistSerializedPropStorage_SetPropertyStorage
f1_keywords:
- propsys/IPersistSerializedPropStorage.SetPropertyStorage
dev_langs:
- c++
req.header: propsys.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Propsys.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Propsys.h
api_name:
- IPersistSerializedPropStorage.SetPropertyStorage
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IPersistSerializedPropStorage::SetPropertyStorage


## -description


Initializes the property store instance from the specified serialized property storage data.


## -parameters




### -param psps [in]

Type: <b>PCUSERIALIZEDPROPSTORAGE</b>

A pointer to the serialized property store data that will be used to initialize the property store.


### -param cb [in]

Type: <b>DWORD</b>

The count of bytes contained in the serialized property storage data pointed to by <i>psps</i>.


## -returns



Type: <b>HRESULT</b>

If this method succeeds, it returns <b xmlns:loc="http://microsoft.com/wdcml/l10n">S_OK</b>. Otherwise, it returns an <b xmlns:loc="http://microsoft.com/wdcml/l10n">HRESULT</b> error code.




## -remarks



The <b>SERIALIZEDPROPSTORAGE</b> type is defined in Propsys.h as an incomplete type. It should be treated as an array of <b>BYTE</b> values; the format of the data returned is not specified. The data stored as a <b>SERIALIZEDPROPSTORAGE</b> structure must have been obtained through a call to <a href="https://docs.microsoft.com/windows/desktop/api/propsys/nf-propsys-ipersistserializedpropstorage-getpropertystorage">IPersistSerializedPropStorage::GetPropertyStorage</a>, either directly or through persisted data that was generated by a call to that method.



