---
UID: NE:pwm._PWM_POLARITY
title: PWM_POLARITY (pwm.h)
description: Represents the Pulse Width Modulation (PWM) signal level polarity with respect to the duty cycle.
old-location: base\pwm_polarity.htm
tech.root: devio
ms.assetid: D818E512-5E50-4CF2-AF22-1A4AB07679A6
ms.date: 12/05/2018
ms.keywords: PWM_ACTIVE_HIGH, PWM_ACTIVE_LOW, PWM_POLARITY, PWM_POLARITY enumeration, base.pwm_polarity, pwm/PWM_ACTIVE_HIGH, pwm/PWM_ACTIVE_LOW, pwm/PWM_POLARITY
f1_keywords:
- pwm/PWM_POLARITY
dev_langs:
- c++
req.header: pwm.h
req.include-header: Pwm.h
req.target-type: Windows
req.target-min-winverclnt: Windows 10 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 1.19
req.umdf-ver: 2.19
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Pwm.h
api_name:
- PWM_POLARITY
targetos: Windows
req.typenames: PWM_POLARITY
req.redist: 
ms.custom: 19H1
---

# PWM_POLARITY enumeration


## -description


Represents the Pulse Width Modulation (PWM) signal level polarity with respect to the duty cycle.


## -enum-fields




### -field PWM_ACTIVE_HIGH

Active High.


### -field PWM_ACTIVE_LOW

Active Low.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/pwm/ni-pwm-ioctl_pwm_pin_get_polarity">IOCTL_PWM_PIN_GET_POLARITY</a>



<a href="https://docs.microsoft.com/windows/desktop/api/pwm/ni-pwm-ioctl_pwm_pin_set_polarity">IOCTL_PWM_PIN_SET_POLARITY</a>



<a href="https://docs.microsoft.com/windows/desktop/DevIO/pwm-pin-get-polarity-output">PWM_PIN_GET_POLARITY_OUTPUT</a>



<a href="https://docs.microsoft.com/windows/desktop/api/pwm/ns-pwm-pwm_pin_set_polarity_input">PWM_PIN_SET_POLARITY_INPUT</a>
 

 

