---
UID: NS:qossp._RSVP_RESERVE_INFO
title: RSVP_RESERVE_INFO (qossp.h)
description: The QOS object RSVP_RESERVE_INFO, through the ProviderSpecific buffer, enables RSVP behavior for a given flow to be specified or modified at a granular level, and enables default RSVP style settings for a flow to be overridden.
old-location: qos\rsvp_reserve_info.htm
tech.root: QOS
ms.assetid: 0f43e544-afe3-40dd-81e1-96ae1f343006
ms.date: 12/05/2018
ms.keywords: '*LPRSVP_RESERVE_INFO, LPRSVP_RESERVE_INFO, LPRSVP_RESERVE_INFO structure pointer [QOS], RSVP_DEFAULT_STYLE, RSVP_FIXED_FILTER_STYLE, RSVP_RESERVE_INFO, RSVP_RESERVE_INFO structure [QOS], RSVP_SHARED_EXPLICIT_STYLE, RSVP_WILDCARD_SYLE, _gqos_rsvp_reserve_info, qos.rsvp_reserve_info, qossp/LPRSVP_RESERVE_INFO, qossp/RSVP_RESERVE_INFO'
f1_keywords:
- qossp/RSVP_RESERVE_INFO
dev_langs:
- c++
req.header: qossp.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Qossp.h
api_name:
- RSVP_RESERVE_INFO
targetos: Windows
req.typenames: RSVP_RESERVE_INFO, *LPRSVP_RESERVE_INFO
req.redist: 
ms.custom: 19H1
---

# RSVP_RESERVE_INFO structure


## -description


The QOS object 
<b>RSVP_RESERVE_INFO</b>, through the ProviderSpecific buffer, enables RSVP behavior for a given flow to be specified or modified at a granular level, and enables default RSVP style settings for a flow to be overridden. Although 
<b>RSVP_RESERVE_INFO</b> is technically a structure, its use within Windows 2000 QOS technology—and especially its required inclusion of the 
<b>QOS_OBJECT_HDR</b> as its first member—define it as a QOS object.
<div class="alert"><b>Note</b>  The RSVP_RESERVE_INFO QOS object is not supported except on Windows 2000.</div><div> </div>

## -struct-fields




### -field ObjectHdr

The QOS object 
<b>QOS_OBJECT_HDR</b>.


### -field Style

Specifies the RSVP reservation style for a given flow, and can be used to replace default reservation styles placed on a particular type of flow. More information about RSVP reservation styles, and the default settings for certain QOS-enabled socket sessions, can be found under 
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/qos/network-driven-qos-components">Network-Driven QOS Components</a>. This member can be one of the following values. 



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="RSVP_WILDCARD_SYLE"></a><a id="rsvp_wildcard_syle"></a><dl>
<dt><b>RSVP_WILDCARD_SYLE</b></dt>
</dl>
</td>
<td width="60%">
Implements the WF RSVP reservation style. RSVP_WILDCARD_STYLE is the default value for multicast receivers and UDP unicast receivers. Specifying RSVP_WILDCARD_STYLE through RSVP_RESERVE_INFO is useful for overriding the default value (RSVP_FIXED_FILTER_STYLE) applied to connected unicast receivers.

</td>
</tr>
<tr>
<td width="40%"><a id="RSVP_FIXED_FILTER_STYLE"></a><a id="rsvp_fixed_filter_style"></a><dl>
<dt><b>RSVP_FIXED_FILTER_STYLE</b></dt>
</dl>
</td>
<td width="60%">
Implements the Fixed Filter (FF) RSVP reservation style. RSVP_FIXED_FILTER_STYLE is useful for overriding the default style for multicast receivers or unconnected UDP unicast receivers (RSVP_WILDCARD_STYLE). It may also be used to generate multiple RSVP_FIXED_FILTER_STLYE reservations in instances where only a single RSVP_FIXED_FILTER_STYLE reservation will be generated by default, such as with connected unicast receivers.

</td>
</tr>
<tr>
<td width="40%"><a id="RSVP_SHARED_EXPLICIT_STYLE"></a><a id="rsvp_shared_explicit_style"></a><dl>
<dt><b>RSVP_SHARED_EXPLICIT_STYLE</b></dt>
</dl>
</td>
<td width="60%">
Implements the Shared Explicit (SE) RSVP reservation style.

</td>
</tr>
<tr>
<td width="40%"><a id="RSVP_DEFAULT_STYLE"></a><a id="rsvp_default_style"></a><dl>
<dt><b>RSVP_DEFAULT_STYLE</b></dt>
</dl>
</td>
<td width="60%">
Implements the default reservation style for the computer.

</td>
</tr>
</table>
 

<div class="alert"><b>Note</b>  It is important to note that the number of senders included in any individual RSVP_SHARED_EXPLICIT_STYLE reservation must be less than one hundred senders. If more than one hundred senders attempt to connect to an RSVP_SHARED_EXPLICIT_STYLE reservation, the one-hundredth (and above) attempt fails without notice.</div>
<div> </div>

### -field ConfirmRequest

Can be used by a receiving application to request notification of its reservation request by setting <b>ConfirmRequest</b> to a nonzero value. Such notification is achieved when RSVP-aware devices in the data path between sender and receiver (or vice-versa) transmit an RESV CONFIRMATION message toward the requesting node. Note that an RSVP node is not required to automatically generate RESV CONFIRMATION messages.


### -field PolicyElementList

Pointer to the set of policy elements. Optional policy information, as provided in an <a href="https://docs.microsoft.com/windows/desktop/api/qossp/ns-qossp-rsvp_policy_info">RSVP_POLICY_INFO</a> structure.


### -field NumFlowDesc

Specifies the FLOWDESCRIPTOR count.


### -field FlowDescList

Pointer to the list of FLOWDESCRIPTORs.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/qos/ns-qos-qos_object_hdr">QOS_OBJECT_HDR</a>
 

 

