---
UID: NE:raseapif._RAS_AUTH_ATTRIBUTE_TYPE_
title: RAS_AUTH_ATTRIBUTE_TYPE (raseapif.h)
description: The RAS_AUTH_ATTRIBUTE_TYPE enumerated type specifies attribute values used for session authentication.
old-location: eap\ras_auth_attribute_type.htm
tech.root: EAP
ms.assetid: 0cb99318-2874-4945-ae32-cb5d90be9dee
ms.date: 12/05/2018
ms.keywords: RAS_AUTH_ATTRIBUTE_TYPE, RAS_AUTH_ATTRIBUTE_TYPE enumeration [EAP], _eap_ras_auth_attribute_type, eap.ras_auth_attribute_type, raatARAPChallengeResponse, raatARAPFeatures, raatARAPGuestLogon, raatARAPPassword, raatARAPSecurity, raatARAPSecurityData, raatARAPZoneAccess, raatAcctAuthentic, raatAcctDelayTime, raatAcctEventTimeStamp, raatAcctInputOctets, raatAcctInputPackets, raatAcctInterimInterval, raatAcctLinkCount, raatAcctMultiSessionId, raatAcctOutputOctets, raatAcctOutputPackets, raatAcctSessionId, raatAcctSessionTime, raatAcctStatusType, raatAcctTerminateCause, raatCallbackId, raatCallbackNumber, raatCalledStationId, raatCallingStationId, raatCertificateOID, raatClass, raatConfigurationToken, raatConnectInfo, raatEAPConfiguration, raatEAPMessage, raatEAPTLV, raatFilterId, raatFramedAppleTalkLink, raatFramedAppleTalkNetwork, raatFramedAppleTalkZone, raatFramedCompression, raatFramedIPAddress, raatFramedIPNetmask, raatFramedIPXNetwork, raatFramedMTU, raatFramedProtocol, raatFramedRoute, raatFramedRouting, raatIdleTimeout, raatLoginIPHost, raatLoginLATGroup, raatLoginLATNode, raatLoginLATPort, raatLoginLATService, raatLoginService, raatLoginTCPPort, raatMD5CHAPChallenge, raatMD5CHAPPassword, raatMinimum, raatNASIPAddress, raatNASIdentifier, raatNASPort, raatNASPortType, raatPEAPEmbeddedEAPTypeId, raatPEAPFastRoamedSession, raatPasswordRetry, raatPortLimit, raatPrompt, raatProxyState, raatReplyMessage, raatReserved, raatServiceType, raatSessionTimeout, raatSignature, raatState, raatTerminationAction, raatTunnelClientEndpoint, raatTunnelMediumType, raatTunnelServerEndpoint, raatTunnelType, raatUnassigned17, raatUnassigned21, raatUserName, raatUserPassword, raatVendorSpecific, raseapif/RAS_AUTH_ATTRIBUTE_TYPE, raseapif/raatARAPChallengeResponse, raseapif/raatARAPFeatures, raseapif/raatARAPGuestLogon, raseapif/raatARAPPassword, raseapif/raatARAPSecurity, raseapif/raatARAPSecurityData, raseapif/raatARAPZoneAccess, raseapif/raatAcctAuthentic, raseapif/raatAcctDelayTime, raseapif/raatAcctEventTimeStamp, raseapif/raatAcctInputOctets, raseapif/raatAcctInputPackets, raseapif/raatAcctInterimInterval, raseapif/raatAcctLinkCount, raseapif/raatAcctMultiSessionId, raseapif/raatAcctOutputOctets, raseapif/raatAcctOutputPackets, raseapif/raatAcctSessionId, raseapif/raatAcctSessionTime, raseapif/raatAcctStatusType, raseapif/raatAcctTerminateCause, raseapif/raatCallbackId, raseapif/raatCallbackNumber, raseapif/raatCalledStationId, raseapif/raatCallingStationId, raseapif/raatCertificateOID, raseapif/raatClass, raseapif/raatConfigurationToken, raseapif/raatConnectInfo, raseapif/raatEAPConfiguration, raseapif/raatEAPMessage, raseapif/raatEAPTLV, raseapif/raatFilterId, raseapif/raatFramedAppleTalkLink, raseapif/raatFramedAppleTalkNetwork, raseapif/raatFramedAppleTalkZone, raseapif/raatFramedCompression, raseapif/raatFramedIPAddress, raseapif/raatFramedIPNetmask, raseapif/raatFramedIPXNetwork, raseapif/raatFramedMTU, raseapif/raatFramedProtocol, raseapif/raatFramedRoute, raseapif/raatFramedRouting, raseapif/raatIdleTimeout, raseapif/raatLoginIPHost, raseapif/raatLoginLATGroup, raseapif/raatLoginLATNode, raseapif/raatLoginLATPort, raseapif/raatLoginLATService, raseapif/raatLoginService, raseapif/raatLoginTCPPort, raseapif/raatMD5CHAPChallenge, raseapif/raatMD5CHAPPassword, raseapif/raatMinimum, raseapif/raatNASIPAddress, raseapif/raatNASIdentifier, raseapif/raatNASPort, raseapif/raatNASPortType, raseapif/raatPEAPEmbeddedEAPTypeId, raseapif/raatPEAPFastRoamedSession, raseapif/raatPasswordRetry, raseapif/raatPortLimit, raseapif/raatPrompt, raseapif/raatProxyState, raseapif/raatReplyMessage, raseapif/raatReserved, raseapif/raatServiceType, raseapif/raatSessionTimeout, raseapif/raatSignature, raseapif/raatState, raseapif/raatTerminationAction, raseapif/raatTunnelClientEndpoint, raseapif/raatTunnelMediumType, raseapif/raatTunnelServerEndpoint, raseapif/raatTunnelType, raseapif/raatUnassigned17, raseapif/raatUnassigned21, raseapif/raatUserName, raseapif/raatUserPassword, raseapif/raatVendorSpecific
f1_keywords:
- raseapif/RAS_AUTH_ATTRIBUTE_TYPE
dev_langs:
- c++
req.header: raseapif.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Raseapif.h
api_name:
- RAS_AUTH_ATTRIBUTE_TYPE
targetos: Windows
req.typenames: RAS_AUTH_ATTRIBUTE_TYPE
req.redist: 
ms.custom: 19H1
---

# RAS_AUTH_ATTRIBUTE_TYPE enumeration


## -description


The 
<b>RAS_AUTH_ATTRIBUTE_TYPE</b> enumerated type specifies attribute values used for session authentication. Further details for values in this enumerated type are obtained by referring to one of the four following references: 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>, 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>, 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>, or 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84058">RFC 2868</a>.


## -enum-fields




### -field raatMinimum

Specifies a value equal to zero, and used as the <b>NULL</b> terminator in any array of 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> structures.


### -field raatUserName

Specifies the name of the user to be authenticated. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatUserPassword

Specifies the password of the user to be authenticated. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatMD5CHAPPassword

Specifies the password provided by the user in response to an MD5 Challenge Handshake Authentication Protocol (CHAP) challenge. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatNASIPAddress

Specifies the Network Access Server (NAS) IP address. An Access-Request should specify either an NAS IP address or an NAS identifier. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatNASPort

Specifies the physical or virtual private network (VPN) through which the user is connecting to the NAS. Note that this value is not a port number in the sense of TCP or UDP. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatServiceType

Specifies the type of service the user has requested or the type of service to be provided. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFramedProtocol

Specifies the type of framed protocol to use for framed access, for example SLIP, PPP, or ARAP (AppleTalk Remote Access Protocol). The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFramedIPAddress

Specifies the IP address that is configured for the user requesting authentication. This attribute is typically returned by the authentication provider. However, the NAS may use it in an authentication request to specify a preferred IP address. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFramedIPNetmask

Specifies the IP network mask for a user that is a router to a network. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFramedRouting

Specifies the routing method for a user that is a router to a network. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFilterId

Specifies the filter list for the user requesting authentication. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFramedMTU

Specifies the Maximum Transmission Unit (MTU) for the user. This attribute is used in cases where the MTU is not negotiated through some other means, such as PPP. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFramedCompression

Specifies a compression protocol to use for the connection. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatLoginIPHost

Specifies the system with which to connect the user. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatLoginService

Specifies the service to use to connect the user to the host specified by <b>raatLoginIPHost</b>. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatLoginTCPPort

Specifies the port to which to connect the user. This attribute is present only if the <b>raatLoginService</b> attribute is present. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatUnassigned17

This value is currently unassigned.


### -field raatReplyMessage

Specifies a message to display to the user. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatCallbackNumber

Specifies a callback number. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatCallbackId

Specifies a location to call back. The value of this attribute is interpreted by the NAS. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatUnassigned21

This value is currently unassigned. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is also undefined.


### -field raatFramedRoute

Specifies routing information to configure on the NAS for the user. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFramedIPXNetwork

Specifies the IPX network number to configure for the user. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatState

Specifies state information provided to the client by the server. Refer to 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a> for detailed information about this value. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer.


### -field raatClass

Specifies a value that is provided to the NAS by the authentication provider. The NAS should use this value when communicating with the accounting provider. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatVendorSpecific

Specifies a field for vendor-supplied extended attributes. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatSessionTimeout

Specifies the maximum number of seconds for which to provide service to the user. After this time, the session is terminated. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatIdleTimeout

Specifies the maximum number of consecutive seconds the session can be idle. If the idle time exceeds this value, the session is terminated. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatTerminationAction

Specifies an action the server performs when time the connection terminates. Refer to the above-referenced files for detailed information about this value. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatCalledStationId

Specifies the number that the user dialed to connect to the NAS. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatCallingStationId

Specifies the number from which the user is calling. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatNASIdentifier

Specifies the NAS identifier. An Access-Request should specify either an NAS identifier or an NAS IP address. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatProxyState

Specifies a value that a proxy server includes when forwarding an authentication request. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatLoginLATService

Specifies an attribute that is not currently used for authentication on Windows 2000. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatLoginLATNode

Specifies an attribute that is not currently used for authentication on Windows 2000. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatLoginLATGroup

Specifies an attribute that is not currently used for authentication on Windows 2000. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFramedAppleTalkLink

Specifies the AppleTalk network number for the user when the user is another router. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFramedAppleTalkNetwork

Specifies the AppleTalk network number that the NAS should use to allocate an AppleTalk node for the user. This attribute is used only when the user is not another router. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatFramedAppleTalkZone

Specifies the AppleTalk default zone for the user. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatAcctStatusType

Specifies whether the accounting provider should start or stop accounting for the user. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctDelayTime

Specifies the length of time that the client has been attempting to send the current request. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctInputOctets

Specifies the number of octets that have been received during the current accounting session. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctOutputOctets

Specifies the number of octets that were sent during the current accounting session. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctSessionId

Specifies a value to enable the identification of matching start and stop records within a log file. The start and stop records are sent in the <b>raatAcctStatusType</b> attribute. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctAuthentic

Specifies, to the accounting provider, how the user was authenticated; for example by Windows 2000 Directory Services, RADIUS, or some other authentication provider. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a>for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctSessionTime

Specifies the number of seconds that have elapsed in the current accounting session. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctInputPackets

Specifies the number of packets that have been received during the current accounting session. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctOutputPackets

Specifies the number of packets that have been sent during the current accounting session. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctTerminateCause

Specifies how the current accounting session was terminated. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctMultiSessionId

Specifies a value to enable the identification of related accounting sessions within a log file. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctLinkCount

Specifies the number of links if the current accounting session is using a multilink connection. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.


### -field raatAcctEventTimeStamp

Specifies an attribute that is included in an accounting request packet. It specifies the time that the event took place. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see the 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a> Internet draft.


### -field raatMD5CHAPChallenge

Specifies the CHAP challenge sent by the NAS to a CHAP user. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatNASPortType

Specifies the type of the port through which the user is connecting, for example, asynchronous, ISDN, virtual. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatPortLimit

Specifies the number of ports the NAS should make available to the user for multilink sessions. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatLoginLATPort

Specifies an attribute that is not currently used for authentication on Windows 2000. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field raatTunnelType

Specifies the tunneling protocol used. The following table lists valid tunnel types. 




<table>
<tr>
<th>Tunnel Type Value</th>
<th>Description</th>
</tr>
<tr>
<td>1</td>
<td>Point-to-Point Tunneling Protocol (PPTP)</td>
</tr>
<tr>
<td>2</td>
<td>Layer Two Forwarding (L2F)</td>
</tr>
<tr>
<td>3</td>
<td>Layer Two Tunneling Protocol (L2TP)</td>
</tr>
<tr>
<td>4</td>
<td>Ascend Tunnel Management Protocol (ATMP)</td>
</tr>
<tr>
<td>5</td>
<td>Virtual Tunneling Protocol (VTP)</td>
</tr>
<tr>
<td>6</td>
<td>IP Authentication Header in the Tunnel-mode</td>
</tr>
<tr>
<td>7</td>
<td>IP-in-IP Encapsulation (IP-IP)</td>
</tr>
<tr>
<td>8</td>
<td>Minimal IP-in-IP Encapsulation (MIN-IP-IP)</td>
</tr>
<tr>
<td>9</td>
<td>IP Encapsulating Security Payload in the Tunnel-mode (ESP)</td>
</tr>
<tr>
<td>10</td>
<td>Generic Route Encapsulation (GRE)</td>
</tr>
<tr>
<td>11</td>
<td>Bay Dial Virtual Services (DVS)</td>
</tr>
<tr>
<td>12</td>
<td>IP-in-IP Tunneling</td>
</tr>
</table>
 


### -field raatTunnelMediumType

Specifies which transport medium to use when creating a tunnel for those protocols (such as L2TP) that can operate over multiple transports. The following table lists valid medium types. 




<table>
<tr>
<th>Medium Type Value</th>
<th>Description</th>
</tr>
<tr>
<td>1</td>
<td>IPv4 (IP version 4)</td>
</tr>
<tr>
<td>2</td>
<td>IPv6 (IP version 6)</td>
</tr>
<tr>
<td>3</td>
<td>NSAP</td>
</tr>
<tr>
<td>4</td>
<td>HDLC (8-bit multidrop)</td>
</tr>
<tr>
<td>5</td>
<td>BBN 1822</td>
</tr>
<tr>
<td>6</td>
<td>802 (includes all 802 media plus Ethernet "canonical format")</td>
</tr>
<tr>
<td>7</td>
<td>E.163 (POTS)</td>
</tr>
<tr>
<td>8</td>
<td>E.164 (SMDS, Frame Relay, ATM)</td>
</tr>
<tr>
<td>9</td>
<td>F.69 (Telex)</td>
</tr>
<tr>
<td>10</td>
<td>X.121 (X.25, Frame Relay)</td>
</tr>
<tr>
<td>11</td>
<td>IPX</td>
</tr>
<tr>
<td>12</td>
<td>Appletalk</td>
</tr>
<tr>
<td>13</td>
<td>Decnet IV</td>
</tr>
<tr>
<td>14</td>
<td>Banyan Vines</td>
</tr>
<tr>
<td>15</td>
<td>E.164 with NSAP format subaddress</td>
</tr>
</table>
 


### -field raatTunnelClientEndpoint

Points to the address of the initiator end of the tunnel.


### -field raatTunnelServerEndpoint

Points to the address of the server end of the tunnel.


### -field raatARAPPassword

Specifies a password to use for AppleTalk Remote Access Protocol (ARAP) authentication. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a> .


### -field raatARAPFeatures

Specifies information that an NAS should send back to the user in an ARAP "feature flags" packet. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatARAPZoneAccess

Specifies how to use the ARAP zone list for the user. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatARAPSecurity

Specifies an ARAP security module to use during a secondary authentication phase between the NAS and the user. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatARAPSecurityData

Specifies the data to use with an ARAP security module. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatPasswordRetry

Specifies the number of password retry attempts to permit the user access. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value.


### -field raatPrompt

Specifies whether the NAS should echo the user response to a challenge. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatConnectInfo

Specifies information about the type of connection the user is using. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a Pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatConfigurationToken

Specifies user-profile information in communications between RADIUS Proxy Servers and RADIUS Proxy Clients. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatEAPMessage

Specifies that EAP information be sent directly between the user and the authentication provider. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatSignature

Specifies a signature to include with CHAP, EAP, or ARAP packets. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatARAPChallengeResponse

Specifies the response to a Apple Remote Access Protocol (ARAP) challenge. In ARAP, either the server or the client may respond to challenges. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a pointer. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatAcctInterimInterval

Specifies the time, in seconds, between accounting updates. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatNASIPv6Address


### -field raatFramedInterfaceId


### -field raatFramedIPv6Prefix


### -field raatLoginIPv6Host


### -field raatFramedIPv6Route


### -field raatFramedIPv6Pool


### -field raatARAPGuestLogon

Specifies a Apple Remote Access Protocol (ARAP) guest logon. The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is a 32-bit integral value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.


### -field raatCertificateOID

Reserved for internal use only.


### -field raatEAPConfiguration

Reserved for internal use only.


### -field raatPEAPEmbeddedEAPTypeId

Reserved for internal use only.


### -field raatInnerEAPTypeId


### -field raatPEAPFastRoamedSession

Reserved for internal use only.


### -field raatFastRoamedSession


### -field raatEAPTLV

Indicates and EAP-TLV attribute.


### -field raatCredentialsChanged


### -field raatCertificateThumbprint


### -field raatPeerId


### -field raatServerId


### -field raatMethodId


### -field raatEMSK


### -field raatSessionId


### -field raatReserved

The value field in 
<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a> for this type is undefined.


## -see-also




[EAP Enumerations](https://docs.microsoft.com/windows/win32/eap/eap-enumerations)a>



[Extensible Authentication Protocol Reference](https://docs.microsoft.com/windows/win32/eap/extensible-authentication-protocol-reference)a>



<a href="https://docs.microsoft.com/windows/desktop/api/raseapif/ns-raseapif-ras_auth_attribute">RAS_AUTH_ATTRIBUTE</a>
 

 

