---
UID: NF:rdpencomapi.IRDPSRAPIViewer.Connect
title: IRDPSRAPIViewer::Connect (rdpencomapi.h)
description: Starts the actual connection to the sharer.
old-location: rdp\irdpsrapiviewer_connect.htm
tech.root: rdp
ms.assetid: f3deec96-af56-4ebe-a5c3-25a4c7be14c0
ms.date: 12/05/2018
ms.keywords: Connect, Connect method [RDP], Connect method [RDP],IRDPSRAPIViewer interface, IRDPSRAPIViewer interface [RDP],Connect method, IRDPSRAPIViewer.Connect, IRDPSRAPIViewer::Connect, rdp.irdpsrapiviewer_connect, rdpencomapi/IRDPSRAPIViewer::Connect
f1_keywords:
- rdpencomapi/IRDPSRAPIViewer.Connect
dev_langs:
- c++
req.header: rdpencomapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: RdpEncomAPI.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: RdpEncomAPI.tlb
req.lib: 
req.dll: RdpEncom.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- RdpEncom.dll
api_name:
- IRDPSRAPIViewer.Connect
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IRDPSRAPIViewer::Connect


## -description


<p class="CCE_Message">[The <a href="https://docs.microsoft.com/windows/desktop/api/rdpencomapi/nn-rdpencomapi-irdpsrapiviewer">IRDPSRAPIViewer</a> interface is no longer available for use for UWP applications as of Windows 10, version 1709. It is still supported for Desktop apps.]

Starts the actual connection to the sharer.


## -parameters




### -param bstrConnectionString [in]

Type: <b>BSTR</b>

The connection string used to connect to the sharer and authenticate the viewer.


### -param bstrName [in]

Type: <b>BSTR</b>

Name for the viewer. The name is sent to the sharer and other viewers. The string is limited to 255 characters.


### -param bstrPassword [in]

Type: <b>BSTR</b>

Password used for authentication. The password is sent out-of-band from the sharer.


## -returns



Type: <b>HRESULT</b>

If the method succeeds, the return value is <b>S_OK</b>. Otherwise, the return value is an error code.




## -remarks



The connection string contained in the <i>bstrConnectionString</i> parameter is generated by the sharer and obtained by the viewer by completing the following steps:

<ol>
<li>The sharer obtains an instance of the <a href="https://docs.microsoft.com/windows/desktop/api/rdpencomapi/nn-rdpencomapi-irdpsrapiinvitationmanager">IRDPSRAPIInvitationManager</a> interface from the <a href="https://docs.microsoft.com/windows/desktop/api/rdpencomapi/nf-rdpencomapi-irdpsrapisharingsession-get_invitations">IRDPSRAPISharingSession::Invitations</a> property.</li>
<li>The sharer obtains an instance of the <a href="https://docs.microsoft.com/windows/desktop/api/rdpencomapi/nn-rdpencomapi-irdpsrapiinvitation">IRDPSRAPIInvitation</a> interface by calling the <a href="https://docs.microsoft.com/windows/desktop/api/rdpencomapi/nf-rdpencomapi-irdpsrapiinvitationmanager-createinvitation">IRDPSRAPIInvitationManager::CreateInvitation</a> method.</li>
<li>The sharer obtains the connection string from the <a href="https://docs.microsoft.com/windows/desktop/api/rdpencomapi/nf-rdpencomapi-irdpsrapiinvitation-get_connectionstring">IRDPSRAPIInvitation::ConnectionString</a> property.</li>
<li>The sharer sends the connection string to the viewer in an application-defined method, such as storing the connection string in a file and sharing the file with the viewer.</li>
</ol>
For increased security, applications can associate passwords with an invitation on the sharer side. Such passwords are usually distributed to viewers through some mechanism other than the one that is used to send the connection string. This is to prevent network "sniffing" types of attacks. If an invitation has a password associated with it, the password must be passed in through this API. Otherwise, the attendee will be disconnected.

The <i>bstrName</i> string that is set in this property is sent to the sharer after the connection is started. The property is a friendly name that the sharer application can choose to display. The property is useful when an invitation is used to authenticate multiple attendees because it allows the sharer and the other viewers to identify who is participating in a Windows Desktop Sharing session.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/rdpencomapi/nn-rdpencomapi-irdpsrapiviewer">IRDPSRAPIViewer</a>
 

 

