---
UID: NE:resapi._CLUSTER_ROLE
title: CLUSTER_ROLE (resapi.h)
description: Contains the names of the standard cluster roles.
old-location: mscs\cluster_role.htm
tech.root: MsCS
ms.assetid: 65fc8a8f-0a9e-464c-b62a-d2e61431d927
ms.date: 12/05/2018
ms.keywords: CLUSTER_ROLE, CLUSTER_ROLE enumeration [Failover Cluster], ClusterRoleDFSReplicatedFolder, ClusterRoleDHCP, ClusterRoleDTC, ClusterRoleDistributedFileSystem, ClusterRoleDistributedNetworkName, ClusterRoleFileServer, ClusterRoleFileShare, ClusterRoleFileShareWitness, ClusterRoleGenericApplication, ClusterRoleGenericScript, ClusterRoleGenericService, ClusterRoleHardDisk, ClusterRoleIPAddress, ClusterRoleIPV6Address, ClusterRoleIPV6TunnelAddress, ClusterRoleISCSINameServer, ClusterRoleISCSITargetServer, ClusterRoleMSMQ, ClusterRoleNFS, ClusterRoleNetworkFileSystem, ClusterRoleNetworkName, ClusterRolePhysicalDisk, ClusterRolePrintServer, ClusterRoleSODAFileServer, ClusterRoleStandAloneNamespaceServer, ClusterRoleStoragePool, ClusterRoleTaskScheduler, ClusterRoleVirtualMachine, ClusterRoleVirtualMachineConfiguration, ClusterRoleVirtualMachineReplicaBroker, ClusterRoleVolumeShadowCopyServiceTask, ClusterRoleWINS, mscs.cluster_role, resapi/CLUSTER_ROLE, resapi/ClusterRoleDFSReplicatedFolder, resapi/ClusterRoleDHCP, resapi/ClusterRoleDTC, resapi/ClusterRoleDistributedFileSystem, resapi/ClusterRoleDistributedNetworkName, resapi/ClusterRoleFileServer, resapi/ClusterRoleFileShare, resapi/ClusterRoleFileShareWitness, resapi/ClusterRoleGenericApplication, resapi/ClusterRoleGenericScript, resapi/ClusterRoleGenericService, resapi/ClusterRoleHardDisk, resapi/ClusterRoleIPAddress, resapi/ClusterRoleIPV6Address, resapi/ClusterRoleIPV6TunnelAddress, resapi/ClusterRoleISCSINameServer, resapi/ClusterRoleISCSITargetServer, resapi/ClusterRoleMSMQ, resapi/ClusterRoleNFS, resapi/ClusterRoleNetworkFileSystem, resapi/ClusterRoleNetworkName, resapi/ClusterRolePhysicalDisk, resapi/ClusterRolePrintServer, resapi/ClusterRoleSODAFileServer, resapi/ClusterRoleStandAloneNamespaceServer, resapi/ClusterRoleStoragePool, resapi/ClusterRoleTaskScheduler, resapi/ClusterRoleVirtualMachine, resapi/ClusterRoleVirtualMachineConfiguration, resapi/ClusterRoleVirtualMachineReplicaBroker, resapi/ClusterRoleVolumeShadowCopyServiceTask, resapi/ClusterRoleWINS
f1_keywords:
- resapi/CLUSTER_ROLE
dev_langs:
- c++
req.header: resapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Datacenter, Windows Server 2008 Enterprise
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ResApi.h
api_name:
- CLUSTER_ROLE
targetos: Windows
req.typenames: CLUSTER_ROLE
req.redist: 
ms.custom: 19H1
---

# CLUSTER_ROLE enumeration


## -description


Contains the names of the standard cluster roles.


## -enum-fields




### -field ClusterRoleDHCP

The DHCP cluster role.


### -field ClusterRoleDTC

The Distributed Transaction Coordinator (MSDTC) role.


### -field ClusterRoleFileServer

The file share role.


### -field ClusterRoleGenericApplication

The Generic Application role.


### -field ClusterRoleGenericScript

The Generic Script role.


### -field ClusterRoleGenericService

The Generic Service role.


### -field ClusterRoleISCSINameServer

The Microsoft Internet Storage Name Service (iSNS) role.


### -field ClusterRoleMSMQ

The Microsoft Message Queue role.


### -field ClusterRoleNFS

The Network File System (NFS) Share role.


### -field ClusterRolePrintServer

The Print Spooler cluster role.


### -field ClusterRoleStandAloneNamespaceServer

The specialized File Share role.


### -field ClusterRoleVolumeShadowCopyServiceTask

The Volume Shadow Copy Service Task role.


### -field ClusterRoleWINS

The WINS Service role.


### -field ClusterRoleTaskScheduler

The Task Scheduler role.


### -field ClusterRoleNetworkFileSystem

The network file system role.


### -field ClusterRoleDFSReplicatedFolder

The Distributed File System (DFS) replicated folder role.


### -field ClusterRoleDistributedFileSystem

The Distributed File System (DFS) role.


### -field ClusterRoleDistributedNetworkName

The Distributed Network Name role.


### -field ClusterRoleFileShare

The file share role.


### -field ClusterRoleFileShareWitness

The file share witness role


### -field ClusterRoleHardDisk

The hard disk role.


### -field ClusterRoleIPAddress

The IP address role.


### -field ClusterRoleIPV6Address

The IPV6 address role.


### -field ClusterRoleIPV6TunnelAddress

The IPV6 tunnel address role.


### -field ClusterRoleISCSITargetServer

The ISCSI Target Server role.


### -field ClusterRoleNetworkName

The Network Name role.


### -field ClusterRolePhysicalDisk

The physical disk role.


### -field ClusterRoleSODAFileServer

The Scale-Out (SODA) File Server role


### -field ClusterRoleStoragePool

The storage pool role.


### -field ClusterRoleVirtualMachine

The virtual machine role.


### -field ClusterRoleVirtualMachineConfiguration

The virtual machine configuration role.


### -field ClusterRoleVirtualMachineReplicaBroker

The virtual machine replica broker role.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/resapi/nf-resapi-resutilgetclusterrolestate">ResUtilGetClusterRoleState</a>
 

 

