---
UID: NS:richedit.CHARFORMAT2W
title: CHARFORMAT2W (richedit.h)
description: Contains information about character formatting in a rich edit control.
old-location: controls\CHARFORMAT2.htm
tech.root: Controls
ms.assetid: VS|Controls|~\controls\richedit\richeditcontrols\richeditcontrolreference\richeditstructures\charformat2.htm
ms.date: 12/05/2018
ms.keywords: CFE_ALLCAPS, CFE_AUTOBACKCOLOR, CFE_AUTOCOLOR, CFE_BOLD, CFE_DISABLED, CFE_EMBOSS, CFE_EXTENDED, CFE_FONTBOUND, CFE_HIDDEN, CFE_IMPRINT, CFE_ITALIC, CFE_LINK, CFE_LINKPROTECTED, CFE_MATH, CFE_MATHNOBUILDUP, CFE_MATHORDINARY, CFE_OUTLINE, CFE_PROTECTED, CFE_REVISED, CFE_SHADOW, CFE_SMALLCAPS, CFE_STRIKEOUT, CFE_SUBSCRIPT, CFE_SUPERSCRIPT, CFE_UNDERLINE, CFM_ALL, CFM_ALL2, CFM_ALLCAPS, CFM_ANIMATION, CFM_BACKCOLOR, CFM_BOLD, CFM_CHARSET, CFM_COLOR, CFM_COOKIE, CFM_DISABLED, CFM_EFFECTS, CFM_EFFECTS2, CFM_EMBOSS, CFM_EXTENDED, CFM_FACE, CFM_FONTBOUND, CFM_HIDDEN, CFM_IMPRINT, CFM_ITALIC, CFM_KERNING, CFM_LCID, CFM_LINK, CFM_LINKPROTECTED, CFM_MATH, CFM_MATHNOBUILDUP, CFM_MATHORDINARY, CFM_OFFSET, CFM_OUTLINE, CFM_PROTECTED, CFM_REVAUTHOR, CFM_REVISED, CFM_SHADOW, CFM_SIZE, CFM_SMALLCAPS, CFM_SPACING, CFM_STRIKEOUT, CFM_STYLE, CFM_SUBSCRIPT, CFM_SUPERSCRIPT, CFM_UNDERLINE, CFM_UNDERLINETYPE, CFM_WEIGHT, CFU_CF1UNDERLINE, CFU_INVERT, CFU_UNDERLINE, CFU_UNDERLINEDASH, CFU_UNDERLINEDASHDOT, CFU_UNDERLINEDASHDOTDOT, CFU_UNDERLINEDOTTED, CFU_UNDERLINEDOUBLE, CFU_UNDERLINEDOUBLEWAVE, CFU_UNDERLINEHAIRLINE, CFU_UNDERLINEHEAVYWAVE, CFU_UNDERLINELONGDASH, CFU_UNDERLINENONE, CFU_UNDERLINETHICK, CFU_UNDERLINETHICKDASH, CFU_UNDERLINETHICKDASHDOT, CFU_UNDERLINETHICKDASHDOTDOT, CFU_UNDERLINETHICKDOTTED, CFU_UNDERLINETHICKLONGDASH, CFU_UNDERLINEWAVE, CFU_UNDERLINEWORD, CHARFORMAT2, CHARFORMAT2 structure [Windows Controls], CHARFORMAT2A, CHARFORMAT2W, _win32_CHARFORMAT2_str, _win32_CHARFORMAT2_str_cpp, controls.CHARFORMAT2, controls._win32_CHARFORMAT2_str, richedit/CHARFORMAT2, richedit/CHARFORMAT2A, richedit/CHARFORMAT2W
f1_keywords:
- richedit/CHARFORMAT2
dev_langs:
- c++
req.header: richedit.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: CHARFORMAT2W (Unicode) and CHARFORMAT2A (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Richedit.h
api_name:
- CHARFORMAT2
- CHARFORMAT2A
- CHARFORMAT2W
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CHARFORMAT2W structure


## -description


Contains information about character formatting in a rich edit control.<b>CHARFORMAT2</b> is a Microsoft Rich Edit 2.0 extension of the <a href="https://msdn.microsoft.com/7b31e42a-5e9b-46bf-9c4e-fd223c34a076">CHARFORMAT</a> structure. Microsoft Rich Edit 2.0 allows you to use either structure with the <a href="https://msdn.microsoft.com/210b8719-5ed7-49f2-bd93-8a4e1efab1e8">EM_GETCHARFORMAT</a> and <a href="https://msdn.microsoft.com/5e7a545d-4ca4-4dc6-badb-584c11194982">EM_SETCHARFORMAT</a> messages. 


## -struct-fields




### -field wWeight

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">WORD</a></b>

Font weight. This member is the same as the <b>lfWeight</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/ns-wingdi-logfonta">LOGFONT</a> structure. To use this member, set the <b>CFM_WEIGHT</b> flag in the <b>dwMask</b> member. 


### -field sSpacing

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">SHORT</a></b>

Horizontal space between letters, in twips. This value has no effect on the text displayed by a rich edit control; it is included for compatibility with Windows TOM interfaces. To use this member, set the <b>CFM_SPACING</b> flag in the <b>dwMask</b> member. 


### -field crBackColor

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">COLORREF</a></b>

Background color. To use this member, set the <b>CFM_BACKCOLOR</b> flag in the <b>dwMask</b> member. This member is ignored if the <b>CFE_AUTOBACKCOLOR</b> character effect is specified. To generate a , use the  macro. 


### -field lcid

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">LCID</a></b>

A 32-bit locale identifier that contains a language identifier in the lower word and a sorting identifier and reserved value in the upper word. This member has no effect on the text displayed by a rich edit control, but spelling and grammar checkers can use it to deal with language-dependent problems. You can use the  macro to create an <b>LCID</b> value. To use this member, set the <b>CFM_LCID</b> flag in the <b>dwMask</b> member. 


### -field dwCookie

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">DWORD</a></b>

Client cookie. This member is opaque to a rich edit control.


### -field dwReserved

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">DWORD</a></b>

Reserved; the value must be zero. 

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">DWORD</a></b>

Reserved; the value must be zero. 


### -field sStyle

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">SHORT</a></b>

Character style handle. This value has no effect on the text displayed by a rich edit control; it is included for compatibility with WindowsTOM  interfaces. To use this member, set the <b>CFM_STYLE</b> flag in the <b>dwMask</b> member. For more information see the TOM documentation. 


### -field wKerning

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">WORD</a></b>

Value of the font size, above which to kern the character (<b>yHeight</b>). This value has no effect on the text displayed by a rich edit control; it is included for compatibility with TOM interfaces. To use this member, set the <b>CFM_KERNING</b> flag in the <b>dwMask</b> member. 


### -field bUnderlineType

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">BYTE</a></b>

Specifies the underline type. To use this member, set the <b>CFM_UNDERLINETYPE</b> flag in the <b>dwMask</b> member. This member can be one of the following values. 

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="CFU_CF1UNDERLINE"></a><a id="cfu_cf1underline"></a><dl>
<dt><b>CFU_CF1UNDERLINE</b></dt>
</dl>
</td>
<td width="60%">
The structure maps <a href="https://msdn.microsoft.com/7b31e42a-5e9b-46bf-9c4e-fd223c34a076">CHARFORMAT</a>'s bit underline to <b>CHARFORMAT2</b>, (that is, it performs a <b>CHARFORMAT</b> type of underline on this text). 

</td>
</tr>
<tr>
<td width="40%"><a id="CFU_INVERT"></a><a id="cfu_invert"></a><dl>
<dt><b>CFU_INVERT</b></dt>
</dl>
</td>
<td width="60%">
For IME composition, fake a selection. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINE"></a><a id="cfu_underline"></a><dl>
<dt><b>CFU_UNDERLINE</b></dt>
</dl>
</td>
<td width="60%">
Text underlined with a single solid line.

</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINEDASH"></a><a id="cfu_underlinedash"></a><dl>
<dt><b>CFU_UNDERLINEDASH</b></dt>
</dl>
</td>
<td width="60%">
Text underlined with dashes.

</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINEDASHDOT"></a><a id="cfu_underlinedashdot"></a><dl>
<dt><b>CFU_UNDERLINEDASHDOT</b></dt>
</dl>
</td>
<td width="60%">
Text underlined with a dashed and dotted line.

</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINEDASHDOTDOT"></a><a id="cfu_underlinedashdotdot"></a><dl>
<dt><b>CFU_UNDERLINEDASHDOTDOT</b></dt>
</dl>
</td>
<td width="60%">
Text underlined with a dashed and doubled dotted line.

</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINEDOTTED"></a><a id="cfu_underlinedotted"></a><dl>
<dt><b>CFU_UNDERLINEDOTTED</b></dt>
</dl>
</td>
<td width="60%">
Text underlined with a dotted line. For versions earlier than Microsoft Rich Edit 3.0, text is displayed with a solid underline.

</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINEDOUBLE"></a><a id="cfu_underlinedouble"></a><dl>
<dt><b>CFU_UNDERLINEDOUBLE</b></dt>
</dl>
</td>
<td width="60%">
Text underlined with a double line. The rich edit control displays the text with a solid underline.

</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINEDOUBLEWAVE"></a><a id="cfu_underlinedoublewave"></a><dl>
<dt><b>CFU_UNDERLINEDOUBLEWAVE</b></dt>
</dl>
</td>
<td width="60%">
Display as <b>CFU_UNDERLINEWAVE</b>. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINEHAIRLINE"></a><a id="cfu_underlinehairline"></a><dl>
<dt><b>CFU_UNDERLINEHAIRLINE</b></dt>
</dl>
</td>
<td width="60%">
Display as <b>CFU_UNDERLINE</b>. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINEHEAVYWAVE"></a><a id="cfu_underlineheavywave"></a><dl>
<dt><b>CFU_UNDERLINEHEAVYWAVE</b></dt>
</dl>
</td>
<td width="60%">
Display as <b>CFU_UNDERLINEWAVE</b>. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINELONGDASH"></a><a id="cfu_underlinelongdash"></a><dl>
<dt><b>CFU_UNDERLINELONGDASH</b></dt>
</dl>
</td>
<td width="60%">
Display as <b>CFU_UNDERLINEDASH</b>. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINENONE"></a><a id="cfu_underlinenone"></a><dl>
<dt><b>CFU_UNDERLINENONE</b></dt>
</dl>
</td>
<td width="60%">
No underline. This is the default.

</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINETHICK"></a><a id="cfu_underlinethick"></a><dl>
<dt><b>CFU_UNDERLINETHICK</b></dt>
</dl>
</td>
<td width="60%">
Display as <b>CFU_UNDERLINE</b>. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINETHICKDASH"></a><a id="cfu_underlinethickdash"></a><dl>
<dt><b>CFU_UNDERLINETHICKDASH</b></dt>
</dl>
</td>
<td width="60%">
Display as <b>CFU_UNDERLINEDASH</b>. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINETHICKDASHDOT"></a><a id="cfu_underlinethickdashdot"></a><dl>
<dt><b>CFU_UNDERLINETHICKDASHDOT</b></dt>
</dl>
</td>
<td width="60%">
Display as <b>CFU_UNDERLINEDASHDOT</b>. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINETHICKDASHDOTDOT"></a><a id="cfu_underlinethickdashdotdot"></a><dl>
<dt><b>CFU_UNDERLINETHICKDASHDOTDOT</b></dt>
</dl>
</td>
<td width="60%">
Display as <b>CFU_UNDERLINEDASHDOT</b>. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINETHICKDOTTED"></a><a id="cfu_underlinethickdotted"></a><dl>
<dt><b>CFU_UNDERLINETHICKDOTTED</b></dt>
</dl>
</td>
<td width="60%">
Display as <b>CFU_UNDERLINEDOT</b>. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINETHICKLONGDASH"></a><a id="cfu_underlinethicklongdash"></a><dl>
<dt><b>CFU_UNDERLINETHICKLONGDASH</b></dt>
</dl>
</td>
<td width="60%">
Display as <b>CFU_UNDERLINEDASH</b>. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINEWAVE"></a><a id="cfu_underlinewave"></a><dl>
<dt><b>CFU_UNDERLINEWAVE</b></dt>
</dl>
</td>
<td width="60%">
<b>RichEdit 4.1 and later</b>: Text underlined with a wavy line.

</td>
</tr>
<tr>
<td width="40%"><a id="CFU_UNDERLINEWORD"></a><a id="cfu_underlineword"></a><dl>
<dt><b>CFU_UNDERLINEWORD</b></dt>
</dl>
</td>
<td width="60%">
<b>RichEdit 4.1 and later</b>: Underline words only. The rich edit control displays the text with a solid underline.

</td>
</tr>
</table>
 


### -field bAnimation

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">BYTE</a></b>

Text animation type. This value has no effect on the text displayed by a rich edit control; it is included for compatibility with TOM interfaces. To use this member, set the <b>CFM_ANIMATION</b> flag in the <b>dwMask</b> member. 


### -field bRevAuthor

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">BYTE</a></b>

An index that identifies the author making a revision. The rich edit control uses different text colors for each different author index. To use this member, set the <b>CFM_REVAUTHOR</b> flag in the <b>dwMask</b> member. 


### -field bUnderlineColor

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">BYTE</a></b>

Underline color. 


### -field _charformatw

 




#### - bCharSet

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">BYTE</a></b>

Character set value. It can be one of the values specified for the <b>lfCharSet</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/ns-wingdi-logfonta">LOGFONT</a> structure. To use this member, set the <b>CFM_CHARSET</b> flag in the <b>dwMask</b> member. 


#### - bPitchAndFamily

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">BYTE</a></b>

Specifies the font family and pitch. This member is the same as the <b>lfPitchAndFamily</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/ns-wingdi-logfonta">LOGFONT</a> structure. 


#### - cbSize

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">UINT</a></b>

Specifies the size, in bytes, of the structure. Before passing this structure to a rich edit control, set <b>cbSize</b> to the size of the <a href="https://msdn.microsoft.com/7b31e42a-5e9b-46bf-9c4e-fd223c34a076">CHARFORMAT</a> or <b>CHARFORMAT2</b> structure. If <b>cbSize</b> equals the size of a <b>CHARFORMAT</b> structure, the control uses only the <b>CHARFORMAT</b> members. 


#### - crTextColor

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">COLORREF</a></b>

Text color. To use this member, set the <b>CFM_COLOR</b> flag in the <b>dwMask</b> member. This member is ignored if the <b>CFE_AUTOCOLOR</b> character effect is specified. To generate a <a href="https://docs.microsoft.com/windows/desktop/gdi/colorref">COLORREF</a>, use the <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-rgb">RGB</a> macro. 


#### - dwEffects

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">DWORD</a></b>

A set of bit flags that specify character effects. Some of the flags are included only for compatibility with Microsoft <a href="https://msdn.microsoft.com/a15f0334-1a31-4bc3-bc1e-e5cf53112007">Text Object Model</a> (TOM) interfaces; the rich edit control stores the value but does not use it to display text.
                

This member can be a combination of the following values.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="CFE_ALLCAPS"></a><a id="cfe_allcaps"></a><dl>
<dt><b>CFE_ALLCAPS</b></dt>
</dl>
</td>
<td width="60%">
Characters are all capital letters. The value does not affect the way the control displays the text. This value applies only to versions earlier than Microsoft Rich Edit 3.0. 

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_AUTOBACKCOLOR"></a><a id="cfe_autobackcolor"></a><dl>
<dt><b>CFE_AUTOBACKCOLOR</b></dt>
</dl>
</td>
<td width="60%">
The background color is the return value of <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-getsyscolor">GetSysColor</a>(<b>COLOR_WINDOW</b>). If this flag is set, <b>crBackColor</b> member is ignored.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_AUTOCOLOR"></a><a id="cfe_autocolor"></a><dl>
<dt><b>CFE_AUTOCOLOR</b></dt>
</dl>
</td>
<td width="60%">
The text color is the return value of <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-getsyscolor">GetSysColor</a>(<b>COLOR_WINDOWTEXT</b>). If this flag is set, the <b>crTextColor</b> member is ignored.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_BOLD"></a><a id="cfe_bold"></a><dl>
<dt><b>CFE_BOLD</b></dt>
</dl>
</td>
<td width="60%">
Characters are bold.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_DISABLED"></a><a id="cfe_disabled"></a><dl>
<dt><b>CFE_DISABLED</b></dt>
</dl>
</td>
<td width="60%">
Characters are displayed with a shadow that is offset by 3/4 point or one pixel, whichever is larger.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_EMBOSS"></a><a id="cfe_emboss"></a><dl>
<dt><b>CFE_EMBOSS</b></dt>
</dl>
</td>
<td width="60%">
Characters are embossed. The value does not affect how the control displays the text. 

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_EXTENDED"></a><a id="cfe_extended"></a><dl>
<dt><b>CFE_EXTENDED</b></dt>
</dl>
</td>
<td width="60%">
The characters are less common members of a script. A font that supports a script should check if it has glyphs for such characters.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_FONTBOUND"></a><a id="cfe_fontbound"></a><dl>
<dt><b>CFE_FONTBOUND</b></dt>
</dl>
</td>
<td width="60%">
Font is chosen by the rich edit control because the active font doesn’t support the characters. This process is called font binding.


</td>
</tr>
<tr>
<td width="40%"><a id="CFE_HIDDEN"></a><a id="cfe_hidden"></a><dl>
<dt><b>CFE_HIDDEN</b></dt>
</dl>
</td>
<td width="60%">
For Microsoft Rich Edit 3.0 and later, characters are not displayed. 

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_IMPRINT"></a><a id="cfe_imprint"></a><dl>
<dt><b>CFE_IMPRINT</b></dt>
</dl>
</td>
<td width="60%">
Characters are displayed as imprinted characters. The value does not affect how the control displays the text. 

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_ITALIC"></a><a id="cfe_italic"></a><dl>
<dt><b>CFE_ITALIC</b></dt>
</dl>
</td>
<td width="60%">
Characters are italic.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_LINK"></a><a id="cfe_link"></a><dl>
<dt><b>CFE_LINK</b></dt>
</dl>
</td>
<td width="60%">
A rich edit control can send <a href="https://msdn.microsoft.com/67f02908-957e-4d91-8a70-70399ce9cf2e">EN_LINK</a> notification codes when it receives mouse messages while the mouse pointer is over text with the <b>CFE_LINK</b> effect.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_LINKPROTECTED"></a><a id="cfe_linkprotected"></a><dl>
<dt><b>CFE_LINKPROTECTED</b></dt>
</dl>
</td>
<td width="60%">
Characters are part of a friendly name link.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_MATH"></a><a id="cfe_math"></a><dl>
<dt><b>CFE_MATH</b></dt>
</dl>
</td>
<td width="60%">
Characters are in a math zone.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_MATHNOBUILDUP"></a><a id="cfe_mathnobuildup"></a><dl>
<dt><b>CFE_MATHNOBUILDUP</b></dt>
</dl>
</td>
<td width="60%">
Characters do not participate in a math build up. For example, when applied to a /, the / will not be used to build up a fraction.


</td>
</tr>
<tr>
<td width="40%"><a id="CFE_MATHORDINARY"></a><a id="cfe_mathordinary"></a><dl>
<dt><b>CFE_MATHORDINARY</b></dt>
</dl>
</td>
<td width="60%">
Characters are displayed as ordinary text within a math zone.


</td>
</tr>
<tr>
<td width="40%"><a id="CFE_OUTLINE"></a><a id="cfe_outline"></a><dl>
<dt><b>CFE_OUTLINE</b></dt>
</dl>
</td>
<td width="60%">
Characters are displayed as outlined characters. The value does not affect how the control displays the text. 

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_PROTECTED"></a><a id="cfe_protected"></a><dl>
<dt><b>CFE_PROTECTED</b></dt>
</dl>
</td>
<td width="60%">
Characters are protected; an attempt to modify them will cause an <a href="https://msdn.microsoft.com/29c0cb51-675c-44b1-ad45-5f7140ca5675">EN_PROTECTED</a> notification code.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_REVISED"></a><a id="cfe_revised"></a><dl>
<dt><b>CFE_REVISED</b></dt>
</dl>
</td>
<td width="60%">
Characters are marked as revised.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_SHADOW"></a><a id="cfe_shadow"></a><dl>
<dt><b>CFE_SHADOW</b></dt>
</dl>
</td>
<td width="60%">
Characters are displayed as shadowed characters. The value does not affect how the control displays the text. 

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_SMALLCAPS"></a><a id="cfe_smallcaps"></a><dl>
<dt><b>CFE_SMALLCAPS</b></dt>
</dl>
</td>
<td width="60%">
Characters are in small capital letters. The value does not affect how the control displays the text. 

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_STRIKEOUT"></a><a id="cfe_strikeout"></a><dl>
<dt><b>CFE_STRIKEOUT</b></dt>
</dl>
</td>
<td width="60%">
Characters are struck out.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_SUBSCRIPT"></a><a id="cfe_subscript"></a><dl>
<dt><b>CFE_SUBSCRIPT</b></dt>
</dl>
</td>
<td width="60%">
Characters are subscript. The <b>CFE_SUPERSCRIPT</b> and <b>CFE_SUBSCRIPT</b> values are mutually exclusive. For both values, the control automatically calculates an offset and a smaller font size. Alternatively, you can use the <b>yHeight</b> and <b>yOffset</b> members to explicitly specify font size and offset for subscript and superscript characters.

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_SUPERSCRIPT"></a><a id="cfe_superscript"></a><dl>
<dt><b>CFE_SUPERSCRIPT</b></dt>
</dl>
</td>
<td width="60%">
Characters are superscript. 

</td>
</tr>
<tr>
<td width="40%"><a id="CFE_UNDERLINE"></a><a id="cfe_underline"></a><dl>
<dt><b>CFE_UNDERLINE</b></dt>
</dl>
</td>
<td width="60%">
Characters are underlined.

</td>
</tr>
</table>
 


#### - dwMask

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">DWORD</a></b>

Specifies the parts of the <b>CHARFORMAT2</b> structure that contain valid information. The 
					<b>dwMask</b> member can be a combination of the values from two sets of bit flags. One set indicates the structure members that are valid. Another set indicates the valid attributes in the 
					<b>dwEffects</b> member. 
                    


Set the following values to indicate the valid attributes of the <b>dwEffects</b> member.



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="CFM_ALL"></a><a id="cfm_all"></a><dl>
<dt><b>CFM_ALL</b></dt>
</dl>
</td>
<td width="60%">
 A combination of the following values: <b>CFM_EFFECTS</b> | <b>CFM_SIZE</b> | <b>CFM_FACE</b> | <b>CFM_OFFSET</b> | <b>CFM_CHARSET</b>

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_ALL2"></a><a id="cfm_all2"></a><dl>
<dt><b>CFM_ALL2</b></dt>
</dl>
</td>
<td width="60%">
A combination of the following values: <b>CFM_ALL</b> | <b>CFM_EFFECTS2</b> | <b>CFM_BACKCOLOR</b> | <b>CFM_LCID</b> | <b>CFM_UNDERLINETYPE</b> | <b>CFM_WEIGHT</b> | <b>CFM_REVAUTHOR</b> | <b>CFM_SPACING</b> | <b>CFM_KERNING</b> | <b>CFM_STYLE</b> | <b>CFM_ANIMATION</b> | <b>CFM_COOKIE</b>

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_ALLCAPS"></a><a id="cfm_allcaps"></a><dl>
<dt><b>CFM_ALLCAPS</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_ALLCAPS</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_EFFECTS"></a><a id="cfm_effects"></a><dl>
<dt><b>CFM_EFFECTS</b></dt>
</dl>
</td>
<td width="60%">
 A combination of the following values: <b>CFM_EFFECTS2</b> | <b>CFM_FONTBOUND</b> | <b>CFM_EXTENDED</b> | <b>CFM_MATHNOBUILDUP</b> | <b>CFM_MATH</b> | <b>CFM_MATHORDINARY</b>

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_BOLD"></a><a id="cfm_bold"></a><dl>
<dt><b>CFM_BOLD</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_BOLD</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_COLOR"></a><a id="cfm_color"></a><dl>
<dt><b>CFM_COLOR</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_AUTOCOLOR</b> value is valid, or the 
									<b>crTextColor</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_COOKIE"></a><a id="cfm_cookie"></a><dl>
<dt><b>CFM_COOKIE</b></dt>
</dl>
</td>
<td width="60%">
The <b>dwCookie</b> value is valid. 


</td>
</tr>
<tr>
<td width="40%"><a id="CFM_DISABLED"></a><a id="cfm_disabled"></a><dl>
<dt><b>CFM_DISABLED</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_DISABLED</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_EXTENDED"></a><a id="cfm_extended"></a><dl>
<dt><b>CFM_EXTENDED</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_EXTENDED</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_EFFECTS"></a><a id="cfm_effects"></a><dl>
<dt><b>CFM_EFFECTS</b></dt>
</dl>
</td>
<td width="60%">
 A combination of the following values: <b>CFM_BOLD</b> | <b>CFM_ITALIC</b> | <b>CFM_UNDERLINE</b> | <b>CFM_COLOR</b> | <b>CFM_STRIKEOUT</b> | <b>CFE_PROTECTED</b> | <b>CFM_LINK</b>

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_EFFECTS2"></a><a id="cfm_effects2"></a><dl>
<dt><b>CFM_EFFECTS2</b></dt>
</dl>
</td>
<td width="60%">
 A combination of the following values: <b>CFM_EFFECTS</b> | <b>CFM_DISABLED</b> | <b>CFM_SMALLCAPS</b> | <b>CFM_ALLCAPS</b> | <b>CFM_HIDDEN</b>  | <b>CFM_OUTLINE</b> | <b>CFM_SHADOW</b> | <b>CFM_EMBOSS</b> | <b>CFM_IMPRINT</b> | <b>CFM_REVISED</b> | <b>CFM_SUBSCRIPT</b> | <b>CFM_SUPERSCRIPT</b> | <b>CFM_BACKCOLOR</b>

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_EMBOSS"></a><a id="cfm_emboss"></a><dl>
<dt><b>CFM_EMBOSS</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_EMBOSS</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_FONTBOUND"></a><a id="cfm_fontbound"></a><dl>
<dt><b>CFM_FONTBOUND</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_FONTBOUND</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_HIDDEN"></a><a id="cfm_hidden"></a><dl>
<dt><b>CFM_HIDDEN</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_HIDDEN</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_IMPRINT"></a><a id="cfm_imprint"></a><dl>
<dt><b>CFM_IMPRINT</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_IMPRINT</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_ITALIC"></a><a id="cfm_italic"></a><dl>
<dt><b>CFM_ITALIC</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_ITALIC</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_LINK"></a><a id="cfm_link"></a><dl>
<dt><b>CFM_LINK</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_LINK</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_LINKPROTECTED"></a><a id="cfm_linkprotected"></a><dl>
<dt><b>CFM_LINKPROTECTED</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_LINKPROTECTED</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_MATH"></a><a id="cfm_math"></a><dl>
<dt><b>CFM_MATH</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_MATH</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_MATHNOBUILDUP"></a><a id="cfm_mathnobuildup"></a><dl>
<dt><b>CFM_MATHNOBUILDUP</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_MATHNOBUILDUP</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_MATHORDINARY"></a><a id="cfm_mathordinary"></a><dl>
<dt><b>CFM_MATHORDINARY</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_MATHORDINARY</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_OUTLINE"></a><a id="cfm_outline"></a><dl>
<dt><b>CFM_OUTLINE</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_OUTLINE</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_PROTECTED"></a><a id="cfm_protected"></a><dl>
<dt><b>CFM_PROTECTED</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_PROTECTED</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_REVISED"></a><a id="cfm_revised"></a><dl>
<dt><b>CFM_REVISED</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_REVISION</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_SHADOW"></a><a id="cfm_shadow"></a><dl>
<dt><b>CFM_SHADOW</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_SHADOW</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_SMALLCAPS"></a><a id="cfm_smallcaps"></a><dl>
<dt><b>CFM_SMALLCAPS</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_SMALLCAPS</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_STRIKEOUT"></a><a id="cfm_strikeout"></a><dl>
<dt><b>CFM_STRIKEOUT</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_STRIKEOUT</b> value is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_SUBSCRIPT"></a><a id="cfm_subscript"></a><dl>
<dt><b>CFM_SUBSCRIPT</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_SUBSCRIPT</b> and <b>CFE_SUPERSCRIPT</b> values are valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_SUPERSCRIPT"></a><a id="cfm_superscript"></a><dl>
<dt><b>CFM_SUPERSCRIPT</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_SUBSCRIPT</b> and <b>CFE_SUPERSCRIPT</b> values are valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_UNDERLINE"></a><a id="cfm_underline"></a><dl>
<dt><b>CFM_UNDERLINE</b></dt>
</dl>
</td>
<td width="60%">
The <b>CFE_UNDERLINE</b> value is valid.

</td>
</tr>
</table>
 


Set the following values to indicate the valid structure members.



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="CFM_ANIMATION"></a><a id="cfm_animation"></a><dl>
<dt><b>CFM_ANIMATION</b></dt>
</dl>
</td>
<td width="60%">
The 
						<b>bAnimation</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_BACKCOLOR"></a><a id="cfm_backcolor"></a><dl>
<dt><b>CFM_BACKCOLOR</b></dt>
</dl>
</td>
<td width="60%">
The 
						<b>crBackColor</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_CHARSET"></a><a id="cfm_charset"></a><dl>
<dt><b>CFM_CHARSET</b></dt>
</dl>
</td>
<td width="60%">
The 
						<b>bCharSet</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_COLOR"></a><a id="cfm_color"></a><dl>
<dt><b>CFM_COLOR</b></dt>
</dl>
</td>
<td width="60%">
The <b>crTextColor</b> member is valid unless the <b>CFE_AUTOCOLOR</b> flag is set in the <b>dwEffects</b> member.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_FACE"></a><a id="cfm_face"></a><dl>
<dt><b>CFM_FACE</b></dt>
</dl>
</td>
<td width="60%">
The <b>szFaceName</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_KERNING"></a><a id="cfm_kerning"></a><dl>
<dt><b>CFM_KERNING</b></dt>
</dl>
</td>
<td width="60%">
The <b>wKerning</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_LCID"></a><a id="cfm_lcid"></a><dl>
<dt><b>CFM_LCID</b></dt>
</dl>
</td>
<td width="60%">
The <b>lcid</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_OFFSET"></a><a id="cfm_offset"></a><dl>
<dt><b>CFM_OFFSET</b></dt>
</dl>
</td>
<td width="60%">
The 
						<b>yOffset</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_REVAUTHOR"></a><a id="cfm_revauthor"></a><dl>
<dt><b>CFM_REVAUTHOR</b></dt>
</dl>
</td>
<td width="60%">
The <b>bRevAuthor</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_SIZE"></a><a id="cfm_size"></a><dl>
<dt><b>CFM_SIZE</b></dt>
</dl>
</td>
<td width="60%">
The <b>yHeight</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_SPACING"></a><a id="cfm_spacing"></a><dl>
<dt><b>CFM_SPACING</b></dt>
</dl>
</td>
<td width="60%">
The <b>sSpacing</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_STYLE"></a><a id="cfm_style"></a><dl>
<dt><b>CFM_STYLE</b></dt>
</dl>
</td>
<td width="60%">
The <b>sStyle</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_UNDERLINETYPE"></a><a id="cfm_underlinetype"></a><dl>
<dt><b>CFM_UNDERLINETYPE</b></dt>
</dl>
</td>
<td width="60%">
The <b>bUnderlineType</b> member is valid.

</td>
</tr>
<tr>
<td width="40%"><a id="CFM_WEIGHT"></a><a id="cfm_weight"></a><dl>
<dt><b>CFM_WEIGHT</b></dt>
</dl>
</td>
<td width="60%">
The <b>wWeight</b> member is valid.

</td>
</tr>
</table>
 


#### - szFaceName

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">TCHAR</a>[LF_FACESIZE]</b>

A null-terminated character array specifying the font name. To use this member, set the <b>CFM_FACE</b> flag in the <b>dwMask</b> member. 


#### - yHeight

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">LONG</a></b>

Specifies the character height, in twips (1/1440 of an inch, or 1/20 of a printer's point). To use this member, set the <b>CFM_SIZE</b> flag in the <b>dwMask</b> member. 


#### - yOffset

Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">LONG</a></b>

Character offset from the baseline, in twips. If the value of this member is positive, the character is a superscript; if the value is negative, the character is a subscript. To use this member, set the <b>CFM_OFFSET</b> flag in the <b>dwMask</b> member. 


## -remarks



To turn off a formatting attribute, set the appropriate value in <b>dwMask</b> but do not set the corresponding value in <b>dwEffects</b>. For example, to turn off italics, set <b>CFM_ITALIC</b> but do not set <b>CFE_ITALIC</b>.




## -see-also




<a href="https://msdn.microsoft.com/7b31e42a-5e9b-46bf-9c4e-fd223c34a076">CHARFORMAT</a>



<a href="https://docs.microsoft.com/windows/desktop/gdi/colorref">COLORREF</a>



<a href="https://msdn.microsoft.com/210b8719-5ed7-49f2-bd93-8a4e1efab1e8">EM_GETCHARFORMAT</a>



<a href="https://msdn.microsoft.com/5e7a545d-4ca4-4dc6-badb-584c11194982">EM_SETCHARFORMAT</a>



<a href="https://msdn.microsoft.com/29c0cb51-675c-44b1-ad45-5f7140ca5675">EN_PROTECTED</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-getsyscolor">GetSysColor</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/ns-wingdi-logfonta">LOGFONT</a>



<a href="https://docs.microsoft.com/windows/desktop/api/wingdi/nf-wingdi-rgb">RGB</a>
 

 

