---
UID: NS:rpcndr._MIDL_STUB_MESSAGE
title: MIDL_STUB_MESSAGE (rpcndr.h)
description: Is generated by MIDL and contains the current status of the RPC stub. Applications are not to modify the MIDL_STUB_MESSAGE structure directly.
old-location: rpc\midl_stub_message.htm
tech.root: Rpc
ms.assetid: 9bd021f6-10c9-4e77-be75-9a89a3a016e0
ms.date: 12/05/2018
ms.keywords: '*PMIDL_STUB_MESSAGE, MIDL_STUB_MESSAGE, MIDL_STUB_MESSAGE structure [RPC], PMIDL_STUB_MESSAGE, PMIDL_STUB_MESSAGE structure pointer [RPC], rpc.midl_stub_message, rpcndr/MIDL_STUB_MESSAGE, rpcndr/PMIDL_STUB_MESSAGE'
f1_keywords:
- rpcndr/MIDL_STUB_MESSAGE
dev_langs:
- c++
req.header: rpcndr.h
req.include-header: Rpc.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Rpcndr.h
api_name:
- MIDL_STUB_MESSAGE
targetos: Windows
req.typenames: MIDL_STUB_MESSAGE, *PMIDL_STUB_MESSAGE
req.redist: 
ms.custom: 19H1
---

# MIDL_STUB_MESSAGE structure


## -description


The <b>MIDL_STUB_MESSAGE</b> structure is generated by MIDL and contains the current status of the RPC stub. Applications are not to modify the <b>MIDL_STUB_MESSAGE</b> structure directly.


## -struct-fields




### -field RpcMsg

Pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/rpcdcep/ns-rpcdcep-rpc_message">RPC_MESSAGE</a> structure.


### -field Buffer

Pointer that points to a location within the network buffer where the data is marshaled or unmarshaled.


### -field BufferStart

Pointer to the beginning of the network buffer.


### -field BufferEnd

Pointer to the end of the network buffer.


### -field BufferMark

Reserved.


### -field BufferLength

Size, in bytes, of <b>Buffer</b>.


### -field MemorySize

Reserved.


### -field Memory

Reserved.


### -field IsClient

Reserved.


### -field Pad

 


### -field uFlags2

 


### -field ReuseBuffer

Reserved.


### -field pAllocAllNodesContext

Reserved.


### -field pPointerQueueState

Reserved.


### -field IgnoreEmbeddedPointers

Reserved.


### -field PointerBufferMark

Reserved.


### -field CorrDespIncrement

 


### -field uFlags

Reserved.


### -field UniquePtrCount

 


### -field MaxCount

Reserved.


### -field Offset

Reserved.


### -field ActualCount

Reserved.


### -field pfnAllocate

Reserved.  


### -field pfnFree

Reserved.  


### -field StackTop

Reserved.


### -field pPresentedType

Reserved.


### -field pTransmitType

Reserved.


### -field SavedHandle

Reserved.


### -field StubDesc

Reserved.


### -field _MIDL_STUB_DESC

 


### -field FullPtrXlatTables

Reserved.


### -field FullPtrRefId

Reserved.


### -field PointerLength

Reserved.


### -field fInDontFree

Reserved.


### -field fDontCallFreeInst

Reserved.


### -field fUnused1

 


### -field fHasReturn

Reserved.


### -field fHasExtensions

Reserved.


### -field fHasNewCorrDesc

Reserved.


### -field fIsIn

 


### -field fIsOut

 


### -field fIsOicf

 


### -field fBufferValid

Reserved.


### -field fHasMemoryValidateCallback

 


### -field fInFree

 


### -field fNeedMCCP

 


### -field fUnused2

Reserved.


### -field fUnused3

 


### -field dwDestContext

Reserved.


### -field pvDestContext

Reserved.


### -field SavedContextHandles

Reserved.


### -field ParamNumber

Reserved.


### -field pRpcChannelBuffer

Reserved.


### -field pArrayInfo

Reserved.


### -field SizePtrCountArray

Reserved.


### -field SizePtrOffsetArray

Reserved.


### -field SizePtrLengthArray

Reserved.


### -field pArgQueue

Reserved.


### -field dwStubPhase

Pointer to a flag that tracks the current interpreter call's activity.


### -field LowStackMark

Reserved.


### -field pAsyncMsg

Reserved.


### -field pCorrInfo

Reserved.


### -field pCorrMemory

Reserved.


### -field pMemoryList

Reserved.


### -field pCSInfo

Reserved.


### -field ConformanceMark

Reserved.


### -field VarianceMark

Reserved.


### -field Unused

Reserved.


### -field pContext

Reserved.


### -field ContextHandleHash

 


### -field pUserMarshalList

 


### -field Reserved51_3

Reserved.


### -field Reserved51_4

Reserved.


### -field Reserved51_5

Reserved.


#### - BackingStoreLowMark

Reserved.


#### - Reserved51_1

Reserved.


#### - Reserved51_2

Reserved.


#### - Unused2

Reserved.


#### - fInOnlyParam

Reserved.


#### - fUnused

Reserved.

