---
UID: NF:rpcproxy.NdrDllUnregisterProxy
title: NdrDllUnregisterProxy function (rpcproxy.h)
description: The NdrDllUnregisterProxy function removes a registry entry for the interfaces contained in the proxy DLL.
old-location: rpc\ndrdllunregisterproxy.htm
tech.root: Rpc
ms.assetid: 9a286298-b4a1-4386-99b1-bb6044ade87e
ms.date: 12/05/2018
ms.keywords: NdrDllUnregisterProxy, NdrDllUnregisterProxy function [RPC], rpc.ndrdllunregisterproxy, rpcproxy/NdrDllUnregisterProxy
f1_keywords:
- rpcproxy/NdrDllUnregisterProxy
dev_langs:
- c++
req.header: rpcproxy.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps \| UWP apps]
req.target-min-winversvr: Windows 2000 Server [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: RpcRT4.lib
req.dll: RpcRT4.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- RpcRT4.dll
api_name:
- NdrDllUnregisterProxy
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# NdrDllUnregisterProxy function


## -description


The <b>NdrDllUnregisterProxy</b> function removes a registry entry for the interfaces contained in the proxy DLL.


## -parameters




### -param hDll [in]

Handle to the proxy DLL.


### -param pProxyFileList [in]

Pointer to a <a href="https://docs.microsoft.com/windows/desktop/api/rpcproxy/ns-rpcproxy-proxyfileinfo">ProxyFileInfo</a> structure generated by MIDL.


### -param pclsid [in]

Pointer to a class identifier of the proxy being unregistered.


## -returns



Returns S_OK on success.



