---
UID: NF:rtworkq.RtwqPutWorkItem
title: RtwqPutWorkItem function (rtworkq.h)
description: Puts an asynchronous operation on a work queue.
old-location: base\rtwqputworkitem.htm
tech.root: ProcThread
ms.assetid: d2ae1cec-b279-4f5e-a803-fe0b8f453029
ms.date: 12/05/2018
ms.keywords: RtwqPutWorkItem, RtwqPutWorkItem function, base.rtwqputworkitem, rtworkq/RtwqPutWorkItem
f1_keywords:
- rtworkq/RtwqPutWorkItem
dev_langs:
- c++
req.header: rtworkq.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8.1 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Rtworkq.lib
req.dll: RTWorkQ.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- RTWorkQ.dll
api_name:
- RtwqPutWorkItem
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# RtwqPutWorkItem function


## -description


Puts an asynchronous operation on a work queue.


## -parameters




### -param dwQueue [in]

The identifier for the work queue. This value can specify one of the standard work queues, or a work queue created by the app. To access to a work queue, call [RtwqLockSharedWorkQueue](/windows/win32/api/rtworkq/nf-rtworkq-rtwqlocksharedworkqueue). 


### -param lPriority [in]

The priority of the work item. Work items are performed in order of priority. This value should be -1, 0, or 1, where -1 is the lowest priority and 1 is the highest priority.


### -param result [in]

A pointer to the callback .  The caller must implement this interface.


## -returns



If this function succeeds, it returns <b xmlns:loc="http://microsoft.com/wdcml/l10n">S_OK</b>. Otherwise, it returns an <b xmlns:loc="http://microsoft.com/wdcml/l10n">HRESULT</b> error code.



