---
UID: NE:sbtsv._TS_SB_SORT_BY
title: TS_SB_SORT_BY (sbtsv.h)
description: Specifies sort order. It is used as a parameter in the EnumerateTargets method.
old-location: termserv\ts_sb_sort_by.htm
tech.root: TermServ
ms.assetid: 50945048-5E79-4423-8983-543085E3D953
ms.date: 12/05/2018
ms.keywords: TS_SB_SORT_BY, TS_SB_SORT_BY enumeration [Remote Desktop Services], TS_SB_SORT_BY_NAME, TS_SB_SORT_BY_NONE, TS_SB_SORT_BY_PROP, sbtsv/TS_SB_SORT_BY, sbtsv/TS_SB_SORT_BY_NAME, sbtsv/TS_SB_SORT_BY_NONE, sbtsv/TS_SB_SORT_BY_PROP, termserv.ts_sb_sort_by
f1_keywords:
- sbtsv/TS_SB_SORT_BY
dev_langs:
- c++
req.header: sbtsv.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Sbtsv.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- sbtsv.h
api_name:
- TS_SB_SORT_BY
targetos: Windows
req.typenames: TS_SB_SORT_BY
req.redist: 
ms.custom: 19H1
---

# TS_SB_SORT_BY enumeration


## -description


Specifies sort order. It is used as a parameter in the <a href="https://docs.microsoft.com/windows/desktop/api/sbtsv/nf-sbtsv-itssbresourcepluginstore-enumeratetargets">EnumerateTargets</a> method.


## -enum-fields




### -field TS_SB_SORT_BY_NONE

Do not sort.


### -field TS_SB_SORT_BY_NAME

Sort by target name.


### -field TS_SB_SORT_BY_PROP

Sort by a specified property.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/sbtsv/nf-sbtsv-itssbresourcepluginstore-enumeratetargets">EnumerateTargets</a>
 

 

