---
UID: NE:sdoias._CONDITIONPROPERTIES
title: CONDITIONPROPERTIES (sdoias.h)
description: The values of the CONDITIONPROPERTIES enumeration type specify the properties of a Network Access Policy (NAP) condition.
old-location: nps\SDO_conditionproperties.htm
tech.root: Nps
ms.assetid: 09cb8457-9baf-4139-ba80-6eb608db6a65
ms.date: 12/05/2018
ms.keywords: CONDITIONPROPERTIES, CONDITIONPROPERTIES enumeration [Network Policy Server], PROPERTY_CONDITION_TEXT, _sdo_conditionproperties, nps.SDO_conditionproperties, sdo.conditionproperties, sdoias/CONDITIONPROPERTIES, sdoias/PROPERTY_CONDITION_TEXT
f1_keywords:
- sdoias/CONDITIONPROPERTIES
dev_langs:
- c++
req.header: sdoias.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: SdoIas.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- SdoIas.h
api_name:
- CONDITIONPROPERTIES
targetos: Windows
req.typenames: CONDITIONPROPERTIES
req.redist: 
ms.custom: 19H1
---

# CONDITIONPROPERTIES enumeration


## -description


The values of the 
<b>CONDITIONPROPERTIES</b> enumeration type specify the properties of a Network Access Policy (NAP) condition.


## -enum-fields




### -field PROPERTY_CONDITION_TEXT

The text of the NAP condition.


## -remarks



The 
<a href="https://docs.microsoft.com/windows/desktop/api/sdoias/ne-sdoias-policyproperties">POLICYPROPERTIES</a> enumeration type contains the value PROPERTY_POLICY_CONDITIONS_COLLECTION, which is the property for the conditions collection.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/sdoias/ne-sdoias-iascommonproperties">IASCOMMONPROPERTIES</a>



<a href="https://docs.microsoft.com/windows/desktop/api/sdoias/ne-sdoias-policyproperties">POLICYPROPERTIES</a>
 

 

