---
UID: NE:sdoias._NAPPROPERTIES
title: NAPPROPERTIES (sdoias.h)
description: The values of the NAPPROPERTIES enumeration type specify properties for Network Access Policies (NAP).
old-location: nps\SDO_napproperties.htm
tech.root: Nps
ms.assetid: 1e43524c-1c6a-49fc-a962-e804e98454c5
ms.date: 12/05/2018
ms.keywords: NAPPROPERTIES, NAPPROPERTIES enumeration [Network Policy Server], PROPERTY_NAP_POLICIES_COLLECTION, PROPERTY_SHV_TEMPLATES_COLLECTION, _sdo_napproperties, nps.SDO_napproperties, sdo.napproperties, sdoias/NAPPROPERTIES, sdoias/PROPERTY_NAP_POLICIES_COLLECTION, sdoias/PROPERTY_SHV_TEMPLATES_COLLECTION
f1_keywords:
- sdoias/NAPPROPERTIES
dev_langs:
- c++
req.header: sdoias.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: SdoIas.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- SdoIas.h
api_name:
- NAPPROPERTIES
targetos: Windows
req.typenames: NAPPROPERTIES
req.redist: 
ms.custom: 19H1
---

# NAPPROPERTIES enumeration


## -description


The values of the 
<b>NAPPROPERTIES</b> enumeration type specify properties for Network Access Policies (NAP).


## -enum-fields




### -field PROPERTY_NAP_POLICIES_COLLECTION

The network access policies collection.


### -field PROPERTY_SHV_TEMPLATES_COLLECTION

Collection of System Health Validator (SHV) templates. See <a href="https://docs.microsoft.com/windows/desktop/NAP/network-access-protection-start-page">NAP documentation</a> for more information on SHV.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/sdoias/ne-sdoias-policyproperties">POLICYPROPERTIES</a>
 

 

