---
UID: NE:sdoias._RADIUSPROPERTIES
title: RADIUSPROPERTIES (sdoias.h)
description: The values of the RADIUSPROPERTIES enumeration type enumerate properties of the Microsoft RADIUS protocol SDO.
old-location: nps\SDO_radiusproperties.htm
tech.root: Nps
ms.assetid: adf73b6d-963d-4a06-b958-8301e4fdf292
ms.date: 12/05/2018
ms.keywords: PROPERTY_RADIUS_ACCOUNTING_PORT, PROPERTY_RADIUS_AUTHENTICATION_PORT, PROPERTY_RADIUS_CLIENTS_COLLECTION, PROPERTY_RADIUS_VENDORS_COLLECTION, RADIUSPROPERTIES, RADIUSPROPERTIES enumeration [Network Policy Server], _sdo_radiusproperties, nps.SDO_radiusproperties, sdo.radiusproperties, sdoias/PROPERTY_RADIUS_ACCOUNTING_PORT, sdoias/PROPERTY_RADIUS_AUTHENTICATION_PORT, sdoias/PROPERTY_RADIUS_CLIENTS_COLLECTION, sdoias/PROPERTY_RADIUS_VENDORS_COLLECTION, sdoias/RADIUSPROPERTIES
f1_keywords:
- sdoias/RADIUSPROPERTIES
dev_langs:
- c++
req.header: sdoias.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: SdoIas.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- SdoIas.h
api_name:
- RADIUSPROPERTIES
targetos: Windows
req.typenames: RADIUSPROPERTIES
req.redist: 
ms.custom: 19H1
---

# RADIUSPROPERTIES enumeration


## -description


The values of the 
<b>RADIUSPROPERTIES</b> enumeration type enumerate properties of the Microsoft RADIUS protocol SDO.


## -enum-fields




### -field PROPERTY_RADIUS_ACCOUNTING_PORT

The TCP port used for RADIUS accounting.


### -field PROPERTY_RADIUS_AUTHENTICATION_PORT

The TCP port used for RADIUS authentication.


### -field PROPERTY_RADIUS_CLIENTS_COLLECTION

The collection of clients for this RADIUS server.


### -field PROPERTY_RADIUS_VENDORS_COLLECTION

The collection of vendors for this RADIUS server.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/sdoias/ne-sdoias-clientproperties">CLIENTPROPERTIES</a>



<a href="https://docs.microsoft.com/windows/desktop/api/sdoias/ne-sdoias-vendorproperties">VENDORPROPERTIES</a>
 

 

