---
UID: NE:segment.DVDSPExt
title: DVDSPExt (segment.h)
description: The DVDSPExt enumeration type holds a value indicating the default DVD subpicture language extension.
old-location: mstv\dvdspext.htm
tech.root: mstv
ms.assetid: cc33083a-1281-4863-937c-bd4688989a6c
ms.date: 12/05/2018
ms.keywords: DVDSPExt, DVDSPExt enumeration [Microsoft TV Technologies], dvdSPExt_CC_Big, dvdSPExt_CC_Children, dvdSPExt_CC_Normal, dvdSPExt_Caption_Big, dvdSPExt_Caption_Children, dvdSPExt_Caption_Normal, dvdSPExt_DirectorComments_Big, dvdSPExt_DirectorComments_Children, dvdSPExt_DirectorComments_Normal, dvdSPExt_Forced, dvdSPExt_NotSpecified, enumeration [Microsoft TV Technologies], mstv.dvdspext, segment/DVDSPExt, segment/dvdSPExt_CC_Big, segment/dvdSPExt_CC_Children, segment/dvdSPExt_CC_Normal, segment/dvdSPExt_Caption_Big, segment/dvdSPExt_Caption_Children, segment/dvdSPExt_Caption_Normal, segment/dvdSPExt_DirectorComments_Big, segment/dvdSPExt_DirectorComments_Children, segment/dvdSPExt_DirectorComments_Normal, segment/dvdSPExt_Forced, segment/dvdSPExt_NotSpecified
f1_keywords:
- segment/DVDSPExt
dev_langs:
- c++
req.header: segment.h
req.include-header: Msvidctl.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Segment.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- segment.h
api_name:
- DVDSPExt
targetos: Windows
req.typenames: DVDSPExt
req.redist: 
ms.custom: 19H1
---

# DVDSPExt enumeration


## -description



The <b>DVDSPExt</b> enumeration type holds a value indicating the default DVD subpicture language extension.




## -enum-fields




### -field dvdSPExt_NotSpecified

Extension not specified.
          


### -field dvdSPExt_Caption_Normal

Normal caption size.
          


### -field dvdSPExt_Caption_Big

Big captions.
          


### -field dvdSPExt_Caption_Children

Children's captions.
          


### -field dvdSPExt_CC_Normal

Normal-sized closed captions.
          


### -field dvdSPExt_CC_Big

Big closed captions.
          


### -field dvdSPExt_CC_Children

Children's closed captions.
          


### -field dvdSPExt_Forced

Forced.
          


### -field dvdSPExt_DirectorComments_Normal

Normal-sized director's comments.
          


### -field dvdSPExt_DirectorComments_Big

Big director's comments.
          


### -field dvdSPExt_DirectorComments_Children

Director's comments for children.
          


## -see-also




<a href="https://docs.microsoft.com/previous-versions/dd695197(v=vs.85)">DefaultSubpictureLanguageExt</a>



<a href="https://docs.microsoft.com/windows/desktop/api/strmif/nf-strmif-idvdcontrol2-selectdefaultsubpicturelanguage">SelectDefaultSubpictureLanguage</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mstv/video-control-enumerations">Video Control Enumerations</a>
 

 

