---
UID: NN:sensorsapi.ISensorDataReport
title: ISensorDataReport (sensorsapi.h)
description: Represents a sensor data report. Sensor data reports contain data field values generated by a sensor and a time stamp that indicates when the data report was created.
old-location: winsensors\isensordatareport.htm
tech.root: SensorsAPI
ms.assetid: c677b956-e3ab-477c-b97b-aceec4e2d235
ms.date: 12/05/2018
ms.keywords: ISensorDataReport, ISensorDataReport interface [WinSensors], ISensorDataReport interface [WinSensors],described, sensorsapi/ISensorDataReport, winsensors.isensordatareport
f1_keywords:
- sensorsapi/ISensorDataReport
dev_langs:
- c++
req.header: sensorsapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Sensorsapi.lib
req.dll: Sensorsapi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- sensorsapi.dll
api_name:
- ISensorDataReport
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ISensorDataReport interface


## -description


Represents a sensor data report. Sensor data reports contain data field values generated by a sensor and a time stamp that indicates when the data report was created.

Retrieve a sensor data report asynchronously by subscribing to the <a href="https://docs.microsoft.com/windows/desktop/api/sensorsapi/nf-sensorsapi-isensorevents-ondataupdated">ISensorEvents::OnDataUpdated</a> event, or synchronously by calling <a href="https://docs.microsoft.com/windows/desktop/api/sensorsapi/nf-sensorsapi-isensor-getdata">ISensor::GetData</a>.
In addition to the methods inherited from <b>IUnknown</b>, the ISensorDataReport interface exposes the following methods.



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/SensorsAPI/windows-sensors-com-interfaces">COM Interfaces</a>
 

 

