---
UID: NF:setupapi.SetupInitDefaultQueueCallback
title: SetupInitDefaultQueueCallback function (setupapi.h)
description: The SetupInitDefaultQueueCallback function initializes the context used by the default queue callback routine included with the Setup API.
old-location: setup\setupinitdefaultqueuecallback.htm
tech.root: SetupApi
ms.assetid: 3ee7da67-42ff-4ea1-9c7f-6c0dcc3dc0b4
ms.date: 12/05/2018
ms.keywords: SetupInitDefaultQueueCallback, SetupInitDefaultQueueCallback function [Setup API], _setupapi_setupinitdefaultqueuecallback, setup.setupinitdefaultqueuecallback, setupapi/SetupInitDefaultQueueCallback
f1_keywords:
- setupapi/SetupInitDefaultQueueCallback
dev_langs:
- c++
req.header: setupapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Setupapi.lib
req.dll: Setupapi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Setupapi.dll
api_name:
- SetupInitDefaultQueueCallback
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# SetupInitDefaultQueueCallback function


## -description


<p class="CCE_Message">[This function is available for use in the operating systems indicated in the Requirements section. It may be altered or unavailable in subsequent versions.   SetupAPI should no longer be used for installing applications. Instead, use the Windows Installer for developing application installers. SetupAPI continues to be used for installing device drivers.]

The 
<b>SetupInitDefaultQueueCallback</b> function initializes the context used by the default queue callback routine included with the Setup API.


## -parameters




### -param OwnerWindow [in]

Handle to the window to use as the parent of any dialog boxes generated by the default callback routine.


## -returns



Pointer to the context used by the default queue callback routine.

If the call to 
<b>SetupInitDefaultQueueCallback</b> fails, the function returns a PVOID value of null.

To get extended error information, call 
<a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-getlasterror">GetLastError</a>.




## -remarks



Regardless of whether you initialized the context used by the default queue callback routine with 
<b>SetupInitDefaultQueueCallback</b> or 
<a href="https://docs.microsoft.com/windows/desktop/api/setupapi/nf-setupapi-setupinitdefaultqueuecallbackex">SetupInitDefaultQueueCallbackEx</a>, after the queued operations have finished processing, call 
<a href="https://docs.microsoft.com/windows/desktop/api/setupapi/nf-setupapi-setuptermdefaultqueuecallback">SetupTermDefaultQueueCallback</a> to release the resources allocated in initializing the context structure. For more information, see 
<a href="https://docs.microsoft.com/windows/desktop/SetupApi/initializing-and-terminating-the-callback-context">Initializing and Terminating the Callback Context</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/SetupApi/functions">Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/SetupApi/overview">Overview</a>



<a href="https://docs.microsoft.com/windows/desktop/api/setupapi/nf-setupapi-setupdefaultqueuecallbacka">SetupDefaultQueueCallback</a>



<a href="https://docs.microsoft.com/windows/desktop/api/setupapi/nf-setupapi-setupinitdefaultqueuecallbackex">SetupInitDefaultQueueCallbackEx</a>
 

 

