---
UID: NF:setupapi.SetupInitDefaultQueueCallbackEx
title: SetupInitDefaultQueueCallbackEx function (setupapi.h)
description: Initializes the context used by the default queue callback routine included with the Setup API in the same manner as SetupInitDefaultQueueCallback, except that an additional window is provided to the callback function to accept progress messages.
old-location: setup\setupinitdefaultqueuecallbackex.htm
tech.root: SetupApi
ms.assetid: 9376f55b-55ee-4064-8aed-264c43db0c7d
ms.date: 12/05/2018
ms.keywords: SetupInitDefaultQueueCallbackEx, SetupInitDefaultQueueCallbackEx function [Setup API], _setupapi_setupinitdefaultqueuecallbackex, setup.setupinitdefaultqueuecallbackex, setupapi/SetupInitDefaultQueueCallbackEx
f1_keywords:
- setupapi/SetupInitDefaultQueueCallbackEx
dev_langs:
- c++
req.header: setupapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Setupapi.lib
req.dll: Setupapi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Setupapi.dll
- Ext-MS-Win-SetupAPI-ClassInstallers-L1-1-2.dll
api_name:
- SetupInitDefaultQueueCallbackEx
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# SetupInitDefaultQueueCallbackEx function


## -description


<p class="CCE_Message">[This function is available for use in the operating systems indicated in the Requirements section. It may be altered or unavailable in subsequent versions.   SetupAPI should no longer be used for installing applications. Instead, use the Windows Installer for developing application installers. SetupAPI continues to be used for installing device drivers.]

The 
<b>SetupInitDefaultQueueCallbackEx</b> function initializes the context used by the default queue callback routine included with the Setup API in the same manner as 
<a href="https://docs.microsoft.com/windows/desktop/api/setupapi/nf-setupapi-setupinitdefaultqueuecallback">SetupInitDefaultQueueCallback</a>, except that an additional window is provided to the callback function to accept progress messages.


## -parameters




### -param OwnerWindow [in]

Handle to the window to use as the parent of any dialog boxes generated by the default callback routine.


### -param AlternateProgressWindow [in]

Handle to a window that receives the progress messages. To prevent progress messages from being displayed, you can specify this parameter to be INVALID_HANDLE_VALUE.


### -param ProgressMessage [in]

Message that is sent to <i>AlternateProgressWindow</i> when the copy queue is started, and each time a file is copied.


### -param Reserved1 [in]

First message parameter that is sent to the <i>AlternateProgressWindow</i> by the default callback routine.


### -param Reserved2 [in]

Second message parameter that is sent to the <i>AlternateProgressWindow</i> by the default callback routine.


## -returns



<b>SetupInitDefaultQueueCallbackEx</b> returns a pointer to the context used by the default queue callback routine. This function can only fail if there is insufficient memory. If this function fails, it returns <b>NULL</b> and does not set the last-error code for the thread. 




## -remarks



When the queue starts to commit the copy subqueue, the default queue callback routine sends a message to the window specified in <i>AlternateProgressWindow</i>. <i>Reserved1</i> has the value 0, and <i>Reserved2</i> contains a pointer to the number of enqueued file copy operations.

For each file copy operation completed, the default queue callback routine sends a message to <i>AlternateProgressWindow</i>, which can be used to 'tick' the progress bar. <i>Reserved1</i> has the value 1, and <i>Reserved2</i> is zero.

<b>SetupInitDefaultQueueCallbackEx</b> can be used to get the default behavior for disk prompting, error handling, and so on, and also provide a gauge embedded in a wizard page or other specialized dialog box.

Regardless of whether you initialized the context used by the default queue callback routine with 
<a href="https://docs.microsoft.com/windows/desktop/api/setupapi/nf-setupapi-setupinitdefaultqueuecallback">SetupInitDefaultQueueCallback</a> or 
<b>SetupInitDefaultQueueCallbackEx</b>, after the queued operations have finished processing, call 
<a href="https://docs.microsoft.com/windows/desktop/api/setupapi/nf-setupapi-setuptermdefaultqueuecallback">SetupTermDefaultQueueCallback</a> to release the resources allocated in initializing the context structure. For more information see 
<a href="https://docs.microsoft.com/windows/desktop/SetupApi/initializing-and-terminating-the-callback-context">Initializing and Terminating the Callback Context</a>.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/SetupApi/functions">Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/SetupApi/overview">Overview</a>



<a href="https://docs.microsoft.com/windows/desktop/api/setupapi/nf-setupapi-setupinitdefaultqueuecallback">SetupInitDefaultQueueCallback</a>
 

 

