---
UID: NS:setupapi._CABINET_INFO_W
title: CABINET_INFO_W (setupapi.h)
description: The CABINET_INFO structure stores information about a cabinet file. The SetupIterateCabinet function specifies this structure as a parameter when it sends a SPFILENOTIFY_NEEDNEWCABINET notification to the cabinet callback routine.
old-location: setup\cabinet_info_str.htm
tech.root: SetupApi
ms.assetid: 205bff19-d9ac-4dc0-ab11-92cf70a3bd49
ms.date: 12/05/2018
ms.keywords: '*PCABINET_INFO_W, CABINET_INFO, CABINET_INFO structure [Setup API], CABINET_INFO_W, PCABINET_INFO, PCABINET_INFO structure pointer [Setup API], _setupapi_cabinet_info_str, setup.cabinet_info_str, setupapi/CABINET_INFO, setupapi/PCABINET_INFO'
f1_keywords:
- setupapi/CABINET_INFO
dev_langs:
- c++
req.header: setupapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Setupapi.h
api_name:
- CABINET_INFO - cabinet_info_w
targetos: Windows
req.typenames: CABINET_INFO_W, *PCABINET_INFO_W
req.redist: 
ms.custom: 19H1
---

# CABINET_INFO_W structure


## -description


The 
<b>CABINET_INFO</b> structure stores information about a cabinet file. The 
<a href="https://docs.microsoft.com/windows/desktop/api/setupapi/nf-setupapi-setupiteratecabineta">SetupIterateCabinet</a> function specifies this structure as a parameter when it sends a 
<a href="https://docs.microsoft.com/windows/desktop/SetupApi/spfilenotify-neednewcabinet">SPFILENOTIFY_NEEDNEWCABINET</a> notification to the cabinet callback routine.


## -struct-fields




### -field CabinetPath

Path to the cabinet file.


### -field CabinetFile

Name of the cabinet file.


### -field DiskName

Name of the source media that contains the cabinet file.


### -field SetId

Identifier of the current set. This number is generated by the software that builds the cabinet.


### -field CabinetNumber

Number of the cabinet. This number is generated by the software that builds the cabinet and is generally a zero- or 1-based index indicating the ordinal of the position of the cabinet within a set.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/setupapi/ns-setupapi-file_in_cabinet_info_a">FILE_IN_CABINET_INFO</a>



<a href="https://docs.microsoft.com/windows/desktop/SetupApi/overview">Overview</a>



<a href="https://docs.microsoft.com/windows/desktop/SetupApi/spfilenotify-neednewcabinet">SPFILENOTIFY_NEEDNEWCABINET</a>



<a href="https://docs.microsoft.com/windows/desktop/SetupApi/structures--setup-api-">Structures</a>
 

 

