---
UID: NE:shellapi.SHSTOCKICONID
title: SHSTOCKICONID (shellapi.h)
description: Used by SHGetStockIconInfo to identify which stock system icon to retrieve.
old-location: shell\SHSTOCKICONID.htm
tech.root: shell
ms.assetid: 37da5555-3626-465e-b834-3a28b75495c4
ms.date: 12/05/2018
ms.keywords: SHSTOCKICONID, SHSTOCKICONID enumeration [Windows Shell], SIID_APPLICATION, SIID_AUDIOFILES, SIID_AUTOLIST, SIID_CLUSTEREDDRIVE, SIID_DELETE, SIID_DESKTOPPC, SIID_DEVICEAUDIOPLAYER, SIID_DEVICECAMERA, SIID_DEVICECELLPHONE, SIID_DEVICEVIDEOCAMERA, SIID_DOCASSOC, SIID_DOCNOASSOC, SIID_DRIVE35, SIID_DRIVE525, SIID_DRIVEBD, SIID_DRIVECD, SIID_DRIVEDVD, SIID_DRIVEFIXED, SIID_DRIVEHDDVD, SIID_DRIVENET, SIID_DRIVENETDISABLED, SIID_DRIVERAM, SIID_DRIVEREMOVE, SIID_DRIVEUNKNOWN, SIID_ERROR, SIID_FIND, SIID_FOLDER, SIID_FOLDERBACK, SIID_FOLDERFRONT, SIID_FOLDEROPEN, SIID_HELP, SIID_IMAGEFILES, SIID_INFO, SIID_INTERNET, SIID_KEY, SIID_LINK, SIID_LOCK, SIID_MAX_ICONS, SIID_MEDIAAUDIODVD, SIID_MEDIABDR, SIID_MEDIABDRE, SIID_MEDIABDROM, SIID_MEDIABLANKCD, SIID_MEDIABLURAY, SIID_MEDIACDAUDIO, SIID_MEDIACDAUDIOPLUS, SIID_MEDIACDBURN, SIID_MEDIACDR, SIID_MEDIACDROM, SIID_MEDIACDRW, SIID_MEDIACOMPACTFLASH, SIID_MEDIADVD, SIID_MEDIADVDPLUSR, SIID_MEDIADVDPLUSRW, SIID_MEDIADVDR, SIID_MEDIADVDRAM, SIID_MEDIADVDROM, SIID_MEDIADVDRW, SIID_MEDIAENHANCEDCD, SIID_MEDIAENHANCEDDVD, SIID_MEDIAHDDVD, SIID_MEDIAHDDVDR, SIID_MEDIAHDDVDRAM, SIID_MEDIAHDDVDROM, SIID_MEDIAMOVIEDVD, SIID_MEDIASMARTMEDIA, SIID_MEDIASVCD, SIID_MEDIAVCD, SIID_MIXEDFILES, SIID_MOBILEPC, SIID_MYNETWORK, SIID_NETWORKCONNECT, SIID_PRINTER, SIID_PRINTERFAX, SIID_PRINTERFAXNET, SIID_PRINTERFILE, SIID_PRINTERNET, SIID_RECYCLER, SIID_RECYCLERFULL, SIID_RENAME, SIID_SERVER, SIID_SERVERSHARE, SIID_SETTINGS, SIID_SHARE, SIID_SHIELD, SIID_SLOWFILE, SIID_SOFTWARE, SIID_STACK, SIID_STUFFEDFOLDER, SIID_USERS, SIID_VIDEOFILES, SIID_WARNING, SIID_WORLD, SIID_ZIPFILE, _shell_SHSTOCKICONID, shell.SHSTOCKICONID, shellapi/SHSTOCKICONID, shellapi/SIID_APPLICATION, shellapi/SIID_AUDIOFILES, shellapi/SIID_AUTOLIST, shellapi/SIID_CLUSTEREDDRIVE, shellapi/SIID_DELETE, shellapi/SIID_DESKTOPPC, shellapi/SIID_DEVICEAUDIOPLAYER, shellapi/SIID_DEVICECAMERA, shellapi/SIID_DEVICECELLPHONE, shellapi/SIID_DEVICEVIDEOCAMERA, shellapi/SIID_DOCASSOC, shellapi/SIID_DOCNOASSOC, shellapi/SIID_DRIVE35, shellapi/SIID_DRIVE525, shellapi/SIID_DRIVEBD, shellapi/SIID_DRIVECD, shellapi/SIID_DRIVEDVD, shellapi/SIID_DRIVEFIXED, shellapi/SIID_DRIVEHDDVD, shellapi/SIID_DRIVENET, shellapi/SIID_DRIVENETDISABLED, shellapi/SIID_DRIVERAM, shellapi/SIID_DRIVEREMOVE, shellapi/SIID_DRIVEUNKNOWN, shellapi/SIID_ERROR, shellapi/SIID_FIND, shellapi/SIID_FOLDER, shellapi/SIID_FOLDERBACK, shellapi/SIID_FOLDERFRONT, shellapi/SIID_FOLDEROPEN, shellapi/SIID_HELP, shellapi/SIID_IMAGEFILES, shellapi/SIID_INFO, shellapi/SIID_INTERNET, shellapi/SIID_KEY, shellapi/SIID_LINK, shellapi/SIID_LOCK, shellapi/SIID_MAX_ICONS, shellapi/SIID_MEDIAAUDIODVD, shellapi/SIID_MEDIABDR, shellapi/SIID_MEDIABDRE, shellapi/SIID_MEDIABDROM, shellapi/SIID_MEDIABLANKCD, shellapi/SIID_MEDIABLURAY, shellapi/SIID_MEDIACDAUDIO, shellapi/SIID_MEDIACDAUDIOPLUS, shellapi/SIID_MEDIACDBURN, shellapi/SIID_MEDIACDR, shellapi/SIID_MEDIACDROM, shellapi/SIID_MEDIACDRW, shellapi/SIID_MEDIACOMPACTFLASH, shellapi/SIID_MEDIADVD, shellapi/SIID_MEDIADVDPLUSR, shellapi/SIID_MEDIADVDPLUSRW, shellapi/SIID_MEDIADVDR, shellapi/SIID_MEDIADVDRAM, shellapi/SIID_MEDIADVDROM, shellapi/SIID_MEDIADVDRW, shellapi/SIID_MEDIAENHANCEDCD, shellapi/SIID_MEDIAENHANCEDDVD, shellapi/SIID_MEDIAHDDVD, shellapi/SIID_MEDIAHDDVDR, shellapi/SIID_MEDIAHDDVDRAM, shellapi/SIID_MEDIAHDDVDROM, shellapi/SIID_MEDIAMOVIEDVD, shellapi/SIID_MEDIASMARTMEDIA, shellapi/SIID_MEDIASVCD, shellapi/SIID_MEDIAVCD, shellapi/SIID_MIXEDFILES, shellapi/SIID_MOBILEPC, shellapi/SIID_MYNETWORK, shellapi/SIID_NETWORKCONNECT, shellapi/SIID_PRINTER, shellapi/SIID_PRINTERFAX, shellapi/SIID_PRINTERFAXNET, shellapi/SIID_PRINTERFILE, shellapi/SIID_PRINTERNET, shellapi/SIID_RECYCLER, shellapi/SIID_RECYCLERFULL, shellapi/SIID_RENAME, shellapi/SIID_SERVER, shellapi/SIID_SERVERSHARE, shellapi/SIID_SETTINGS, shellapi/SIID_SHARE, shellapi/SIID_SHIELD, shellapi/SIID_SLOWFILE, shellapi/SIID_SOFTWARE, shellapi/SIID_STACK, shellapi/SIID_STUFFEDFOLDER, shellapi/SIID_USERS, shellapi/SIID_VIDEOFILES, shellapi/SIID_WARNING, shellapi/SIID_WORLD, shellapi/SIID_ZIPFILE
f1_keywords:
- shellapi/SHSTOCKICONID
dev_langs:
- c++
req.header: shellapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista, Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Shellapi.h
api_name:
- SHSTOCKICONID
targetos: Windows
req.typenames: SHSTOCKICONID
req.redist: 
ms.custom: 19H1
---

# SHSTOCKICONID enumeration


## -description


Used by <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/nf-shellapi-shgetstockiconinfo">SHGetStockIconInfo</a> to identify which stock system icon to retrieve.


## -enum-fields




### -field SIID_DOCNOASSOC

<img alt="Blank document icon" src="./images/SIID_DOCNOASSOC.png"/>
 Document of a type with no associated application.


### -field SIID_DOCASSOC

<img alt="Application-associated document icon" src="./images/SIID_DOCASSOC.jpg"/>
 Document of a type with an associated application.


### -field SIID_APPLICATION

<img alt="" src="./images/SIID_APPLICATION.jpg"/>
 Generic application with no custom icon.


### -field SIID_FOLDER

<img alt="" src="./images/SIID_FOLDER.jpg"/>
 Folder (generic, unspecified state).


### -field SIID_FOLDEROPEN

<img alt="" src="./images/SIID_FOLDEROPEN.jpg"/>
 Folder (open).


### -field SIID_DRIVE525

<img alt="" src="./images/SIID_DRIVE525.jpg"/>
 5.25-inch disk drive.


### -field SIID_DRIVE35

<img alt="" src="./images/SIID_DRIVE35.jpg"/>
 3.5-inch disk drive.


### -field SIID_DRIVEREMOVE

<img alt="" src="./images/SIID_DRIVEREMOVE.png"/>
 Removable drive.


### -field SIID_DRIVEFIXED

<img alt="" src="./images/SIID_DRIVEFIXED.jpg"/>
 Fixed drive (hard disk).


### -field SIID_DRIVENET

<img alt="" src="./images/SIID_DRIVENET.jpg"/>
 Network drive (connected).


### -field SIID_DRIVENETDISABLED

<img alt="" src="./images/SIID_DRIVENETDISABLED.jpg"/>
 Network drive (disconnected).


### -field SIID_DRIVECD

<img alt="" src="./images/SIID_DRIVECD.jpg"/>
 CD drive.


### -field SIID_DRIVERAM

<img alt="" src="./images/SIID_DRIVERAM.jpg"/>
 RAM disk drive.


### -field SIID_WORLD

<img alt="" src="./images/SIID_WORLD.jpg"/>
 The entire network.


### -field SIID_SERVER

<img alt="" src="./images/SIID_SERVER.jpg"/>
 A computer on the network.


### -field SIID_PRINTER

<img alt="" src="./images/SIID_PRINTER.jpg"/>
 A local printer or print destination.


### -field SIID_MYNETWORK

<img alt="" src="./images/SIID_MYNETWORK.jpg"/>
 The <b>Network</b> virtual folder (<a href="https://docs.microsoft.com/windows/desktop/shell/knownfolderid">FOLDERID_NetworkFolder</a>/<a href="https://docs.microsoft.com/windows/desktop/shell/csidl">CSIDL_NETWORK</a>).


### -field SIID_FIND

<img alt="" src="./images/SIID_FIND.jpg"/>
 The <b>Search</b> feature.


### -field SIID_HELP

<img alt="" src="./images/SIID_HELP.jpg"/>
 The <b>Help and Support</b> feature.


### -field SIID_SHARE

<img alt="" src="./images/SIID_SHARE.jpg"/>
 Overlay for a shared item.


### -field SIID_LINK

<img alt="" src="./images/SIID_LINK.jpg"/>
 Overlay for a shortcut.


### -field SIID_SLOWFILE

<img alt="" src="./images/SIID_SLOWFILE.png"/>
 Overlay for items that are expected to be slow to access.


### -field SIID_RECYCLER

<img alt="" src="./images/SIID_RECYCLER.jpg"/>
 The Recycle Bin (empty).


### -field SIID_RECYCLERFULL

<img alt="" src="./images/SIID_RECYCLERFULL.jpg"/>
 The Recycle Bin (not empty).


### -field SIID_MEDIACDAUDIO

<img alt="" src="./images/SIID_MEDIACDAUDIO.jpg"/>
 Audio CD media.


### -field SIID_LOCK

<img alt="" src="./images/SIID_LOCK.jpg"/>
 Security lock.


### -field SIID_AUTOLIST

<img alt="" src="./images/SIID_AUTOLIST.jpg"/>
 A virtual folder that contains the results of a search.


### -field SIID_PRINTERNET

<img alt="" src="./images/SIID_PRINTERNET.jpg"/>
 A network printer.


### -field SIID_SERVERSHARE

<img alt="" src="./images/SIID_SERVERSHARE.jpg"/>
 A server shared on a network.


### -field SIID_PRINTERFAX

<img alt="" src="./images/SIID_PRINTERFAX.jpg"/>
 A local fax printer.


### -field SIID_PRINTERFAXNET

<img alt="" src="./images/SIID_PRINTERFAXNET.jpg"/>
 A network fax printer.


### -field SIID_PRINTERFILE

<img alt="" src="./images/SIID_PRINTERFILE.jpg"/>
 A file that receives the output of a <b>Print to file</b> operation.


### -field SIID_STACK

<img alt="" src="./images/SIID_STACK.jpg"/>
 A category that results from a <b>Stack by</b> command to organize the contents of a folder.


### -field SIID_MEDIASVCD

<img alt="" src="./images/SIID_MEDIASVCD.jpg"/>
 Super Video CD (SVCD) media.


### -field SIID_STUFFEDFOLDER

<img alt="" src="./images/SIID_STUFFEDFOLDER.jpg"/>
 A folder that contains only subfolders as child items.


### -field SIID_DRIVEUNKNOWN

<img alt="" src="./images/SIID_DRIVEUNKNOWN.jpg"/>
 Unknown drive type.


### -field SIID_DRIVEDVD

<img alt="" src="./images/SIID_DRIVEDVD.jpg"/>
 DVD drive.


### -field SIID_MEDIADVD

<img alt="" src="./images/SIID_MEDIADVD.jpg"/>
 DVD media.


### -field SIID_MEDIADVDRAM

<img alt="" src="./images/SIID_MEDIADVDRAM.jpg"/>
 DVD-RAM media.


### -field SIID_MEDIADVDRW

<img alt="" src="./images/SIID_MEDIADVDRW.jpg"/>
 DVD-RW media.


### -field SIID_MEDIADVDR

<img alt="" src="./images/SIID_MEDIADVDR.jpg"/>
 DVD-R media.


### -field SIID_MEDIADVDROM

<img alt="" src="./images/SIID_MEDIADVDROM.jpg"/>
 DVD-ROM media.


### -field SIID_MEDIACDAUDIOPLUS

<img alt="" src="./images/SIID_MEDIACDAUDIOPLUS.jpg"/>
 CD+ (enhanced audio CD) media.


### -field SIID_MEDIACDRW

<img alt="" src="./images/SIID_MEDIACDRW.jpg"/>
 CD-RW media.


### -field SIID_MEDIACDR

<img alt="" src="./images/SIID_MEDIACDR.jpg"/>
 CD-R media.


### -field SIID_MEDIACDBURN

<img alt="" src="./images/SIID_MEDIACDBURN.jpg"/>
 A writeable CD in the process of being burned.


### -field SIID_MEDIABLANKCD

<img alt="" src="./images/SIID_MEDIABLANKCD.jpg"/>
 Blank writable CD media.


### -field SIID_MEDIACDROM

<img alt="" src="./images/SIID_MEDIACDROM.jpg"/>
 CD-ROM media.


### -field SIID_AUDIOFILES

<img alt="" src="./images/SIID_AUDIOFILES.jpg"/>
 An audio file.


### -field SIID_IMAGEFILES

<img alt="" src="./images/SIID_IMAGEFILES.jpg"/>
 An image file.


### -field SIID_VIDEOFILES

<img alt="" src="./images/SIID_VIDEOFILES.jpg"/>
 A video file.


### -field SIID_MIXEDFILES

<img alt="" src="./images/SIID_MIXEDFILES.jpg"/>
 A mixed file.


### -field SIID_FOLDERBACK

<img alt="" src="./images/SIID_FOLDERBACK.jpg"/>
 Folder back.


### -field SIID_FOLDERFRONT

<img alt="" src="./images/SIID_FOLDERFRONT.jpg"/>
 Folder front.


### -field SIID_SHIELD

<img alt="" src="./images/SIID_SHIELD.jpg"/>
 Security shield. Use for UAC prompts only.


### -field SIID_WARNING

<img alt="" src="./images/SIID_WARNING.jpg"/>
 Warning.


### -field SIID_INFO

<img alt="" src="./images/SIID_INFO.jpg"/>
 Informational.


### -field SIID_ERROR

<img alt="" src="./images/SIID_ERROR.jpg"/>
 Error.


### -field SIID_KEY

<img alt="" src="./images/SIID_KEY.jpg"/>
 Key.


### -field SIID_SOFTWARE

<img alt="" src="./images/SIID_SOFTWARE.jpg"/>
 Software.


### -field SIID_RENAME

<img alt="" src="./images/SIID_RENAME.jpg"/>
 A UI item, such as a button, that issues a rename command.


### -field SIID_DELETE

<img alt="" src="./images/SIID_DELETE.jpg"/>
 A UI item, such as a button, that issues a delete command.


### -field SIID_MEDIAAUDIODVD

<img alt="" src="./images/SIID_MEDIAAUDIODVD.jpg"/>
 Audio DVD media.


### -field SIID_MEDIAMOVIEDVD

<img alt="" src="./images/SIID_MEDIAMOVIEDVD.jpg"/>
 Movie DVD media.


### -field SIID_MEDIAENHANCEDCD

<img alt="" src="./images/SIID_MEDIAENHANCEDCD.jpg"/>
 Enhanced CD media.


### -field SIID_MEDIAENHANCEDDVD

<img alt="" src="./images/SIID_MEDIAENHANCEDDVD.jpg"/>
 Enhanced DVD media.


### -field SIID_MEDIAHDDVD

<img alt="" src="./images/SIID_MEDIAHDDVD.jpg"/>
 High definition DVD media in the HD DVD format.


### -field SIID_MEDIABLURAY

<img alt="" src="./images/SIID_MEDIABLURAY.jpg"/>
 High definition DVD media in the Blu-ray Disc™ format.


### -field SIID_MEDIAVCD

<img alt="" src="./images/SIID_MEDIAVCD.jpg"/>
 Video CD (VCD) media.


### -field SIID_MEDIADVDPLUSR

<img alt="" src="./images/SIID_MEDIADVDPLUSR.jpg"/>
 DVD+R media.


### -field SIID_MEDIADVDPLUSRW

<img alt="" src="./images/SIID_MEDIADVDPLUSRW.jpg"/>
 DVD+RW media.


### -field SIID_DESKTOPPC

<img alt="" src="./images/SIID_DESKTOPPC.jpg"/>
 A desktop computer.


### -field SIID_MOBILEPC

<img alt="" src="./images/SIID_MOBILEPC.jpg"/>
 A mobile computer (laptop).


### -field SIID_USERS

<img alt="" src="./images/SIID_USERS.jpg"/>
 The <b>User Accounts</b> Control Panel item.


### -field SIID_MEDIASMARTMEDIA

<img alt="" src="./images/SIID_MEDIASMARTMEDIA.jpg"/>
 Smart media.


### -field SIID_MEDIACOMPACTFLASH

<img alt="" src="./images/SIID_MEDIACOMPACTFLASH.jpg"/>
 CompactFlash media.


### -field SIID_DEVICECELLPHONE

<img alt="" src="./images/SIID_DEVICECELLPHONE.jpg"/>
 A cell phone.


### -field SIID_DEVICECAMERA

<img alt="" src="./images/SIID_DEVICECAMERA.jpg"/>
 A digital camera.


### -field SIID_DEVICEVIDEOCAMERA

<img alt="" src="./images/SIID_DEVICEVIDEOCAMERA.jpg"/>
 A digital video camera.


### -field SIID_DEVICEAUDIOPLAYER

<img alt="" src="./images/SIID_DEVICEAUDIOPLAYER.jpg"/>
 An audio player.


### -field SIID_NETWORKCONNECT

<img alt="" src="./images/SIID_NETWORKCONNECT.jpg"/>
 Connect to network.


### -field SIID_INTERNET

<img alt="" src="./images/SIID_INTERNET.jpg"/>
 The <b>Network and Internet</b> Control Panel item.


### -field SIID_ZIPFILE

<img alt="" src="./images/SIID_ZIPFILE.jpg"/>
 A compressed file with a .zip file name extension.


### -field SIID_SETTINGS

<img alt="" src="./images/SIID_SETTINGS.jpg"/>
 The <b>Additional Options</b> Control Panel item.


### -field SIID_DRIVEHDDVD

<img alt="" src="./images/SIID_DRIVEHDDVD.jpg"/>
<b>Windows Vista with Service Pack 1 (SP1) and later</b>. High definition DVD drive (any type - HD DVD-ROM, HD DVD-R, HD-DVD-RAM) that uses the HD DVD format.


### -field SIID_DRIVEBD

<img alt="" src="./images/SIID_DRIVEBD.jpg"/>
<b>Windows Vista with SP1 and later</b>. High definition DVD drive (any type - BD-ROM, BD-R, BD-RE) that uses the Blu-ray Disc format.


### -field SIID_MEDIAHDDVDROM

<img alt="" src="./images/SIID_MEDIAHDDVDROM.jpg"/>
<b>Windows Vista with SP1 and later</b>. High definition DVD-ROM media in the HD DVD-ROM format.


### -field SIID_MEDIAHDDVDR

<img alt="" src="./images/SIID_MEDIAHDDVDR.jpg"/>
<b>Windows Vista with SP1 and later</b>. High definition DVD-R media in the HD DVD-R format.


### -field SIID_MEDIAHDDVDRAM

<img alt="" src="./images/SIID_MEDIAHDDVDRAM.jpg"/>
<b>Windows Vista with SP1 and later</b>. High definition DVD-RAM media in the HD DVD-RAM format.


### -field SIID_MEDIABDROM

<img alt="" src="./images/SIID_MEDIABDROM.jpg"/>
<b>Windows Vista with SP1 and later</b>. High definition DVD-ROM media in the Blu-ray Disc BD-ROM format.


### -field SIID_MEDIABDR

<img alt="" src="./images/SIID_MEDIABDR.jpg"/>
<b>Windows Vista with SP1 and later</b>. High definition write-once media in the Blu-ray Disc BD-R format.


### -field SIID_MEDIABDRE

<img alt="" src="./images/SIID_MEDIABDRE.jpg"/>
<b>Windows Vista with SP1 and later</b>. High definition read/write media in the Blu-ray Disc BD-RE format.


### -field SIID_CLUSTEREDDRIVE

<img alt="" src="./images/SIID_CLUSTEREDDRIVE.jpg"/>
<b>Windows Vista with SP1 and later</b>. A cluster disk array.


### -field SIID_MAX_ICONS

The highest valid value in the enumeration. Values over 160 are Windows 7-only icons.


## -remarks



SIID_INVALID, with a value of -1, indicates an invalid <b>SHSTOCKICONID</b> value.



