---
UID: NF:shellapi.SHQueryUserNotificationState
title: SHQueryUserNotificationState function (shellapi.h)
description: Checks the state of the computer for the current user to determine whether sending a notification is appropriate.
old-location: shell\SHQueryUserNotificationState.htm
tech.root: shell
ms.assetid: da6b3915-f4fe-4bab-9bae-9bff0b97b5a0
ms.date: 12/05/2018
ms.keywords: SHQueryUserNotificationState, SHQueryUserNotificationState function [Windows Shell], _shell_SHQueryUserNotificationState, shell.SHQueryUserNotificationState, shellapi/SHQueryUserNotificationState
f1_keywords:
- shellapi/SHQueryUserNotificationState
dev_langs:
- c++
req.header: shellapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Shell32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Shell32.dll
- Ext-MS-Win-shell-shell32-l1-2-0.dll
- ext-ms-win-shell-shell32-l1-2-1.dll
- Ext-MS-Win-Shell-Shell32-L1-2-2.dll
api_name:
- SHQueryUserNotificationState
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# SHQueryUserNotificationState function


## -description


Checks the state of the computer for the current user to determine whether sending a notification is appropriate.


## -parameters




### -param pquns [out]

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/shellapi/ne-shellapi-query_user_notification_state">QUERY_USER_NOTIFICATION_STATE</a>*</b>

When this function returns, contains a pointer to one of the values of the <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/ne-shellapi-query_user_notification_state">QUERY_USER_NOTIFICATION_STATE</a> enumeration.


## -returns



Type: <b>HRESULT</b>

If this function succeeds, it returns <b xmlns:loc="http://microsoft.com/wdcml/l10n">S_OK</b>. Otherwise, it returns an <b xmlns:loc="http://microsoft.com/wdcml/l10n">HRESULT</b> error code.




## -remarks



Applications should call <b>SHQueryUserNotificationState</b> and test the return value before displaying any notification UI that is similar to the balloon notifications generated by <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/nf-shellapi-shell_notifyicona">Shell_NotifyIcon</a>. Notifications should only be displayed if this API returns <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/ne-shellapi-query_user_notification_state">QNS_ACCEPTS_NOTIFICATIONS</a>. This informs the application whether the user is running processes that should not be interrupted. Top-level windows receive a <a href="https://docs.microsoft.com/windows/desktop/winmsg/wm-settingchange">WM_SETTINGCHANGE</a> message when the user turns presentation settings on or off, and also when the user's session is locked or unlocked. Note that there are no notifications sent when the user starts or stops a full-screen application.

If this function returns <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/ne-shellapi-query_user_notification_state">QUNS_QUIET_TIME</a>, notifications should be displayed only if critical.



