---
UID: NE:shlobj_core.RESTRICTIONS
title: RESTRICTIONS (shlobj_core.h)
description: These flags are used with the SHRestricted function.
old-location: shell\RESTRICTIONS.htm
tech.root: shell
ms.assetid: 14eac1b9-8ef6-4473-81c1-72ba270a9da7
ms.date: 12/05/2018
ms.keywords: RESTRICTIONS, RESTRICTIONS enumeration [Windows Shell], REST_ALLOWBITBUCKDRIVES, REST_ALLOWCOMMENTTOGGLE, REST_ALLOWFILECLSIDJUNCTIONS, REST_ALLOWLEGACYLMZBEHAVIOR, REST_ALLOWLEGACYWEBVIEW, REST_ALLOWUNHASHEDWEBVIEW, REST_ARP_DONTGROUPPATCHES, REST_ARP_NOADDPAGE, REST_ARP_NOARP, REST_ARP_NOCHOOSEPROGRAMSPAGE, REST_ARP_NOREMOVEPAGE, REST_ARP_NOWINSETUPPAGE, REST_ARP_ShowPostSetup, REST_BITBUCKCONFIRMDELETE, REST_BITBUCKNOPROP, REST_BITBUCKNUKEONDELETE, REST_CLASSICSHELL, REST_CLEARRECENTDOCSONEXIT, REST_DISALLOWCPL, REST_DISALLOWRUN, REST_DONTRETRYBADNETNAME, REST_DONTSHOWSUPERHIDDEN, REST_ENFORCESHELLEXTSECURITY, REST_ENUMWORKGROUP, REST_FORCEACTIVEDESKTOPON, REST_FORCECOPYACLWITHFILE, REST_FORCESTARTMENULOGOFF, REST_GREYMSIADS, REST_HASFINDCOMPUTERS, REST_HIDECLOCK, REST_HIDERUNASVERB, REST_INHERITCONSOLEHANDLES, REST_INTELLIMENUS, REST_LINKRESOLVEIGNORELINKINFO, REST_MYCOMPNOPROP, REST_MYDOCSNOPROP, REST_MYDOCSONNET, REST_MaxRecentDocs, REST_NOACTIVEDESKTOP, REST_NOACTIVEDESKTOPCHANGES, REST_NOADDDESKCOMP, REST_NOAUTOTRAYNOTIFY, REST_NOCDBURNING, REST_NOCHANGEMAPPEDDRIVECOMMENT, REST_NOCHANGEMAPPEDDRIVELABEL, REST_NOCHANGESTARMENU, REST_NOCHANGINGWALLPAPER, REST_NOCLOSE, REST_NOCLOSEDESKCOMP, REST_NOCLOSE_DRAGDROPBAND, REST_NOCOLORCHOICE, REST_NOCOMMONGROUPS, REST_NOCOMPUTERSNEARME, REST_NOCONTROLPANEL, REST_NOCONTROLPANELBARRICADE, REST_NOCSC, REST_NOCURRENTUSERRUN, REST_NOCURRENTUSERRUNONCE, REST_NOCUSTOMIZETHISFOLDER, REST_NOCUSTOMIZEWEBVIEW, REST_NODELDESKCOMP, REST_NODESKCOMP, REST_NODESKTOP, REST_NODESKTOPCLEANUP, REST_NODETAILSTHUMBNAILONNETWORK, REST_NODISCONNECT, REST_NODISPBACKGROUND, REST_NODISPLAYAPPEARANCEPAGE, REST_NODISPLAYCPL, REST_NODISPSCREENSAVEPG, REST_NODISPSCREENSAVEPREVIEW, REST_NODISPSETTINGSPG, REST_NODRIVEAUTORUN, REST_NODRIVES, REST_NODRIVETYPEAUTORUN, REST_NOEDITDESKCOMP, REST_NOENCRYPTION, REST_NOENCRYPTONMOVE, REST_NOENTIRENETWORK, REST_NOENUMENTIRENETWORK, REST_NOEXITTODOS, REST_NOFAVORITESMENU, REST_NOFILEASSOCIATE, REST_NOFILEMENU, REST_NOFIND, REST_NOFOLDEROPTIONS, REST_NOFORGETSOFTWAREUPDATE, REST_NOHARDWARETAB, REST_NOHTMLWALLPAPER, REST_NOINTERNETICON, REST_NOINTERNETOPENWITH, REST_NOLOCALMACHINERUN, REST_NOLOCALMACHINERUNONCE, REST_NOLOGO3CHANNELNOTIFY, REST_NOLOWDISKSPACECHECKS, REST_NOMANAGEMYCOMPUTERVERB, REST_NOMOVINGBAND, REST_NOMYCOMPUTERICON, REST_NONE, REST_NONETCONNECTDISCONNECT, REST_NONETCRAWL, REST_NONETHOOD, REST_NONETWORKCONNECTIONS, REST_NONLEGACYSHELLMODE, REST_NOONLINEPRINTSWIZARD, REST_NOPRINTERADD, REST_NOPRINTERDELETE, REST_NOPRINTERTABS, REST_NOPUBLISHWIZARD, REST_NORECENTDOCSHISTORY, REST_NORECENTDOCSMENU, REST_NORECENTDOCSNETHOOD, REST_NOREMOTECHANGENOTIFY, REST_NOREMOTERECURSIVEEVENTS, REST_NORESOLVESEARCH, REST_NORESOLVETRACK, REST_NORUN, REST_NORUNASINSTALLPROMPT, REST_NOSAVESET, REST_NOSECURITY, REST_NOSETACTIVEDESKTOP, REST_NOSETFOLDERS, REST_NOSETTASKBAR, REST_NOSETTINGSASSIST, REST_NOSHAREDDOCUMENTS, REST_NOSHELLSEARCHBUTTON, REST_NOSIMPLENETIDLIST, REST_NOSIZECHOICE, REST_NOSMBALLOONTIP, REST_NOSMCONFIGUREPROGRAMS, REST_NOSMEJECTPC, REST_NOSMHELP, REST_NOSMMFUPROGRAMS, REST_NOSMMOREPROGRAMS, REST_NOSMMYDOCS, REST_NOSMMYMUSIC, REST_NOSMMYPICS, REST_NOSMNETWORKPLACES, REST_NOSMPINNEDLIST, REST_NOSTARTMENUSUBFOLDERS, REST_NOSTARTPAGE, REST_NOSTARTPANEL, REST_NOSTRCMPLOGICAL, REST_NOTASKGROUPING, REST_NOTHEMESTAB, REST_NOTHUMBNAILCACHE, REST_NOTOOLBARSONTASKBAR, REST_NOTRAYCONTEXTMENU, REST_NOTRAYITEMSDISPLAY, REST_NOUPDATEWINDOWS, REST_NOUPNPINSTALL, REST_NOUSERNAMEINSTARTPANEL, REST_NOVIEWCONTEXTMENU, REST_NOVIEWONDRIVE, REST_NOVISUALSTYLECHOICE, REST_NOWEB, REST_NOWEBSERVICES, REST_NOWEBVIEW, REST_NOWELCOMESCREEN, REST_NOWINKEYS, REST_PROMPTRUNASINSTALLNETPATH, REST_RESTRICTCPL, REST_RESTRICTRUN, REST_REVERTWEBVIEWSECURITY, REST_RUNDLGMEMCHECKBOX, REST_SEPARATEDESKTOPPROCESS, REST_SETVISUALSTYLE, REST_SORTMAXITEMCOUNT, REST_STARTBANNER, REST_STARTMENULOGOFF, REST_STARTRUNNOHOMEPATH, REST_USEDESKTOPINICACHE, _win32_RESTRICTIONS, shell.RESTRICTIONS, shlobj_core/RESTRICTIONS, shlobj_core/REST_ALLOWBITBUCKDRIVES, shlobj_core/REST_ALLOWCOMMENTTOGGLE, shlobj_core/REST_ALLOWFILECLSIDJUNCTIONS, shlobj_core/REST_ALLOWLEGACYLMZBEHAVIOR, shlobj_core/REST_ALLOWLEGACYWEBVIEW, shlobj_core/REST_ALLOWUNHASHEDWEBVIEW, shlobj_core/REST_ARP_DONTGROUPPATCHES, shlobj_core/REST_ARP_NOADDPAGE, shlobj_core/REST_ARP_NOARP, shlobj_core/REST_ARP_NOCHOOSEPROGRAMSPAGE, shlobj_core/REST_ARP_NOREMOVEPAGE, shlobj_core/REST_ARP_NOWINSETUPPAGE, shlobj_core/REST_ARP_ShowPostSetup, shlobj_core/REST_BITBUCKCONFIRMDELETE, shlobj_core/REST_BITBUCKNOPROP, shlobj_core/REST_BITBUCKNUKEONDELETE, shlobj_core/REST_CLASSICSHELL, shlobj_core/REST_CLEARRECENTDOCSONEXIT, shlobj_core/REST_DISALLOWCPL, shlobj_core/REST_DISALLOWRUN, shlobj_core/REST_DONTRETRYBADNETNAME, shlobj_core/REST_DONTSHOWSUPERHIDDEN, shlobj_core/REST_ENFORCESHELLEXTSECURITY, shlobj_core/REST_ENUMWORKGROUP, shlobj_core/REST_FORCEACTIVEDESKTOPON, shlobj_core/REST_FORCECOPYACLWITHFILE, shlobj_core/REST_FORCESTARTMENULOGOFF, shlobj_core/REST_GREYMSIADS, shlobj_core/REST_HASFINDCOMPUTERS, shlobj_core/REST_HIDECLOCK, shlobj_core/REST_HIDERUNASVERB, shlobj_core/REST_INHERITCONSOLEHANDLES, shlobj_core/REST_INTELLIMENUS, shlobj_core/REST_LINKRESOLVEIGNORELINKINFO, shlobj_core/REST_MYCOMPNOPROP, shlobj_core/REST_MYDOCSNOPROP, shlobj_core/REST_MYDOCSONNET, shlobj_core/REST_MaxRecentDocs, shlobj_core/REST_NOACTIVEDESKTOP, shlobj_core/REST_NOACTIVEDESKTOPCHANGES, shlobj_core/REST_NOADDDESKCOMP, shlobj_core/REST_NOAUTOTRAYNOTIFY, shlobj_core/REST_NOCDBURNING, shlobj_core/REST_NOCHANGEMAPPEDDRIVECOMMENT, shlobj_core/REST_NOCHANGEMAPPEDDRIVELABEL, shlobj_core/REST_NOCHANGESTARMENU, shlobj_core/REST_NOCHANGINGWALLPAPER, shlobj_core/REST_NOCLOSE, shlobj_core/REST_NOCLOSEDESKCOMP, shlobj_core/REST_NOCLOSE_DRAGDROPBAND, shlobj_core/REST_NOCOLORCHOICE, shlobj_core/REST_NOCOMMONGROUPS, shlobj_core/REST_NOCOMPUTERSNEARME, shlobj_core/REST_NOCONTROLPANEL, shlobj_core/REST_NOCONTROLPANELBARRICADE, shlobj_core/REST_NOCSC, shlobj_core/REST_NOCURRENTUSERRUN, shlobj_core/REST_NOCURRENTUSERRUNONCE, shlobj_core/REST_NOCUSTOMIZETHISFOLDER, shlobj_core/REST_NOCUSTOMIZEWEBVIEW, shlobj_core/REST_NODELDESKCOMP, shlobj_core/REST_NODESKCOMP, shlobj_core/REST_NODESKTOP, shlobj_core/REST_NODESKTOPCLEANUP, shlobj_core/REST_NODETAILSTHUMBNAILONNETWORK, shlobj_core/REST_NODISCONNECT, shlobj_core/REST_NODISPBACKGROUND, shlobj_core/REST_NODISPLAYAPPEARANCEPAGE, shlobj_core/REST_NODISPLAYCPL, shlobj_core/REST_NODISPSCREENSAVEPG, shlobj_core/REST_NODISPSCREENSAVEPREVIEW, shlobj_core/REST_NODISPSETTINGSPG, shlobj_core/REST_NODRIVEAUTORUN, shlobj_core/REST_NODRIVES, shlobj_core/REST_NODRIVETYPEAUTORUN, shlobj_core/REST_NOEDITDESKCOMP, shlobj_core/REST_NOENCRYPTION, shlobj_core/REST_NOENCRYPTONMOVE, shlobj_core/REST_NOENTIRENETWORK, shlobj_core/REST_NOENUMENTIRENETWORK, shlobj_core/REST_NOEXITTODOS, shlobj_core/REST_NOFAVORITESMENU, shlobj_core/REST_NOFILEASSOCIATE, shlobj_core/REST_NOFILEMENU, shlobj_core/REST_NOFIND, shlobj_core/REST_NOFOLDEROPTIONS, shlobj_core/REST_NOFORGETSOFTWAREUPDATE, shlobj_core/REST_NOHARDWARETAB, shlobj_core/REST_NOHTMLWALLPAPER, shlobj_core/REST_NOINTERNETICON, shlobj_core/REST_NOINTERNETOPENWITH, shlobj_core/REST_NOLOCALMACHINERUN, shlobj_core/REST_NOLOCALMACHINERUNONCE, shlobj_core/REST_NOLOGO3CHANNELNOTIFY, shlobj_core/REST_NOLOWDISKSPACECHECKS, shlobj_core/REST_NOMANAGEMYCOMPUTERVERB, shlobj_core/REST_NOMOVINGBAND, shlobj_core/REST_NOMYCOMPUTERICON, shlobj_core/REST_NONE, shlobj_core/REST_NONETCONNECTDISCONNECT, shlobj_core/REST_NONETCRAWL, shlobj_core/REST_NONETHOOD, shlobj_core/REST_NONETWORKCONNECTIONS, shlobj_core/REST_NONLEGACYSHELLMODE, shlobj_core/REST_NOONLINEPRINTSWIZARD, shlobj_core/REST_NOPRINTERADD, shlobj_core/REST_NOPRINTERDELETE, shlobj_core/REST_NOPRINTERTABS, shlobj_core/REST_NOPUBLISHWIZARD, shlobj_core/REST_NORECENTDOCSHISTORY, shlobj_core/REST_NORECENTDOCSMENU, shlobj_core/REST_NORECENTDOCSNETHOOD, shlobj_core/REST_NOREMOTECHANGENOTIFY, shlobj_core/REST_NOREMOTERECURSIVEEVENTS, shlobj_core/REST_NORESOLVESEARCH, shlobj_core/REST_NORESOLVETRACK, shlobj_core/REST_NORUN, shlobj_core/REST_NORUNASINSTALLPROMPT, shlobj_core/REST_NOSAVESET, shlobj_core/REST_NOSECURITY, shlobj_core/REST_NOSETACTIVEDESKTOP, shlobj_core/REST_NOSETFOLDERS, shlobj_core/REST_NOSETTASKBAR, shlobj_core/REST_NOSETTINGSASSIST, shlobj_core/REST_NOSHAREDDOCUMENTS, shlobj_core/REST_NOSHELLSEARCHBUTTON, shlobj_core/REST_NOSIMPLENETIDLIST, shlobj_core/REST_NOSIZECHOICE, shlobj_core/REST_NOSMBALLOONTIP, shlobj_core/REST_NOSMCONFIGUREPROGRAMS, shlobj_core/REST_NOSMEJECTPC, shlobj_core/REST_NOSMHELP, shlobj_core/REST_NOSMMFUPROGRAMS, shlobj_core/REST_NOSMMOREPROGRAMS, shlobj_core/REST_NOSMMYDOCS, shlobj_core/REST_NOSMMYMUSIC, shlobj_core/REST_NOSMMYPICS, shlobj_core/REST_NOSMNETWORKPLACES, shlobj_core/REST_NOSMPINNEDLIST, shlobj_core/REST_NOSTARTMENUSUBFOLDERS, shlobj_core/REST_NOSTARTPAGE, shlobj_core/REST_NOSTARTPANEL, shlobj_core/REST_NOSTRCMPLOGICAL, shlobj_core/REST_NOTASKGROUPING, shlobj_core/REST_NOTHEMESTAB, shlobj_core/REST_NOTHUMBNAILCACHE, shlobj_core/REST_NOTOOLBARSONTASKBAR, shlobj_core/REST_NOTRAYCONTEXTMENU, shlobj_core/REST_NOTRAYITEMSDISPLAY, shlobj_core/REST_NOUPDATEWINDOWS, shlobj_core/REST_NOUPNPINSTALL, shlobj_core/REST_NOUSERNAMEINSTARTPANEL, shlobj_core/REST_NOVIEWCONTEXTMENU, shlobj_core/REST_NOVIEWONDRIVE, shlobj_core/REST_NOVISUALSTYLECHOICE, shlobj_core/REST_NOWEB, shlobj_core/REST_NOWEBSERVICES, shlobj_core/REST_NOWEBVIEW, shlobj_core/REST_NOWELCOMESCREEN, shlobj_core/REST_NOWINKEYS, shlobj_core/REST_PROMPTRUNASINSTALLNETPATH, shlobj_core/REST_RESTRICTCPL, shlobj_core/REST_RESTRICTRUN, shlobj_core/REST_REVERTWEBVIEWSECURITY, shlobj_core/REST_RUNDLGMEMCHECKBOX, shlobj_core/REST_SEPARATEDESKTOPPROCESS, shlobj_core/REST_SETVISUALSTYLE, shlobj_core/REST_SORTMAXITEMCOUNT, shlobj_core/REST_STARTBANNER, shlobj_core/REST_STARTMENULOGOFF, shlobj_core/REST_STARTRUNNOHOMEPATH, shlobj_core/REST_USEDESKTOPINICACHE
f1_keywords:
- shlobj_core/RESTRICTIONS
dev_langs:
- c++
req.header: shlobj_core.h
req.include-header: Shlobj.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- shlobj_core.h
api_name:
- RESTRICTIONS
targetos: Windows
req.typenames: RESTRICTIONS
req.redist: 
ms.custom: 19H1
---

# RESTRICTIONS enumeration


## -description


These flags are used with the <a href="https://docs.microsoft.com/windows/desktop/api/shlobj_core/nf-shlobj_core-shrestricted">SHRestricted</a> function. <b>SHRestricted</b> is used to determine whether a specified administrator policy is in effect.  In many cases, applications need to modify certain behaviors in order to comply with the policies enacted by system administrators.


## -enum-fields




### -field REST_NONE

Not used.


### -field REST_NORUN

If nonzero, the system administrator has forbidden access to the <b>Run</b> command on the <b>Start</b> menu. Applications should remove similar functionality.  For example, a browser with an address bar should deny attempts by the user to type the path of a local file into the address bar.


### -field REST_NOCLOSE

If nonzero, the system administrator has forbidden access to the <b>Shut Down</b> command on the <b>Start</b> menu. Applications should remove the ability to shut down or restart the computer.


### -field REST_NOSAVESET

If nonzero, the system administrator has requested that applications do not save their state at exit for restoration the next time they are run. Applications should disable saving their window position and settings.


### -field REST_NOFILEMENU

If nonzero, the system administrator has forbidden access to the Windows Explorer <b>File</b> menu. Applications should remove similar functionality.


### -field REST_NOSETFOLDERS

If nonzero, the system administrator has forbidden access to <b>Control Panel</b>, <b>Printers</b>, and <b>Network and Dial up Connections</b>. Applications should prevent users from viewing those folders.


### -field REST_NOSETTASKBAR

If nonzero,  the system administrator has forbidden access to taskbar settings. Applications should prevent users from changing those settings.


### -field REST_NODESKTOP

If nonzero,  the system administrator has specified that all icons on the desktop should be hidden. Applications do not need to perform any special actions.


### -field REST_NOFIND

If nonzero, the system administrator has indicated that the user should not be enabled to search for files. Applications should remove similar functionality.


### -field REST_NODRIVES

A 32-bit value that specifies the drives that should not be displayed to the user.  Bit 0 corresponds to drive A, up to bit 25 which corresponds to drive Z. Applications that display a list of drives should remove drives that have their corresponding bits set.


### -field REST_NODRIVEAUTORUN

A 32-bit value that specifies the drives for which AutoRun should be disabled.  Bit 0 corresponds to drive A, up to bit 25 which corresponds to drive Z. Applications should not offer to AutoRun any drive that has its corresponding bit set.


### -field REST_NODRIVETYPEAUTORUN

A 32-bit value that specifies the drive types for which AutoRun should be disabled.  The bits are numbered according to the return value of <a href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-getdrivetypea">GetDriveType</a>.  For example, bit <b>DRIVE_CDROM</b> disables AutoRun on CD-ROM drives. Applications should not offer to AutoRun any drive whose type has its corresponding bit set.


### -field REST_NONETHOOD

If nonzero, the system administrator has removed <b>Network Neighborhood</b> (also known as <b>My Network Places</b>) from the Shell namespace. Applications should disable functionality that enables the user to browse the network.


### -field REST_STARTBANNER

Not used.


### -field REST_RESTRICTRUN

If nonzero, the system administrator has restricted the programs the user can run.  Only programs listed under the registry key <b>HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer</b> can be run either from the <b>Run</b> dialog box, by double-clicking, or by selecting from the <b>File</b> menu. Applications should prevent users from running programs not listed under that key. Applications that use the <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/nf-shellapi-shellexecutea">ShellExecute</a> or <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/nf-shellapi-shellexecuteexa">ShellExecuteEx</a> functions to run programs do not need to take any special action because those functions check the policy.


### -field REST_NOPRINTERTABS

Not used.


### -field REST_NOPRINTERDELETE

If nonzero, the system administrator has disabled the user's ability to delete printers. Applications should remove the ability to delete printers.


### -field REST_NOPRINTERADD

If nonzero, the system administrator has disabled the user's ability to add printers. Applications should remove the ability to add printers.


### -field REST_NOSTARTMENUSUBFOLDERS

If nonzero, subfolders of the <b>Start</b> menu and <b>Programs</b> menu are not shown on the top of the classic <b>Start</b> menu, the <b>Programs</b> list on the classic <b>Start</b> menu, or the <b>All Programs</b> list on the <b>Start</b> menu. Applications that enumerate the contents of the <b>Start</b> menu should avoid subfolders.  If nonzero, this flag does not restrict any menus other than those listed here; in particular, <b>My Computer</b> can still expand.


### -field REST_MYDOCSONNET

Not used.


### -field REST_NOEXITTODOS

Not used.


### -field REST_ENFORCESHELLEXTSECURITY

If nonzero, the system administrator has forbidden the use of unapproved Shell extensions. Applications should not instantiate Shell extensions unless they are marked as approved by the system administrator.  For more information, see <a href="https://docs.microsoft.com/windows/desktop/shell/handlers">Creating Shell Extension Handlers</a>.


### -field REST_LINKRESOLVEIGNORELINKINFO

If nonzero, the system does not attempt to reconnect mapped network drives when resolving a broken shortcut to a file or folder on a mapped network drive. Applications do not need to perform any special actions.


### -field REST_NOCOMMONGROUPS

If nonzero, indicates the system administrator has forbidden access to the <b>CSIDL_COMMON_STARTMENU</b> or <b>CSIDL_COMMON_PROGRAMS</b> folders on the <b>Start</b> menu. Applications that enumerate the contents of the <b>Start</b> menu should avoid those folders.


### -field REST_SEPARATEDESKTOPPROCESS

If nonzero, the administrator has required that folders be opened in a separate process.  This overrides and disables the corresponding setting in the <b>Folder Options</b> dialog box. Applications do not need to perform any special actions.


### -field REST_NOWEB

If nonzero, the system administrator has removed the <b>Web</b> tab from the desktop <b>Properties</b> dialog box. Applications do not need to perform any special actions. <b>Windows XP and later</b>: Not used.


### -field REST_NOTRAYCONTEXTMENU

If nonzero, the system administrator has forbidden access to context menus for the taskbar. Applications do not need to perform any special actions.


### -field REST_NOVIEWCONTEXTMENU

If nonzero, the system administrator has forbidden access to context menus for Shell objects. Applications should disable context menus for Shell objects.


### -field REST_NONETCONNECTDISCONNECT

If nonzero, the system administrator has denied users the ability to map or disconnect network drives. Applications should remove the ability to map or disconnect network drives.


### -field REST_STARTMENULOGOFF

If 1, the system administrator has removed the <b>Log Off</b> option from the <b>Start</b> menu.  If 2, the system administrator has forced the <b>Log Off</b> option to be shown. Applications do not need to perform any special actions.


### -field REST_NOSETTINGSASSIST

Not used.


### -field REST_NOINTERNETICON

If nonzero, the system administrator has removed the Internet Explorer icon from the desktop. Applications do not need to perform any special actions.


### -field REST_NORECENTDOCSHISTORY

If nonzero, the system administrator has disabled recent document history. Applications must disable all MRU lists, such as those that are often displayed on the <b>File</b> menu. Adherence to this setting is mandatory for Windows logo compliance.


### -field REST_NORECENTDOCSMENU

If nonzero, the system administrator has removed the <b>Recent Documents</b> menu from the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NOACTIVEDESKTOP

If nonzero, the system administrator has disabled the ability to create web content on the desktop. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOACTIVEDESKTOPCHANGES

If nonzero, the system administrator has disabled the ability to change web content on the desktop. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOFAVORITESMENU

If nonzero, the system administrator has removed the <b>Favorites</b> menu from the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_CLEARRECENTDOCSONEXIT

If nonzero, the system administrator has required that recent document history and related history information be deleted when the user logs off. Applications should erase recent document history when they exit.


### -field REST_CLASSICSHELL

Not used.


### -field REST_NOCUSTOMIZEWEBVIEW

If nonzero, the system administrator has disabled the ability to customize the appearance of Windows Explorer folders. Applications do not need to perform any special actions.


### -field REST_NOHTMLWALLPAPER

If nonzero, the system administrator has disabled the ability to set the wallpaper to any image that is not a bitmap (*.bmp) image. Applications that enable the user to change desktop wallpaper should disable web content. <b>Windows Vista or later</b>: Not used.


### -field REST_NOCHANGINGWALLPAPER

If nonzero, the system administrator has disabled the ability to change the desktop wallpaper. Applications should disable corresponding functionality.


### -field REST_NODESKCOMP

If nonzero, the system administrator has disabled desktop components. Applications that create or modify desktop components should disable this functionality. <b>Windows Vista or later</b>: Not used.


### -field REST_NOADDDESKCOMP

If nonzero, the system administrator has disabled the ability to create desktop components. Applications that create desktop components should disable this functionality.


### -field REST_NODELDESKCOMP

If nonzero, the system administrator has disabled the ability to delete desktop components. Applications that delete desktop components should disable this functionality. <b>Windows Vista or later</b>: Not used.


### -field REST_NOCLOSEDESKCOMP

If nonzero, the system administrator has disabled the ability to close desktop components. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOCLOSE_DRAGDROPBAND

If nonzero, the system administrator has disabled the ability to drag, drop, or close desktop bands. Applications do not need to perform any special actions.


### -field REST_NOMOVINGBAND

If nonzero, the system administrator has disabled the ability to move a desktop band. Applications do not need to perform any special actions.


### -field REST_NOEDITDESKCOMP

If nonzero, indicates the system administrator has disabled the ability to modify desktop components. Applications that modify desktop components should disable this functionality. <b>Windows Vista or later</b>: Not used.


### -field REST_NORESOLVESEARCH

If nonzero, the system administrator has disabled heuristic file searching when resolving broken shortcuts. Applications do not need to perform any special actions.


### -field REST_NORESOLVETRACK

If nonzero, the system administrator has disabled the use of the link tracking service when resolving broken shortcuts. Applications do not need to perform any special actions.


### -field REST_FORCECOPYACLWITHFILE

If nonzero, the system administrator has forced Shell file copy operations to copy the ACL with the file rather than inheriting the ACL from the target folder. Applications that use the <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/nf-shellapi-shfileoperationa">SHFileOperation</a> function do not need to perform any special actions. Applications that copy files manually should ensure that the source ACL is copied.


### -field REST_NOLOGO3CHANNELNOTIFY

If nonzero, the system administrator has disabled channel updates when resolving shortcuts. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not supported.


### -field REST_NOFORGETSOFTWAREUPDATE

If nonzero, the system administrator has disabled the ability to uncheck the <b>Remind me until I update the current version</b> checkbox in the <a href="https://docs.microsoft.com/windows/desktop/api/shlobj/nf-shlobj-softwareupdatemessagebox">SoftwareUpdateMessageBox</a> function. Applications do not need to perform any special actions.


### -field REST_NOSETACTIVEDESKTOP

If nonzero, the system administrator has disabled the ability to change settings for web content on the desktop. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOUPDATEWINDOWS

If nonzero, the system administrator has hidden the <b>Windows Update</b> shortcut on the <b>Start</b> menu. Applications that enumerate the contents of the <b>Start</b> menu should not show the <b>Windows Update</b> shortcut to the user.


### -field REST_NOCHANGESTARMENU

If nonzero, the system administrator has disabled the ability to make changes to the <b>Start</b> menu. Applications should disable any feature that enables the user to reorganize their <b>Start</b> menu.


### -field REST_NOFOLDEROPTIONS

If nonzero, the system administrator has denied access to the <b>Folder Options</b> dialog box. Applications that display <b>Folder Options</b> in <b>Control Panel</b> should disable this functionality.


### -field REST_HASFINDCOMPUTERS

If nonzero, the system administrator has disabled the ability to search for computers on the network. Applications should remove the ability to search for computers on the network.


### -field REST_INTELLIMENUS

If nonzero, the system administrator has disabled personalized menus. Applications should not hide infrequently-used menu commands.


### -field REST_RUNDLGMEMCHECKBOX

If nonzero, the system administrator has disabled the <b>Run in separate memory space</b> option in the <b>Run</b> dialog. Applications that provide similar functionality should remove the corresponding checkbox.


### -field REST_ARP_ShowPostSetup

If nonzero, the system administrator has removed the list of incomplete setup operations from the "Add/Remove Windows Components" section of the <b>Add/Remove Programs</b> dialog box. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOCSC

If nonzero, the system administrator has removed <b>Synchronize All</b> from the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NOCONTROLPANEL

If nonzero, the system administrator has denied access to <b>Control Panel</b>. Applications should disable any functionality that runs <code>Control Panel</code>.


### -field REST_ENUMWORKGROUP

If nonzero, the system administrator has indicated that the <b>Network Neighborhood</b> should include the computer workgroup. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_ARP_NOARP

If nonzero, the system administrator has denied access to the <b>Add/Remove Programs</b> dialog box. Applications should disable any functionality that runs the <b>Add/Remove Programs</b> dialog box. <b>Windows Vista or later</b>: Not used.


### -field REST_ARP_NOREMOVEPAGE

If nonzero, the system administrator has denied access to the <b>Change or Remove Programs</b> section of the <b>Add/Remove Programs</b> dialog box. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_ARP_NOADDPAGE

If nonzero, the system administrator has denied access to the <b>Add Programs</b> section of the <b>Add/Remove Programs</b> dialog box. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_ARP_NOWINSETUPPAGE

If nonzero, the system administrator has denied access to the <b>Add/Remove Windows Components</b> section of the <b>Add/Remove Programs</b> dialog box. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_GREYMSIADS

If nonzero, the system administrator has specified that Windows Installer shortcuts that refer to applications that are available but not yet installed should be displayed on the <b>Start</b> menu in gray. Applications do not need to perform any special actions.


### -field REST_NOCHANGEMAPPEDDRIVELABEL

Not used.


### -field REST_NOCHANGEMAPPEDDRIVECOMMENT

Not used.


### -field REST_MaxRecentDocs

A 32-bit value that specifies the maximum number of documents to be retained in the <b>Recent Documents</b> menu.  If this value is zero, then the system administrator has not specified any maximum, and applications can choose a default. If this value is nonzero, applications should restrict their <b>Recent Documents</b> list to the specified number of items.


### -field REST_NONETWORKCONNECTIONS

If nonzero, the system administrator has removed the <b>Network Connections</b> menu from the <b>Start</b> menu. Applications should hide lists of network and dial-up connections.


### -field REST_FORCESTARTMENULOGOFF

If nonzero, the system administrator has forced the <b>Log Off</b> command onto the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NOWEBVIEW

If nonzero, the system administrator has disabled folder HTML templates (Windows 2000) or folder tasks (Windows XP) in Windows Explorer. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOCUSTOMIZETHISFOLDER

If nonzero, the system administrator has disabled the ability to customize the appearance of Windows Explorer folders. Applications do not need to perform any special actions.


### -field REST_NOENCRYPTION

If nonzero, the system administrator has disabled the ability to encrypt and decrypt files and folders. Applications should not call <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-encryptfilea">EncryptFile</a> or <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-decryptfilea">DecryptFile</a>.


### -field REST_DONTSHOWSUPERHIDDEN

If nonzero, the system administrator has disabled the ability to view files marked System and Hidden ("super-hidden files"), overriding the <b>fShowSuperHidden</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/shlobj_core/ns-shlobj_core-shellstatea">SHELLSTATE</a> structure. Applications should not show files that have both the FILE_ATTRIBUTE_SYSTEM and FILE_ATTRIBUTE_HIDDEN attributes to the user.


### -field REST_NOSHELLSEARCHBUTTON

If nonzero, the system administrator has disabled the <b>Search</b> button in the Windows Explorer toolbar. Applications do not need to perform any special actions.


### -field REST_NOHARDWARETAB

If nonzero, the system administrator has disabled the <b>Hardware</b> tab in the <b>Drive</b>, <b>Mouse</b>, <b>Keyboard</b>, and <b>Multimedia</b> property sheets. Applications do not need to perform any special actions.


### -field REST_NORUNASINSTALLPROMPT

If nonzero, the system administrator has disabled the automatic prompt for automatic credentials when installing an application. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_PROMPTRUNASINSTALLNETPATH

If nonzero, the system administrator has disabled the automatic prompt for automatic credentials when installing an application from a network path. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOMANAGEMYCOMPUTERVERB

If nonzero, the system administrator has removed the <b>Manage</b> command from the <b>My Computer</b> context menu. Applications do not need to perform any special actions.


### -field REST_DISALLOWRUN

If nonzero, the system administrator has restricted the programs the user can run.  Programs listed under the registry key 
                            
                               <b>HKEY_CURRENT_USER</b>\<b>Software</b>\<b>Microsoft</b>\<b>Windows</b>\<b>CurrentVersion</b>\<b>Policies</b>\<b>Explorer</b>\<b>DisallowRun</b>may not be run from the <b>Run</b> dialog box, by double-clicking, or by selecting from the <b>File</b> menu.  Programs are listed by their full path (for example, "C:\Windows\system32\cmd.exe"). Applications should prevent users from running programs listed under that key. Applications that use the <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/nf-shellapi-shellexecutea">ShellExecute</a> or <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/nf-shellapi-shellexecuteexa">ShellExecuteEx</a> function to run programs do not need to take any special action because those functions will check the policy.


### -field REST_NOWELCOMESCREEN

If nonzero, the system administrator has disabled the <b>Welcome to Windows</b> program that is run when a user logs on. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_RESTRICTCPL

If nonzero, the system administrator has restricted the control panel applications the user can run.  In order to be run, a control panel application must be listed under the registry key 
                               <b>HKEY_CURRENT_USER</b>\<b>Software</b>\<b>Microsoft</b>\<b>Windows</b>\<b>CurrentVersion</b>\<b>Policies</b>\<b>Explorer</b>\<b>RestrictCpl</b>. The control panel application can be listed either under its display name (for example, "Mouse") or under its filename (for example, "main.cpl"). Applications that launch control panel applications should prevent users from running control panel applications not listed under that key.


### -field REST_DISALLOWCPL

If nonzero, the system administrator has restricted the control panel applications the user can run.  In order to be run, a control panel application must not be listed under the registry key 
                               <b>HKEY_CURRENT_USER</b>\<b>Software</b>\<b>Microsoft</b>\<b>Windows</b>\<b>CurrentVersion</b>\<b>Policies</b>\<b>Explorer</b>\<b>DisallowCpl</b>. The control panel application can be listed either under its display name (for example, "Mouse") or under its filename (for example, "main.cpl"). Applications that launch control panel applications should prevent users from running control panel applications listed under that key.


### -field REST_NOSMBALLOONTIP

If nonzero, the system administrator has disabled balloon tips that are displayed by the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NOSMHELP

If nonzero, the system administrator has removed the <b>Help</b> option from the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NOWINKEYS

If nonzero, the system administrator has disabled the keyboard shortcut associated with the Windows logo key. Applications do not need to perform any special actions.


### -field REST_NOENCRYPTONMOVE

If nonzero, the system administrator has specified that unencrypted files and folders moved into an encrypted folder should remain unencrypted instead of inheriting the encryption attribute from the enclosing folder. Applications that move files and folders should unencrypt them if they were originally unencrypted and are moved into an encrypted folder. Applications that use the <a href="https://docs.microsoft.com/windows/desktop/api/shellapi/nf-shellapi-shfileoperationa">SHFileOperation</a> function to move files do not need to perform any special actions because the <b>SHFileOperation</b> function respects this policy.


### -field REST_NOLOCALMACHINERUN

If nonzero, the system administrator has disabled the execution of programs listed in the 
                   <b>HKEY_LOCAL_MACHINE</b>\<b>Software</b>\<b>Microsoft</b>\<b>Windows</b>\<b>CurrentVersion</b>\<b>Run</b>registry key. Applications do not need to perform any special actions.


### -field REST_NOCURRENTUSERRUN

If nonzero, the system administrator has disabled the execution of programs listed in the 
                   <b>HKEY_CURRENT_USER</b>\<b>Software</b>\<b>Microsoft</b>\<b>Windows</b>\<b>CurrentVersion</b>\<b>Run</b>registry key. Applications do not need to perform any special actions.


### -field REST_NOLOCALMACHINERUNONCE

If nonzero, the system administrator has disabled the execution of programs listed in the 
                   <b>HKEY_LOCAL_MACHINE</b>\<b>Software</b>\<b>Microsoft</b>\<b>Windows</b>\<b>CurrentVersion</b>\<b>RunOnce</b>registry key. Applications do not need to perform any special actions.


### -field REST_NOCURRENTUSERRUNONCE

If nonzero, the system administrator has disabled the execution of programs listed in the 
                   <b>HKEY_CURRENT_USER</b>\<b>Software</b>\<b>Microsoft</b>\<b>Windows</b>\<b>CurrentVersion</b>\<b>RunOnce</b>registry key. Applications do not need to perform any special actions.


### -field REST_FORCEACTIVEDESKTOPON

If nonzero, the system administrator has forced web content to be enabled on the desktop. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOVIEWONDRIVE

A 32-bit value that specifies the drives the user cannot open or drop files into. Bit 0 corresponds to drive A, up to bit 25 which corresponds to drive Z. Applications that enable the user to open folders or drop files should prevent the user from opening a folder on a restricted drive or dropping files onto a restricted drive.


### -field REST_NONETCRAWL

Windows XP, Windows<b>2003, or IE_BACKCOMPAT_VERSION defined.</b> If nonzero, the system administrator has disabled automatic searching for network folders and printers, overriding the <i>fNoNetCrawling</i> member of the <b>SHELLSTATE</b> structure. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOSHAREDDOCUMENTS

Windows XP, Windows<b>2003 or IE_BACKCOMPAT_VERSION defined.</b> If nonzero, the system administrator has hidden the <b>Shared Documents</b> icon in <b>My Computer</b>. Applications should hide access to CSIDL_COMMON_DOCUMENTS. <b>Windows Vista or later</b>: Not used.


### -field REST_NOSMMYDOCS

If nonzero, the system administrator has hidden the <b>My Documents</b> icon on the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NOSMMYPICS

<b>Windows XP or later.</b> If nonzero, the system administrator has hidden the <b>My Pictures</b> icon on the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_ALLOWBITBUCKDRIVES

<b>Windows XP or later.</b> A 32-bit value that specifies the drives for which the <b>Recycle Bin</b> should be forced to be enabled.  The system typically disables the <b>Recycle Bin</b> on drives that are not local fixed drives.  Bit 0 corresponds to drive A, up to bit 25 which corresponds to drive Z. Applications do not need to perform any special actions.


### -field REST_NONLEGACYSHELLMODE

<b>Windows XP or later.</b> If nonzero, the system administrator has hidden the <b>Back</b> and <b>Forward</b> buttons in the Internet Explorer toolbar. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOCONTROLPANELBARRICADE

<b>Windows XP or later.</b> Ignored.


### -field REST_NOSTARTPAGE

<b>Windows XP or later.</b> Ignored.


### -field REST_NOAUTOTRAYNOTIFY

<b>Windows XP or later.</b> If nonzero, the system administrator has forced all taskbar icons to be visible, even if they are inactive, overriding the user's decision to hide inactive taskbar icons. Applications do not need to perform any special actions.


### -field REST_NOTASKGROUPING

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled grouping of similar taskbar buttons, overriding the user's decision to enable taskbar button grouping. Applications do not need to perform any special actions.


### -field REST_NOCDBURNING

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled CD burning. Applications should disable any CD-burning capabilities.


### -field REST_MYCOMPNOPROP

<b>
              Windows 2000 SP3 or later.</b> If nonzero, the system administrator has disabled the <b>System Properties</b> dialog box. Applications should not launch the <b>System Properties</b> dialog box.


### -field REST_MYDOCSNOPROP

<b>
              Windows 2000 SP3 or later.</b> If nonzero, the system administrator has disabled the ability to view properties of the <b>My Documents</b> folder. Applications should not redirect the <b>My Documents</b> folder.


### -field REST_NOSTARTPANEL

<b>
              Windows XP or later.</b> If nonzero, the system administrator has disabled the Windows XP <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NODISPLAYAPPEARANCEPAGE

<b>Windows XP or later.</b> If 1, the system administrator has disabled the <b>Themes</b> and <b>Appearance</b> pages from the <b>Desktop Properties</b> dialog box. Applications should not change system colors and appearance.


### -field REST_NOTHEMESTAB

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the <b>Themes</b> page from the <b>Desktop Properties</b> dialog. Applications should not change visual styles.


### -field REST_NOVISUALSTYLECHOICE

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the ability to change visual styles. Applications should not change visual styles.


### -field REST_NOSIZECHOICE

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the ability to change font sizes from the <b>Appearance</b> page on the Desktop Properties dialog box. Applications should not change system metrics.


### -field REST_NOCOLORCHOICE

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the ability to change system colors from the <b>Appearance</b> page on the <b>Desktop Properties</b> dialog box. Applications should not change system colors.


### -field REST_SETVISUALSTYLE

<b>Windows XP or later.</b> If nonzero, the system administrator has forced a specific visual style. Applications should not change visual styles.


### -field REST_STARTRUNNOHOMEPATH

<b>
              Windows 2000 SP3 or later.</b> If nonzero, the default working directory for programs run from the Run dialog is not forced to the user's home directory. Applications do not need to perform any special actions.


### -field REST_NOUSERNAMEINSTARTPANEL

Windows XP, Windows <b>2003.</b> If nonzero, the system administrator has hidden the user name on the Windows XP <b>Start</b> menu. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_NOMYCOMPUTERICON

<b>Windows XP or later.</b> If nonzero, the system administrator has hidden the <b>My Computer</b> icon. Applications should not permit access to the <b>My Computer</b> icon.


### -field REST_NOSMNETWORKPLACES

<b>Windows XP or later.</b> If nonzero, the system administrator has hidden the <b>Network Places</b> icon on the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NOSMPINNEDLIST

<b>Windows XP or later.</b> If nonzero, the system administrator has hidden the list of "pinned" items on the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NOSMMYMUSIC

<b>Windows XP or later.</b> If nonzero, the system administrator has hidden the <b>My Music</b> icon on the <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NOSMEJECTPC

<b>Windows XP or later.</b> If nonzero, the system administrator has hidden the <b>Eject</b> command on the <b>Start</b> menu. Applications should not enable the user to eject the computer.


### -field REST_NOSMMOREPROGRAMS

<b>
              Windows XP or later.</b> If nonzero, the system administrator has hidden the <b>All Programs</b> item on the Windows XP <b>Start</b> menu. Applications should not show the contents of the <b>Start</b> menu folder to the user.


### -field REST_NOSMMFUPROGRAMS

<b>
              Windows XP or later.</b> If nonzero, the system administrator has hidden the list of most frequently used programs on the Windows XP <b>Start</b> menu. Applications do not need to perform any special actions.


### -field REST_NOTRAYITEMSDISPLAY

<b>Windows XP or later.</b> If nonzero, the system administrator has hidden all taskbar notification icons, regardless of activity. Applications do not need to perform any special actions.


### -field REST_NOTOOLBARSONTASKBAR

<b>Windows XP or later.</b> If nonzero, the system administrator has hidden all taskbar toolbars, such as <b>Quick Launch</b>. Applications do not need to perform any special actions.


### -field REST_NOSMCONFIGUREPROGRAMS

<b>
              Windows 2000 SP3 or later.</b> If nonzero, the system administrator has hidden the <b>Set Program Access</b> and <b>Defaults</b> shortcut on the <b>Start</b> menu. Applications that enumerate the contents of the <b>Start</b> menu should not show the <b>Set Program Access</b> and <b>Defaults</b> shortcut to the user.


### -field REST_HIDECLOCK

<b>Windows XP or later.</b> If nonzero, the system administrator has hidden the clock on the taskbar, overriding any user preference. Applications do not need to perform any special actions.


### -field REST_NOLOWDISKSPACECHECKS

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled taskbar warnings when disk space has become low. Applications do not need to perform any special actions.


### -field REST_NOENTIRENETWORK

<b>Windows 2000 Service Pack 4 (SP4) or later.</b> If nonzero, the system administrator has disabled the <b>Entire Network</b> icon in <b>Network Places</b>. Applications should remove the ability to browse domain resources.


### -field REST_NODESKTOPCLEANUP

Windows XP, Windows<b>2003.</b> If nonzero, the system administrator has disabled the desktop cleaner. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_BITBUCKNUKEONDELETE

<b>Windows XP or later.</b> If nonzero, the system administrator has required that deleted files be removed immediately instead of being placed in the <b>Recycle Bin</b>, overriding any user preference. Applications do not need to perform any special actions.


### -field REST_BITBUCKCONFIRMDELETE

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the user's ability to specify whether confirmation dialogs should be displayed when files are moved to the <b>Recycle Bin</b>. Applications do not need to perform any special actions.


### -field REST_BITBUCKNOPROP

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the user's ability to view or modify <b>Recycle Bin</b> properties. Applications do not need to perform any special actions.


### -field REST_NODISPBACKGROUND

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the user's ability to view or modify the desktop wallpaper. Applications should remove the ability to change the desktop wallpaper.


### -field REST_NODISPSCREENSAVEPG

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the user's ability to view or modify screensaver settings. Applications should remove the ability to change the screensaver or screensaver settings.


### -field REST_NODISPSETTINGSPG

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the user's ability to view or modify screen color depth and resolution settings. Applications should remove the ability to change display color depth and resolution.


### -field REST_NODISPSCREENSAVEPREVIEW

<b>Windows XP or later.</b> Ignored.


### -field REST_NODISPLAYCPL

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the <b>Display Properties</b> dialog box in <b>Control Panel</b>. Applications should remove the ability to change system colors, metrics, visual styles, font size, desktop wallpaper, screensaver, screensaver settings, screen color depth, or display resolution.


### -field REST_HIDERUNASVERB

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled the "Run As" command for Shell objects. Applications should remove corresponding functionality.


### -field REST_NOTHUMBNAILCACHE

<b>Windows XP or later.</b> If nonzero, the system administrator has disabled caching of thumbnails. Applications do not need to perform any special actions.


### -field REST_NOSTRCMPLOGICAL

<b>
              Windows XP SP1 or later, or IE_BACKCOMPAT_VERSION defined.</b>
             If nonzero, the system administrator has specified that filenames should be sorted with the <b>StringCompare</b> function instead of the <b>StrCmpLogical</b> function. Applications that sort filenames should sort accordingly.  (This policy does not apply to Windows 2000.)


### -field REST_NOPUBLISHWIZARD

<b>
              Windows XP SP1 or later service pack, Windows Server 2003 or IE_BACKCOMPAT_VERSION defined.</b> Disables the Windows Publishing Wizard (WPW).<b>Windows Vista or later</b>: Not used.


### -field REST_NOONLINEPRINTSWIZARD

<b>
              Windows XP SP1 or later, or IE_BACKCOMPAT_VERSION defined.</b> Disables the Online Prints Wizard (OPW). <b>Windows Vista or later</b>: Not used.


### -field REST_NOWEBSERVICES

<b>
              Windows XP SP1 or later, or IE_BACKCOMPAT_VERSION defined.</b>
             Disables the web specified services for both the Online Prints Wizard (OPW) and the Windows Publishing Wizard (WPW).


### -field REST_ALLOWUNHASHEDWEBVIEW

<b>
              Windows 2000 SP3 or later, Windows XP, or Windows Server 2003.</b> If nonzero, the system administrator has granted permission for unregistered web view templates to be displayed. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_ALLOWLEGACYWEBVIEW

If nonzero, the system administrator has granted permission for old web view templates (created prior to Windows XP) to be converted to Windows XP templates. Applications do not need to perform any special actions. <b>Windows Vista or later</b>: Not used.


### -field REST_REVERTWEBVIEWSECURITY

<b>
              Windows 2000 SP3 or later, Windows XP, or Windows Server 2003.</b> If nonzero, the system administrator has reduced web view security to the level that existed in Windows 2000 SP2 or earlier. Applications do not need to perform any special actions.  (This policy does not apply to Windows 2000 SP2 or earlier.) <b>Windows Vista or later</b>: Not used.


### -field REST_INHERITCONSOLEHANDLES

<b>Windows 2000 Service Pack 4 (SP4) or later.</b> If nonzero, the ShellExec function checks if the current process and target process are console processes that can inherit handles.


### -field REST_SORTMAXITEMCOUNT

<b>
              Windows XP SP2 and SP3 only. Not supported under Windows Vista or later.</b> Do not sort views with more items than this key. Useful for viewing large numbers of files in one folder.


### -field REST_NOREMOTERECURSIVEEVENTS

<b>
              Windows XP SP2 or later.</b> Do not register network change events recursively. This helps to avoid network traffic.


### -field REST_NOREMOTECHANGENOTIFY

<b>
              Windows XP SP2 or later.</b> Do not notify for remote change notifications.


### -field REST_NOSIMPLENETIDLIST

<b>
              Windows XP SP2 or SP3 only. Not supported under Windows Vista or later.</b> No simple network IDLists.


### -field REST_NOENUMENTIRENETWORK

<b>
              Windows XP SP2 or later.</b> Do not enumerate the entire network.


### -field REST_NODETAILSTHUMBNAILONNETWORK

<b>
              Windows XP SP2 and SP3 only. Not supported under Windows Vista or later.</b>



### -field REST_NOINTERNETOPENWITH

<b>
              Windows XP SP2 or later.</b> If nonzero, the system administrator has removed the ability to resolve file associations using the Internet. The option <b>Use the web service to find the appropriate program</b> is unavailable in the dialog displayed when the user selects <b>Open With</b> or double-clicks an unassociated file type.


### -field REST_DONTRETRYBADNETNAME

<b>
              Windows XP SP2 or later.</b> In <b>Network Places</b>, if the provider returns ERROR_BAD_NET_NAME, do not retry.


### -field REST_ALLOWFILECLSIDJUNCTIONS

<b>
              Windows XP SP2 or later, Windows Server 2003.</b> Re-enable legacy support for file.{guid} junctions in file system folders.


### -field REST_NOUPNPINSTALL

<b>
              Windows XP SP2 or later.</b> Disable the <b>Install Universal Plug and Play (UPnP)</b> task in <b>My Network Places</b>.


### -field REST_ARP_DONTGROUPPATCHES

If nonzero, the system administrator has removed the option to list individual patches in Add/Remove Programs. <b>Windows Vista or later</b>: Not used.


### -field REST_ARP_NOCHOOSEPROGRAMSPAGE

If nonzero, the system administrator has removed the option to choose the programs page. <b>Windows Vista or later</b>: Not used.


### -field REST_NODISCONNECT

<b>Not supported under Windows Vista or later</b>. If nonzero, the system administrator has removed the <b>Disconnect</b> option from the <b>Start</b> menu and <b>Task Manager</b>. Applications should remove the ability to disconnect users from a Terminal Server session.


### -field REST_NOSECURITY

<b>Not supported under Windows Vista and later</b>. If nonzero, the system administrator has removed the <b>Windows Security</b> option from the <b>Start</b> menu and <b>Task Manager</b>. Applications do not need to perform any special actions.


### -field REST_NOFILEASSOCIATE

<b>Not supported under Windows Vista and later</b>. If nonzero, the system administrator has removed the ability to change file associations. Applications should not enable users to change file associations arbitrarily.


### -field REST_ALLOWCOMMENTTOGGLE

<b>
              Windows XP SP2 only. Not supported under Windows Vista or later.</b> Allows the user to toggle the position of the Comment and the Computer Name.


### -field REST_USEDESKTOPINICACHE

<b>
              Windows XP SP2 and SP3 only. Not supported under Windows Vista or later.</b> Cache desktop.ini entries from network folders.


#### - REST_ALLOWLEGACYLMZBEHAVIOR

<b>
              Windows XP SP2 only. Not supported under Windows Vista or later.</b> Indicates allowable LMZ behavior for ActiveX objects changed in Windows XP SP2, this policy gets the pre-Windows XP SP2 behavior.


#### - REST_NOCOMPUTERSNEARME

<b>Not supported under Windows Vista and later</b>. If nonzero, the system administrator has hidden the <b>Computers Near Me</b> icon in the <b>My Network Places</b> folder. Applications should remove access to CSIDL_COMPUTERSNEARME.


#### - REST_NORECENTDOCSNETHOOD

Windows Vista. If nonzero, the system administrator has disabled the automatic addition of shortcuts in <b>Network Neighborhood</b> to recently-accessed network resources. Applications do not need to perform any special actions.

