---
UID: NE:shlobj_core.__unnamed_enum_8
title: SCNRT_STATUS (shlobj_core.h)
description: Indicates whether to enable or disable Async Register and Deregister for SHChangeNotifyRegisterThread.
old-location: shell\SCNRT_STATUS.htm
tech.root: shell
ms.assetid: 31fd993b-d8cb-40cc-9f31-15711dba1b10
ms.date: 12/05/2018
ms.keywords: SCNRT_DISABLE, SCNRT_ENABLE, SCNRT_STATUS, SCNRT_STATUS enumeration [Windows Shell], _shell_SCNRT_STATUS, shell.SCNRT_STATUS, shlobj_core/SCNRT_DISABLE, shlobj_core/SCNRT_ENABLE, shlobj_core/SCNRT_STATUS
f1_keywords:
- shlobj_core/SCNRT_STATUS
dev_langs:
- c++
req.header: shlobj_core.h
req.include-header: Shlobj.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- shlobj_core.h
api_name:
- SCNRT_STATUS
targetos: Windows
req.typenames: SCNRT_STATUS
req.redist: 
ms.custom: 19H1
---

# SCNRT_STATUS enumeration


## -description


Indicates whether to enable or disable Async Register and Deregister for <a href="https://docs.microsoft.com/windows/desktop/api/shlobj/nf-shlobj-shchangenotifyregisterthread">SHChangeNotifyRegisterThread</a>.


## -enum-fields




### -field SCNRT_ENABLE

Enable Async Register and Deregister for <a href="https://docs.microsoft.com/windows/desktop/api/shlobj/nf-shlobj-shchangenotifyregisterthread">SHChangeNotifyRegisterThread</a>.


### -field SCNRT_DISABLE

Disable Async Register and Deregister for <a href="https://docs.microsoft.com/windows/desktop/api/shlobj/nf-shlobj-shchangenotifyregisterthread">SHChangeNotifyRegisterThread</a>.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/shlobj/nf-shlobj-shchangenotifyregisterthread">SHChangeNotifyRegisterThread</a>
 

 

