---
UID: NE:shlwapi.__unnamed_enum_11
title: SHGLOBALCOUNTER (shlwapi.h)
description: Identifiers for various global counters, or shared variables. Each global counter can be incremented or decremented using SHGlobalCounterIncrement and SHGlobalCounterDecrement.
old-location: shell\SHGLOBALCOUNTER.htm
tech.root: shell
ms.assetid: e96f40fb-3a95-41d2-a45f-a8d91fb544d3
ms.date: 12/05/2018
ms.keywords: GLOBALCOUNTER_APPLICATION_DESTINATIONS, GLOBALCOUNTER_APPROVEDSITES, GLOBALCOUNTER_APPSFOLDER_FILETYPEASSOCIATION_COUNTER, GLOBALCOUNTER_APP_ITEMS_STATE_STORE_CACHE, GLOBALCOUNTER_ASSOCCHANGED, GLOBALCOUNTER_BITBUCKETNUMDELETERS, GLOBALCOUNTER_COMMONPLACES_LIST_CACHE, GLOBALCOUNTER_FOLDERDEFINITION_CACHE, GLOBALCOUNTER_FOLDERSETTINGSCHANGE, GLOBALCOUNTER_IEONLY_SESSIONS, GLOBALCOUNTER_IESESSIONS, GLOBALCOUNTER_INTERNETTOOLBAR_LAYOUT, GLOBALCOUNTER_MAXIMUMVALUE, GLOBALCOUNTER_OVERLAYMANAGER, GLOBALCOUNTER_PRIVATE_PROFILE_CACHE, GLOBALCOUNTER_PRIVATE_PROFILE_CACHE_MACHINEWIDE, GLOBALCOUNTER_QUERYASSOCIATIONS, GLOBALCOUNTER_RATINGS, GLOBALCOUNTER_RATINGS_STATECOUNTER, GLOBALCOUNTER_RECYCLEBINCORRUPTED, GLOBALCOUNTER_RECYCLEBINENUM, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_A, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_B, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_C, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_D, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_E, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_F, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_G, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_H, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_I, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_J, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_K, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_L, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_M, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_N, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_O, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_P, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Q, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_R, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_S, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_T, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_U, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_V, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_W, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_X, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Y, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Z, GLOBALCOUNTER_RECYCLEDIRTYCOUNT_SHARES, GLOBALCOUNTER_RESTRICTIONS, GLOBALCOUNTER_SEARCHMANAGER, GLOBALCOUNTER_SEARCHOPTIONS, GLOBALCOUNTER_SETTINGSYNC_ENABLED, GLOBALCOUNTER_SHELLSETTINGSCHANGED, GLOBALCOUNTER_SYNC_ENGINE_INFORMATION_CACHE_MACHINEWIDE, GLOBALCOUNTER_SYSTEMPIDLCHANGE, GLOBALCOUNTER_USERINFOCHANGED, SHGLOBALCOUNTER, SHGLOBALCOUNTER enumeration [Windows Shell], __UNUSED_RECYCLE_WAS_GLOBALCOUNTER_CSCSYNCINPROGRESS, __UNUSED_RECYCLE_WAS_GLOBALCOUNTER_RECYCLEDIRTYCOUNT_SERVERDRIVE, __UNUSED_RECYCLE_WAS_GLOBALCOUNTER_RECYCLEGLOBALDIRTYCOUNT, _shell_SHGLOBALCOUNTER, shell.SHGLOBALCOUNTER, shlwapi/GLOBALCOUNTER_APPLICATION_DESTINATIONS, shlwapi/GLOBALCOUNTER_APPROVEDSITES, shlwapi/GLOBALCOUNTER_APPSFOLDER_FILETYPEASSOCIATION_COUNTER, shlwapi/GLOBALCOUNTER_APP_ITEMS_STATE_STORE_CACHE, shlwapi/GLOBALCOUNTER_ASSOCCHANGED, shlwapi/GLOBALCOUNTER_BITBUCKETNUMDELETERS, shlwapi/GLOBALCOUNTER_COMMONPLACES_LIST_CACHE, shlwapi/GLOBALCOUNTER_FOLDERDEFINITION_CACHE, shlwapi/GLOBALCOUNTER_FOLDERSETTINGSCHANGE, shlwapi/GLOBALCOUNTER_IEONLY_SESSIONS, shlwapi/GLOBALCOUNTER_IESESSIONS, shlwapi/GLOBALCOUNTER_INTERNETTOOLBAR_LAYOUT, shlwapi/GLOBALCOUNTER_MAXIMUMVALUE, shlwapi/GLOBALCOUNTER_OVERLAYMANAGER, shlwapi/GLOBALCOUNTER_PRIVATE_PROFILE_CACHE, shlwapi/GLOBALCOUNTER_PRIVATE_PROFILE_CACHE_MACHINEWIDE, shlwapi/GLOBALCOUNTER_QUERYASSOCIATIONS, shlwapi/GLOBALCOUNTER_RATINGS, shlwapi/GLOBALCOUNTER_RATINGS_STATECOUNTER, shlwapi/GLOBALCOUNTER_RECYCLEBINCORRUPTED, shlwapi/GLOBALCOUNTER_RECYCLEBINENUM, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_A, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_B, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_C, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_D, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_E, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_F, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_G, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_H, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_I, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_J, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_K, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_L, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_M, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_N, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_O, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_P, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Q, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_R, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_S, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_T, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_U, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_V, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_W, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_X, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Y, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Z, shlwapi/GLOBALCOUNTER_RECYCLEDIRTYCOUNT_SHARES, shlwapi/GLOBALCOUNTER_RESTRICTIONS, shlwapi/GLOBALCOUNTER_SEARCHMANAGER, shlwapi/GLOBALCOUNTER_SEARCHOPTIONS, shlwapi/GLOBALCOUNTER_SETTINGSYNC_ENABLED, shlwapi/GLOBALCOUNTER_SHELLSETTINGSCHANGED, shlwapi/GLOBALCOUNTER_SYNC_ENGINE_INFORMATION_CACHE_MACHINEWIDE, shlwapi/GLOBALCOUNTER_SYSTEMPIDLCHANGE, shlwapi/GLOBALCOUNTER_USERINFOCHANGED, shlwapi/SHGLOBALCOUNTER, shlwapi/__UNUSED_RECYCLE_WAS_GLOBALCOUNTER_CSCSYNCINPROGRESS, shlwapi/__UNUSED_RECYCLE_WAS_GLOBALCOUNTER_RECYCLEDIRTYCOUNT_SERVERDRIVE, shlwapi/__UNUSED_RECYCLE_WAS_GLOBALCOUNTER_RECYCLEGLOBALDIRTYCOUNT
f1_keywords:
- shlwapi/SHGLOBALCOUNTER
dev_langs:
- c++
req.header: shlwapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Shlwapi.h
api_name:
- SHGLOBALCOUNTER
targetos: Windows
req.typenames: SHGLOBALCOUNTER
req.redist: 
ms.custom: 19H1
---

# SHGLOBALCOUNTER enumeration


## -description


Identifiers for various global counters, or shared variables. Each global counter can be incremented or decremented using <a href="https://docs.microsoft.com/windows/desktop/api/shlwapi/nf-shlwapi-shglobalcounterincrement">SHGlobalCounterIncrement</a> and <a href="https://docs.microsoft.com/windows/desktop/api/shlwapi/nf-shlwapi-shglobalcounterdecrement">SHGlobalCounterDecrement</a>.


## -enum-fields




### -field GLOBALCOUNTER_SEARCHMANAGER

The global counter for use with the <a href="https://docs.microsoft.com/windows/desktop/api/searchapi/nn-searchapi-isearchmanager">ISearchManager</a>.


### -field GLOBALCOUNTER_SEARCHOPTIONS

The global counter for use with <a href="https://docs.microsoft.com/windows/desktop/api/searchapi/nn-searchapi-isearchqueryhelper">ISearchQueryHelper</a> to identify whether a query parser's settings have changed.


### -field GLOBALCOUNTER_FOLDERSETTINGSCHANGE

The global counter used to identify whether folder settings have changed.


### -field GLOBALCOUNTER_RATINGS

The global counter used to identify whether ratings have changed.


### -field GLOBALCOUNTER_APPROVEDSITES

The global counter used to identify whether approved sites have changed.


### -field GLOBALCOUNTER_RESTRICTIONS

The global counter used to identify whether restrictions have changed.


### -field GLOBALCOUNTER_SHELLSETTINGSCHANGED

The global counter used to identify whether Shell settings have changed.


### -field GLOBALCOUNTER_SYSTEMPIDLCHANGE

The global counter used to identify whether a system PIDL has changed.


### -field GLOBALCOUNTER_OVERLAYMANAGER

The global counter used to identify whether the overlay manager state has changed.


### -field GLOBALCOUNTER_QUERYASSOCIATIONS

The global counter used to identify whether query associations have changed.


### -field GLOBALCOUNTER_IESESSIONS

The global counter used to identify whether the number of IE sessions has changed.


### -field GLOBALCOUNTER_IEONLY_SESSIONS

The global counter used to identify whether the number of IE sessions has changed.


### -field GLOBALCOUNTER_APPLICATION_DESTINATIONS

Identifies The global counter used to identify whether applications have been added or removed from the system.


### -field __UNUSED_RECYCLE_WAS_GLOBALCOUNTER_CSCSYNCINPROGRESS

Unused.


### -field GLOBALCOUNTER_BITBUCKETNUMDELETERS

The global counter used to identify deletions to the Recycle Bin.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_SHARES

The global counter used to identify whether settings have changed on a share.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_A

The global counter used to identify whether settings have changed on drive A.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_B

The global counter used to identify whether settings have changed on drive B.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_C

The global counter used to identify whether settings have changed on drive C.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_D

The global counter used to identify whether settings have changed on drive D.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_E

The global counter used to identify whether settings have changed on drive E.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_F

The global counter used to identify whether settings have changed on drive F.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_G

The global counter used to identify whether settings have changed on drive G.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_H

The global counter used to identify whether settings have changed on drive H.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_I

The global counter used to identify whether settings have changed on drive I.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_J

The global counter used to identify whether settings have changed on drive J.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_K

The global counter used to identify whether settings have changed on drive K.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_L

The global counter used to identify whether settings have changed on drive L.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_M

The global counter used to identify whether settings have changed on drive M.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_N

The global counter used to identify whether settings have changed on drive N.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_O

The global counter used to identify whether settings have changed on drive O.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_P

The global counter used to identify whether settings have changed on drive P.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Q

The global counter used to identify whether settings have changed on drive Q.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_R

The global counter used to identify whether settings have changed on drive R.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_S

The global counter used to identify whether settings have changed on drive S.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_T

The global counter used to identify whether settings have changed on drive T.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_U

The global counter used to identify whether settings have changed on drive U.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_V

The global counter used to identify whether settings have changed on drive V.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_W

The global counter used to identify whether settings have changed on drive W.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_X

The global counter used to identify whether settings have changed on drive X.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Y

The global counter used to identify whether settings have changed on drive Y.


### -field GLOBALCOUNTER_RECYCLEDIRTYCOUNT_DRIVE_Z

The global counter used to identify whether settings have changed on drive Z.


### -field __UNUSED_RECYCLE_WAS_GLOBALCOUNTER_RECYCLEDIRTYCOUNT_SERVERDRIVE

Unused.


### -field __UNUSED_RECYCLE_WAS_GLOBALCOUNTER_RECYCLEGLOBALDIRTYCOUNT

Unused.


### -field GLOBALCOUNTER_RECYCLEBINENUM

The global counter used to identify whether the Recycle Bin settings have changed.


### -field GLOBALCOUNTER_RECYCLEBINCORRUPTED

The global counter used to identify whether a Recycle Bin has been deleted.


### -field GLOBALCOUNTER_RATINGS_STATECOUNTER

The global counter used to identify whether ratings have changed.


### -field GLOBALCOUNTER_PRIVATE_PROFILE_CACHE

The global counter state.


### -field GLOBALCOUNTER_INTERNETTOOLBAR_LAYOUT

The global counter used to identify whether the Internet toolbar layout has changed.


### -field GLOBALCOUNTER_FOLDERDEFINITION_CACHE

The global counter used to identify changes to the folder definition cache.


### -field GLOBALCOUNTER_COMMONPLACES_LIST_CACHE

The global counter used to identify state changes for the commonplaces list cache.


### -field GLOBALCOUNTER_PRIVATE_PROFILE_CACHE_MACHINEWIDE

The global counter state, machine-wide.


### -field GLOBALCOUNTER_ASSOCCHANGED

The global counter used to identify the current GlobalAssocChangedCounter registry value for HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Explorer.
                    


### -field GLOBALCOUNTER_APP_ITEMS_STATE_STORE_CACHE

<b>Introduced in Windows 8</b>. The global counter used to identify whether the Store is current.


### -field GLOBALCOUNTER_SETTINGSYNC_ENABLED

<b>Introduced in Windows 8</b>. The global counter used to determine whether sync is enabled or disabled.


### -field GLOBALCOUNTER_APPSFOLDER_FILETYPEASSOCIATION_COUNTER

<b>Introduced in Windows 8</b>. The global counter used to identify the current FTACounter registry value for HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\ImmersiveShell\StateStore.


### -field GLOBALCOUNTER_USERINFOCHANGED

<b>Introduced in Windows 8</b>. The global counter used to identify user info change state.


### -field GLOBALCOUNTER_SYNC_ENGINE_INFORMATION_CACHE_MACHINEWIDE

<b>Introduced in Windows 8.1</b>. The global counter used to identify sync engine counter state, machine wide..


### -field GLOBALCOUNTER_BANNERS_DATAMODEL_CACHE_MACHINEWIDE


### -field GLOBALCOUNTER_MAXIMUMVALUE

The maximum value any shared variable can have.


## -remarks



These global counters are shared variables that can help identify whether the state of a Windows component has changed over time. They can be used with these functions: <a href="https://docs.microsoft.com/windows/desktop/api/shlwapi/nf-shlwapi-shglobalcounterdecrement">SHGlobalCounterDecrement</a>, <a href="https://docs.microsoft.com/windows/desktop/api/shlwapi/nf-shlwapi-shglobalcounterincrement">SHGlobalCounterIncrement</a>, <a href="https://docs.microsoft.com/windows/desktop/api/shlwapi/nf-shlwapi-shglobalcountergetvalue">SHGlobalCounterGetValue</a>.

<h3><a id="Example"></a><a id="example"></a><a id="EXAMPLE"></a>Example</h3>
The following pseudocode example shows how a global counter can be used.


```
void ValidateSomeSettings()
    {
        // Get the current GLOBALCOUNTER_SHELLSETTINGSCHANGED value.
        long lGlobalSettingsCounter = SHGlobalCounterGetValue(GLOBALCOUNTER_SHELLSETTINGSCHANGED);
            
        // Do some other work
        ...
    
        // Verify whether the Shell settings have changed since entering this method.
        if (lGlobalSettingsCounter == SHGlobalCounterGetValue(GLOBALCOUNTER_SHELLSETTINGSCHANGED))
        {
            // Commit the work that was done earlier 
            ...
        }
    
        else
        {
            // Shell settings have changed. Rollback and redo.
            ...
        }
    }
```





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/shlwapi/nf-shlwapi-shglobalcounterdecrement">SHGlobalCounterDecrement</a>



<a href="https://docs.microsoft.com/windows/desktop/api/shlwapi/nf-shlwapi-shglobalcountergetvalue">SHGlobalCounterGetValue</a>



<a href="https://docs.microsoft.com/windows/desktop/api/shlwapi/nf-shlwapi-shglobalcounterincrement">SHGlobalCounterIncrement</a>
 

 

