---
UID: NE:shlwapi.__unnamed_enum_0
title: URL_SCHEME (shlwapi.h)
description: Used to specify URL schemes.
old-location: shell\URL_SCHEME.htm
tech.root: shell
ms.assetid: 45686920-356d-4dd7-8482-2427854a92ed
ms.date: 12/05/2018
ms.keywords: URL_SCHEME, URL_SCHEME enumeration [Windows Shell], URL_SCHEME_ABOUT, URL_SCHEME_FILE, URL_SCHEME_FTP, URL_SCHEME_GOPHER, URL_SCHEME_HTTP, URL_SCHEME_HTTPS, URL_SCHEME_INVALID, URL_SCHEME_JAVASCRIPT, URL_SCHEME_KNOWNFOLDER, URL_SCHEME_LOCAL, URL_SCHEME_MAILTO, URL_SCHEME_MAXVALUE, URL_SCHEME_MK, URL_SCHEME_MSHELP, URL_SCHEME_MSSHELLDEVICE, URL_SCHEME_MSSHELLIDLIST, URL_SCHEME_MSSHELLROOTED, URL_SCHEME_NEWS, URL_SCHEME_NNTP, URL_SCHEME_RES, URL_SCHEME_SEARCH, URL_SCHEME_SEARCH_MS, URL_SCHEME_SHELL, URL_SCHEME_SNEWS, URL_SCHEME_TELNET, URL_SCHEME_UNKNOWN, URL_SCHEME_VBSCRIPT, URL_SCHEME_WAIS, URL_SCHEME_WILDCARD, _win32_URL_SCHEME, shell.URL_SCHEME, shlwapi/URL_SCHEME, shlwapi/URL_SCHEME_ABOUT, shlwapi/URL_SCHEME_FILE, shlwapi/URL_SCHEME_FTP, shlwapi/URL_SCHEME_GOPHER, shlwapi/URL_SCHEME_HTTP, shlwapi/URL_SCHEME_HTTPS, shlwapi/URL_SCHEME_INVALID, shlwapi/URL_SCHEME_JAVASCRIPT, shlwapi/URL_SCHEME_KNOWNFOLDER, shlwapi/URL_SCHEME_LOCAL, shlwapi/URL_SCHEME_MAILTO, shlwapi/URL_SCHEME_MAXVALUE, shlwapi/URL_SCHEME_MK, shlwapi/URL_SCHEME_MSHELP, shlwapi/URL_SCHEME_MSSHELLDEVICE, shlwapi/URL_SCHEME_MSSHELLIDLIST, shlwapi/URL_SCHEME_MSSHELLROOTED, shlwapi/URL_SCHEME_NEWS, shlwapi/URL_SCHEME_NNTP, shlwapi/URL_SCHEME_RES, shlwapi/URL_SCHEME_SEARCH, shlwapi/URL_SCHEME_SEARCH_MS, shlwapi/URL_SCHEME_SHELL, shlwapi/URL_SCHEME_SNEWS, shlwapi/URL_SCHEME_TELNET, shlwapi/URL_SCHEME_UNKNOWN, shlwapi/URL_SCHEME_VBSCRIPT, shlwapi/URL_SCHEME_WAIS, shlwapi/URL_SCHEME_WILDCARD
f1_keywords:
- shlwapi/URL_SCHEME
dev_langs:
- c++
req.header: shlwapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional, Windows XP, Windows Vista, Windows 7 [desktop apps only]
req.target-min-winversvr: Windows 2000 Server, Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Shlwapi.h
api_name:
- URL_SCHEME
targetos: Windows
req.typenames: URL_SCHEME
req.redist: 
ms.custom: 19H1
---

# URL_SCHEME enumeration


## -description


Used to specify URL schemes.


## -enum-fields




### -field URL_SCHEME_INVALID

An invalid scheme.


### -field URL_SCHEME_UNKNOWN

An unknown scheme.


### -field URL_SCHEME_FTP

FTP (ftp:).


### -field URL_SCHEME_HTTP

HTTP (http:).


### -field URL_SCHEME_GOPHER

Gopher (gopher:).


### -field URL_SCHEME_MAILTO

Mail-to (mailto:).


### -field URL_SCHEME_NEWS

Usenet news (news:).


### -field URL_SCHEME_NNTP

Usenet news with NNTP (nntp:).


### -field URL_SCHEME_TELNET

Telnet (telnet:).


### -field URL_SCHEME_WAIS

Wide Area Information Server (wais:).


### -field URL_SCHEME_FILE

File (file:).


### -field URL_SCHEME_MK

URL moniker (mk:).


### -field URL_SCHEME_HTTPS

URL HTTPS (https:).


### -field URL_SCHEME_SHELL

Shell (shell:).


### -field URL_SCHEME_SNEWS

NNTP news postings with SSL (snews:).


### -field URL_SCHEME_LOCAL

Local (local:).


### -field URL_SCHEME_JAVASCRIPT

JavaScript (javascript:).


### -field URL_SCHEME_VBSCRIPT

VBScript (vbscript:).


### -field URL_SCHEME_ABOUT

About (about:).


### -field URL_SCHEME_RES

Res (res:).


### -field URL_SCHEME_MSSHELLROOTED

Internet Explorer 6 and later only. Shell-rooted (ms-shell-rooted:)


### -field URL_SCHEME_MSSHELLIDLIST

Internet Explorer 6 and later only. Shell ID-list (ms-shell-idlist:).


### -field URL_SCHEME_MSHELP

Internet Explorer 6 and later only. MSHelp (hcp:).


### -field URL_SCHEME_MSSHELLDEVICE

Not supported.


### -field URL_SCHEME_WILDCARD

Internet Explorer 7 and later only. Wildcard (*:).


### -field URL_SCHEME_SEARCH_MS

Windows Vista and later only. Search-MS (search-ms:).


### -field URL_SCHEME_SEARCH

Windows Vista with SP1 and later only. Search (search:).


### -field URL_SCHEME_KNOWNFOLDER

<b>Windows 7 and later</b>. Known folder (knownfolder:).


### -field URL_SCHEME_MAXVALUE

The highest legitimate value in the enumeration, used for validation purposes.

