---
UID: NF:shobjidl.IResultsFolder.AddIDList
title: IResultsFolder::AddIDList (shobjidl.h)
description: Inserts a pointer to an item identifier list (PIDL) into a results folder.
old-location: shell\IResultsFolder_AddIDList.htm
tech.root: shell
ms.assetid: 0514fe4d-87d3-4665-a35b-9f9788fc169d
ms.date: 12/05/2018
ms.keywords: AddIDList, AddIDList method [Windows Shell], AddIDList method [Windows Shell],IResultsFolder interface, IResultsFolder interface [Windows Shell],AddIDList method, IResultsFolder.AddIDList, IResultsFolder::AddIDList, _shell_IResultsFolder_AddIDList, shell.IResultsFolder_AddIDList, shobjidl/IResultsFolder::AddIDList
f1_keywords:
- shobjidl/IResultsFolder.AddIDList
dev_langs:
- c++
req.header: shobjidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shobjidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Shobjidl.h
api_name:
- IResultsFolder.AddIDList
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IResultsFolder::AddIDList


## -description


Inserts a pointer to an item identifier list (PIDL) into a results folder.


## -parameters




### -param pidl [in]

Type: <b>PCIDLIST_ABSOLUTE</b>

A pointer to the IDList of the given object relative to the Desktop.


### -param ppidlAdded [out]

Type: <b>PITEMID_CHILD*</b>

A PIDL consisting of 0 or 1 <a href="https://docs.microsoft.com/windows/desktop/api/shtypes/ns-shtypes-shitemid">SHITEMID</a> structures, relative to a parent folder. This parameter maybe <b>NULL</b>.
        


## -returns



Type: <b>HRESULT</b>

If this method succeeds, it returns <b xmlns:loc="http://microsoft.com/wdcml/l10n">S_OK</b>. Otherwise, it returns an <b xmlns:loc="http://microsoft.com/wdcml/l10n">HRESULT</b> error code.




## -remarks



The PIDL received represents the item that was just added and is a unique representation of this item generated by this results folder. It is only valid when used in reference to this results folder and should not be combined with a PIDL to another folder, including the folder this item originally came from.
      



