---
UID: NN:shobjidl.IQueryCodePage
title: IQueryCodePage (shobjidl.h)
description: Gets and sets the numeric value (Code Page identifier) of the ANSI code page.
old-location: shell\IQueryCodePage.htm
tech.root: shell
ms.assetid: 362a0b69-ca57-4d56-8c14-8f32aa41926c
ms.date: 12/05/2018
ms.keywords: IQueryCodePage, IQueryCodePage interface [Windows Shell], IQueryCodePage interface [Windows Shell],described, _shell_IQueryCodePage, shell.IQueryCodePage, shobjidl/IQueryCodePage
f1_keywords:
- shobjidl/IQueryCodePage
dev_langs:
- c++
req.header: shobjidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shobjidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Shobjidl.h
api_name:
- IQueryCodePage
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IQueryCodePage interface


## -description


Gets and sets the numeric value (Code Page identifier) of the ANSI code page.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IQueryCodePage</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IQueryCodePage</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IQueryCodePage</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl/nf-shobjidl-iquerycodepage-getcodepage">GetCodePage</a>
</td>
<td align="left" width="63%">
Retrieves the numeric value (Code Page identifier) of the ANSI code page.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl/nf-shobjidl-iquerycodepage-setcodepage">SetCodePage</a>
</td>
<td align="left" width="63%">
Sets the numeric value of the ANSI code page to a specified code page identifier.

</td>
</tr>
</table> 

