---
UID: NN:shobjidl.IVisualProperties
title: IVisualProperties (shobjidl.h)
description: Exposes methods that set and get visual properties.
old-location: shell\IVisualProperties.htm
tech.root: shell
ms.assetid: 0f4921ad-18b4-447e-8e4b-0a40ce430137
ms.date: 12/05/2018
ms.keywords: IVisualProperties, IVisualProperties interface [Windows Shell], IVisualProperties interface [Windows Shell],described, _shell_IVisualProperties, shell.IVisualProperties, shobjidl/IVisualProperties
f1_keywords:
- shobjidl/IVisualProperties
dev_langs:
- c++
req.header: shobjidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shobjidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Shobjidl.h
api_name:
- IVisualProperties
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IVisualProperties interface


## -description


Exposes methods that set and get visual properties.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IVisualProperties</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IVisualProperties</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IVisualProperties</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl/nf-shobjidl-ivisualproperties-getcolor">GetColor</a>
</td>
<td align="left" width="63%">
Gets the color, as specified.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl/nf-shobjidl-ivisualproperties-getfont">GetFont</a>
</td>
<td align="left" width="63%">
Gets the current attributes set on the font.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl/nf-shobjidl-ivisualproperties-getitemheight">GetItemHeight</a>
</td>
<td align="left" width="63%">
Gets the item height.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl/nf-shobjidl-ivisualproperties-setcolor">SetColor</a>
</td>
<td align="left" width="63%">
Sets the color, as specified.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl/nf-shobjidl-ivisualproperties-setfont">SetFont</a>
</td>
<td align="left" width="63%">
Sets attributes of the font.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl/nf-shobjidl-ivisualproperties-setitemheight">SetItemHeight</a>
</td>
<td align="left" width="63%">
Sets the specified item height.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl/nf-shobjidl-ivisualproperties-settheme">SetTheme</a>
</td>
<td align="left" width="63%">
Sets the specified theme.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl/nf-shobjidl-ivisualproperties-setwatermark">SetWatermark</a>
</td>
<td align="left" width="63%">
Provides a bitmap to use as a watermark.

</td>
</tr>
</table> 

