---
UID: NE:shobjidl_core.CM_SET_WIDTH_VALUE
title: CM_SET_WIDTH_VALUE (shobjidl_core.h)
description: Specifies width values in pixels and includes special support for default and autosize. Used by members of the IColumnManager interface through the CM_COLUMNINFO structure.
old-location: shell\CM_SET_WIDTH_VALUE.htm
tech.root: shell
ms.assetid: c5778bcc-fc9e-499a-b5e5-31c4f2df4871
ms.date: 12/05/2018
ms.keywords: CM_SET_WIDTH_VALUE, CM_SET_WIDTH_VALUE enumeration [Windows Shell], CM_WIDTH_AUTOSIZE, CM_WIDTH_USEDEFAULT, shell.CM_SET_WIDTH_VALUE, shell_CM_SET_WIDTH_VALUE, shobjidl_core/CM_SET_WIDTH_VALUE, shobjidl_core/CM_WIDTH_AUTOSIZE, shobjidl_core/CM_WIDTH_USEDEFAULT
f1_keywords:
- shobjidl_core/CM_SET_WIDTH_VALUE
dev_langs:
- c++
req.header: shobjidl_core.h
req.include-header: Shobjidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shobjidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- shobjidl_core.h
api_name:
- CM_SET_WIDTH_VALUE
targetos: Windows
req.typenames: CM_SET_WIDTH_VALUE
req.redist: 
ms.custom: 19H1
---

# CM_SET_WIDTH_VALUE enumeration


## -description


Specifies width values in pixels and includes special support for default and autosize. Used by members of the <a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nn-shobjidl_core-icolumnmanager">IColumnManager</a> interface through the <a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/ns-shobjidl_core-cm_columninfo">CM_COLUMNINFO</a> structure.


## -enum-fields




### -field CM_WIDTH_USEDEFAULT

Use the default width.


### -field CM_WIDTH_AUTOSIZE

Use the auto-size width.

