---
UID: NF:shobjidl_core.IApplicationDesignModeSettings.TriggerEdgeGesture
title: IApplicationDesignModeSettings::TriggerEdgeGesture (shobjidl_core.h)
description: Sends a spoofed edge gesture event to the proxy core window on the caller's thread. This gesture toggles the app's app bar, if the app supports one. The caller can specify the type of input that triggered the edge gesture.
old-location: shell\IApplicationDesignModeSettings_TriggerEdgeGesture.htm
tech.root: shell
ms.assetid: 0B74E779-543F-411F-B6BA-44F00C4D70BE
ms.date: 12/05/2018
ms.keywords: EGK_KEYBOARD, EGK_MOUSE, EGK_TOUCH, IApplicationDesignModeSettings interface [Windows Shell],TriggerEdgeGesture method, IApplicationDesignModeSettings.TriggerEdgeGesture, IApplicationDesignModeSettings::TriggerEdgeGesture, TriggerEdgeGesture, TriggerEdgeGesture method [Windows Shell], TriggerEdgeGesture method [Windows Shell],IApplicationDesignModeSettings interface, shell.IApplicationDesignModeSettings_TriggerEdgeGesture, shobjidl_core/IApplicationDesignModeSettings::TriggerEdgeGesture
f1_keywords:
- shobjidl_core/IApplicationDesignModeSettings.TriggerEdgeGesture
dev_langs:
- c++
req.header: shobjidl_core.h
req.include-header: Shobjidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shobjidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Twinapi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Twinapi.dll
api_name:
- IApplicationDesignModeSettings.TriggerEdgeGesture
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IApplicationDesignModeSettings::TriggerEdgeGesture


## -description


Sends a spoofed edge gesture event to the proxy core window on the caller's thread. This gesture toggles the app's app bar, if the app supports one. The caller can specify the type of input that triggered the edge gesture.

You must call <a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-iinitializewithwindow-initialize">IInitializeWithWindow::Initialize</a> to set a proxy core window before calling this method.


## -parameters




### -param edgeGestureKind [in]

Indicates the <b>EDGE_GESTURE_KIND</b> input type that generated the spoofed edge gesture. If touch (<b>EGK_TOUCH</b>) is specified, both the <b>Starting</b> and <b>Completed</b> edge gesture events are sent. Otherwise, only the <b>Completed</b> event is sent. One of the following values:



#### EGK_TOUCH (0)

The edge gesture event was generated by a swipe on a touch-enabled screen.



#### EGK_KEYBOARD (1)

The edge gesture event was generated by the Win+Z key sequence on the keyboard.



#### EGK_MOUSE (2)

The edge gesture event was generated by a right mouse click.


## -returns



If this method succeeds, it returns S_OK. Otherwise, it returns an HRESULT error code, including the following:

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_NOT_SET</b></dt>
</dl>
</td>
<td width="60%">

<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-iinitializewithwindow-initialize">IInitializeWithWindow::Initialize</a> has not been called to set a proxy core window.

</td>
</tr>
</table>
 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nn-shobjidl_core-iapplicationdesignmodesettings">IApplicationDesignModeSettings</a>
 

 

