---
UID: NF:shobjidl_core.ITransferAdviseSink.FileFailure
title: ITransferAdviseSink::FileFailure (shobjidl_core.h)
description: Called when there is a failure and user interaction is needed.
old-location: shell\ITransferAdviseSink_FileFailure.htm
tech.root: shell
ms.assetid: 4adc4e9d-f1d1-438c-bae3-23d1259453a6
ms.date: 12/05/2018
ms.keywords: FileFailure, FileFailure method [Windows Shell], FileFailure method [Windows Shell],ITransferAdviseSink interface, ITransferAdviseSink interface [Windows Shell],FileFailure method, ITransferAdviseSink.FileFailure, ITransferAdviseSink::FileFailure, _shell_ITransferAdviseSink_FileFailure, shell.ITransferAdviseSink_FileFailure, shobjidl_core/ITransferAdviseSink::FileFailure
f1_keywords:
- shobjidl_core/ITransferAdviseSink.FileFailure
dev_langs:
- c++
req.header: shobjidl_core.h
req.include-header: Shobjidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shobjidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- shobjidl_core.h
api_name:
- ITransferAdviseSink.FileFailure
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ITransferAdviseSink::FileFailure


## -description


Called when there is a failure and user interaction is needed.


## -parameters




### -param psi [in]

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nn-shobjidl_core-ishellitem">IShellItem</a>*</b>

The <a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nn-shobjidl_core-ishellitem">IShellItem</a> on which the operation failed.


### -param pszItem [in]

Type: <b>LPCWSTR</b>

Optional. A pointer to a null-terminated buffer that contains the name of the file. If this value is <b>NULL</b>, the name given by the <i>psi</i> parameter is used.


### -param hrError [in]

Type: <b>HRESULT</b>

The error code generated by the failure. This error must be handled by the copy engine.


### -param pszRename [in, out]

Type: <b>LPWSTR</b>

Optional. When this method returns, contains a pointer to a null-terminated buffer that contains a new name for the file. The name cannot exceed length <i>cchRename</i>. If this parameter is <b>NULL</b>, no option to rename will be available.


### -param cchRename [in]

Type: <b>ULONG</b>

The size of the <i>pszRename</i>buffer, in characters.


## -returns



Type: <b>HRESULT</b>

Any other <b>HRESULT</b> should be returned to the calling process. If the failure is not handled, the return value should be <i>hrError</i>.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>COPYENGINE_S_USER_RETRY</b></dt>
</dl>
</td>
<td width="60%">
The user clicked <b>Retry</b>. The handler should retry the file operation.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>COPYENGINE_E_USERCANCELLED</b></dt>
</dl>
</td>
<td width="60%">
The user clicked <b>Cancel</b>. The entire copy job is being terminated. The handler should return this code back to the copy engine.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>COPYENGINE_S_USER_IGNORED</b></dt>
</dl>
</td>
<td width="60%">
The user clicked <b>Ignore</b>. The handler should skip creating the item and return this code back to the copy engine.

</td>
</tr>
</table>
 



