---
UID: NF:shobjidl_core.ITransferAdviseSink.PropertyFailure
title: ITransferAdviseSink::PropertyFailure (shobjidl_core.h)
description: Called when there is a failure that involves file properties and user interaction is needed.
old-location: shell\ITransferAdviseSink_PropertyFailure.htm
tech.root: shell
ms.assetid: c43cb166-6edf-4c45-93c1-16cb9b5c2d30
ms.date: 12/05/2018
ms.keywords: ITransferAdviseSink interface [Windows Shell],PropertyFailure method, ITransferAdviseSink.PropertyFailure, ITransferAdviseSink::PropertyFailure, PropertyFailure, PropertyFailure method [Windows Shell], PropertyFailure method [Windows Shell],ITransferAdviseSink interface, _shell_ITransferAdviseSink_PropertyFailure, shell.ITransferAdviseSink_PropertyFailure, shobjidl_core/ITransferAdviseSink::PropertyFailure
f1_keywords:
- shobjidl_core/ITransferAdviseSink.PropertyFailure
dev_langs:
- c++
req.header: shobjidl_core.h
req.include-header: Shobjidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shobjidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- shobjidl_core.h
api_name:
- ITransferAdviseSink.PropertyFailure
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ITransferAdviseSink::PropertyFailure


## -description


Called when there is a failure that involves file properties and user interaction is needed.


## -parameters




### -param psi [in]

Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nn-shobjidl_core-ishellitem">IShellItem</a>*</b>

A pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nn-shobjidl_core-ishellitem">IShellItem</a> that caused the failure.


### -param pkey [in]

Type: <b>const <a href="https://docs.microsoft.com/windows/desktop/api/wtypes/ns-wtypes-propertykey">PROPERTYKEY</a>*</b>

A value that corresponds to the property that will be lost. A <b>NULL</b> value indicates that all properties were lost.


### -param hrError [in]

Type: <b>HRESULT</b>

The error code generated by the failure. It must be handled by the copy engine.


## -returns



Type: <b>HRESULT</b>

Any other <b>HRESULT</b> should be passed up. If the failure is not handled, the return value should be <i>hrError</i>.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>COPYENGINE_S_USERRETRY</b></dt>
</dl>
</td>
<td width="60%">
The handler should retry the file operation.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>COPYENGINE_S_USERRETRYWITHNEWNAME</b></dt>
</dl>
</td>
<td width="60%">
The handler should retry the file operation using the name returned in the <i>pszRename</i> buffer.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>COPYENGINE_S_OVERWRITE</b></dt>
</dl>
</td>
<td width="60%">
The user has indicated that the handler should overwrite the existing file.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>COPYENGINE_S_RETRYWITHOUTSECURITY</b></dt>
</dl>
</td>
<td width="60%">
The user has indicated that the handler should try the operation again without the security descriptor.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>COPYENGINE_E_USERCANCELLED</b></dt>
</dl>
</td>
<td width="60%">
The user clicked <b>Cancel</b>. The entire copy job is being terminated. The handler should return this code back to the copy engine.

</td>
</tr>
</table>
 



