---
UID: NN:shobjidl_core.IFolderViewSettings
title: IFolderViewSettings (shobjidl_core.h)
description: Exposes methods to obtain folder view settings.
old-location: shell\IFolderViewSettings.htm
tech.root: shell
ms.assetid: 8cb3da64-8f7a-46a6-b00c-e1da1d158b5a
ms.date: 12/05/2018
ms.keywords: IFolderViewSettings, IFolderViewSettings interface [Windows Shell], IFolderViewSettings interface [Windows Shell],described, _shell_IFolderViewSettings, shell.IFolderViewSettings, shobjidl_core/IFolderViewSettings
f1_keywords:
- shobjidl_core/IFolderViewSettings
dev_langs:
- c++
req.header: shobjidl_core.h
req.include-header: Shobjidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shobjidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- shobjidl_core.h
api_name:
- IFolderViewSettings
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IFolderViewSettings interface


## -description


Exposes methods to obtain folder view settings.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IFolderViewSettings</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IFolderViewSettings</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IFolderViewSettings</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ifolderviewsettings-getcolumnpropertylist">GetColumnPropertyList</a>
</td>
<td align="left" width="63%">
Gets an ordered list of columns that corresponds to the column enumerated.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ifolderviewsettings-getfolderflags">GetFolderFlags</a>
</td>
<td align="left" width="63%">
Gets folder view options flags.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ifolderviewsettings-getgroupbyproperty">GetGroupByProperty</a>
</td>
<td align="left" width="63%">
Gets a grouping property.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ifolderviewsettings-getgroupsubsetcount">GetGroupSubsetCount</a>
</td>
<td align="left" width="63%">
Gets group count for visible rows.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ifolderviewsettings-geticonsize">GetIconSize</a>
</td>
<td align="left" width="63%">
Gets the folder icon size.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ifolderviewsettings-getsortcolumns">GetSortColumns</a>
</td>
<td align="left" width="63%">
Gets sort column information.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ifolderviewsettings-getviewmode">GetViewMode</a>
</td>
<td align="left" width="63%">
Gets a folder's logical view mode.

</td>
</tr>
</table> 

