---
UID: NN:shobjidl_core.ILaunchSourceViewSizePreference
title: ILaunchSourceViewSizePreference (shobjidl_core.h)
description: Provides methods for retrieving information about the source application.
old-location: shell\ILaunchSourceViewSizePreference.htm
tech.root: shell
ms.assetid: 94436BC1-658E-4D33-866D-9C05282291A8
ms.date: 12/05/2018
ms.keywords: ILaunchSourceViewSizePreference, ILaunchSourceViewSizePreference interface [Windows Shell], ILaunchSourceViewSizePreference interface [Windows Shell],described, shell.ILaunchSourceViewSizePreference, shobjidl_core/ILaunchSourceViewSizePreference
f1_keywords:
- shobjidl_core/ILaunchSourceViewSizePreference
dev_langs:
- c++
req.header: shobjidl_core.h
req.include-header: Shobjidl.h
req.target-type: Windows
req.target-min-winverclnt: Windows 8.1 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shobjidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- shobjidl_core.h
api_name:
- ILaunchSourceViewSizePreference
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# ILaunchSourceViewSizePreference interface


## -description


Provides methods for retrieving information about the source application.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">ILaunchSourceViewSizePreference</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>ILaunchSourceViewSizePreference</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>ILaunchSourceViewSizePreference</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ilaunchsourceviewsizepreference-getsourceviewsizepreference">GetSourceViewSizePreference</a>
</td>
<td align="left" width="63%">
Retrieves the view size preference of the application after the application has launched.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ilaunchsourceviewsizepreference-getsourceviewtoposition">GetSourceViewToPosition</a>
</td>
<td align="left" width="63%">
Retrieves the position of the source application window.

</td>
</tr>
</table> 


## -remarks



<h3><a id="When_to_implement"></a><a id="when_to_implement"></a><a id="WHEN_TO_IMPLEMENT"></a>When to implement</h3>
--&gt;




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nn-shobjidl_core-ilaunchtargetviewsizepreference">ILaunchTargetViewSizePreference</a>



<a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a>
 

 

