---
UID: NN:shobjidl_core.IShellLinkW
title: IShellLinkW (shobjidl_core.h)
description: Exposes methods that create, modify, and resolve Shell links.
old-location: shell\IShellLink.htm
tech.root: shell
ms.assetid: 67982d28-27ce-4482-b588-10fec8143750
ms.date: 12/05/2018
ms.keywords: IShellLink, IShellLink interface [Windows Shell], IShellLink interface [Windows Shell],described, IShellLinkA, IShellLinkW, _win32_IShellLink, _win32_IShellLink_cpp, shell.IShellLink, shobjidl_core/IShellLink
f1_keywords:
- shobjidl_core/IShellLink
dev_langs:
- c++
req.header: shobjidl_core.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shobjidl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Shell32.dll (version 4.0 or later)
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Shell32.dll
api_name:
- IShellLink
- IShellLinkW
- IShellLinkA
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IShellLinkW interface


## -description


Exposes methods that create, modify, and resolve Shell links.


## -inheritance

The <b xmlns:loc="http://microsoft.com/wdcml/l10n">IShellLink</b> interface inherits from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface. <b>IShellLink</b> also has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul>

## -members

The <b>IShellLink</b> interface has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getarguments">GetArguments</a>
</td>
<td align="left" width="63%">
Gets the command-line arguments associated with a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getarguments">GetArguments</a>
</td>
<td align="left" width="63%">
Gets the command-line arguments associated with a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getarguments">GetArguments</a>
</td>
<td align="left" width="63%">
Gets the command-line arguments associated with a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getdescription">GetDescription</a>
</td>
<td align="left" width="63%">
Gets the description string for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getdescription">GetDescription</a>
</td>
<td align="left" width="63%">
Gets the description string for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getdescription">GetDescription</a>
</td>
<td align="left" width="63%">
Gets the description string for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-gethotkey">GetHotkey</a>
</td>
<td align="left" width="63%">
Gets the keyboard shortcut (hot key) for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-gethotkey">GetHotkey</a>
</td>
<td align="left" width="63%">
Gets the keyboard shortcut (hot key) for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-gethotkey">GetHotkey</a>
</td>
<td align="left" width="63%">
Gets the keyboard shortcut (hot key) for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-geticonlocation">GetIconLocation</a>
</td>
<td align="left" width="63%">
Gets the location (path and index) of the icon for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-geticonlocation">GetIconLocation</a>
</td>
<td align="left" width="63%">
Gets the location (path and index) of the icon for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-geticonlocation">GetIconLocation</a>
</td>
<td align="left" width="63%">
Gets the location (path and index) of the icon for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getidlist">GetIDList</a>
</td>
<td align="left" width="63%">
Gets the list of item identifiers for the target of a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getidlist">GetIDList</a>
</td>
<td align="left" width="63%">
Gets the list of item identifiers for the target of a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getidlist">GetIDList</a>
</td>
<td align="left" width="63%">
Gets the list of item identifiers for the target of a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getpath">GetPath</a>
</td>
<td align="left" width="63%">
Gets the path and file name of the target of a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getpath">GetPath</a>
</td>
<td align="left" width="63%">
Gets the path and file name of the target of a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getpath">GetPath</a>
</td>
<td align="left" width="63%">
Gets the path and file name of the target of a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getshowcmd">GetShowCmd</a>
</td>
<td align="left" width="63%">
Gets the show command for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getshowcmd">GetShowCmd</a>
</td>
<td align="left" width="63%">
Gets the show command for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getshowcmd">GetShowCmd</a>
</td>
<td align="left" width="63%">
Gets the show command for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getworkingdirectory">GetWorkingDirectory</a>
</td>
<td align="left" width="63%">
Gets the name of the working directory for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getworkingdirectory">GetWorkingDirectory</a>
</td>
<td align="left" width="63%">
Gets the name of the working directory for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-getworkingdirectory">GetWorkingDirectory</a>
</td>
<td align="left" width="63%">
Gets the name of the working directory for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-resolve">Resolve</a>
</td>
<td align="left" width="63%">
Attempts to find the target of a Shell link, even if it has been moved or renamed.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-resolve">Resolve</a>
</td>
<td align="left" width="63%">
Attempts to find the target of a Shell link, even if it has been moved or renamed.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-resolve">Resolve</a>
</td>
<td align="left" width="63%">
Attempts to find the target of a Shell link, even if it has been moved or renamed.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setarguments">SetArguments</a>
</td>
<td align="left" width="63%">
Sets the command-line arguments for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setarguments">SetArguments</a>
</td>
<td align="left" width="63%">
Sets the command-line arguments for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setarguments">SetArguments</a>
</td>
<td align="left" width="63%">
Sets the command-line arguments for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setdescription">SetDescription</a>
</td>
<td align="left" width="63%">
Sets the description for a Shell link object. The description can be any application-defined string.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setdescription">SetDescription</a>
</td>
<td align="left" width="63%">
Sets the description for a Shell link object. The description can be any application-defined string.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setdescription">SetDescription</a>
</td>
<td align="left" width="63%">
Sets the description for a Shell link object. The description can be any application-defined string.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-sethotkey">SetHotkey</a>
</td>
<td align="left" width="63%">
Sets a keyboard shortcut (hot key) for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-sethotkey">SetHotkey</a>
</td>
<td align="left" width="63%">
Sets a keyboard shortcut (hot key) for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-sethotkey">SetHotkey</a>
</td>
<td align="left" width="63%">
Sets a keyboard shortcut (hot key) for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-seticonlocation">SetIconLocation</a>
</td>
<td align="left" width="63%">
Sets the location (path and index) of the icon for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-seticonlocation">SetIconLocation</a>
</td>
<td align="left" width="63%">
Sets the location (path and index) of the icon for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-seticonlocation">SetIconLocation</a>
</td>
<td align="left" width="63%">
Sets the location (path and index) of the icon for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setidlist">SetIDList</a>
</td>
<td align="left" width="63%">
Sets the PIDL for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setidlist">SetIDList</a>
</td>
<td align="left" width="63%">
Sets the PIDL for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setidlist">SetIDList</a>
</td>
<td align="left" width="63%">
Sets the PIDL for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setpath">SetPath</a>
</td>
<td align="left" width="63%">
Sets the path and file name for the target of a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setpath">SetPath</a>
</td>
<td align="left" width="63%">
Sets the path and file name for the target of a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setpath">SetPath</a>
</td>
<td align="left" width="63%">
Sets the path and file name for the target of a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setrelativepath">SetRelativePath</a>
</td>
<td align="left" width="63%">
Sets the relative path to the Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setrelativepath">SetRelativePath</a>
</td>
<td align="left" width="63%">
Sets the relative path to the Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setrelativepath">SetRelativePath</a>
</td>
<td align="left" width="63%">
Sets the relative path to the Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setshowcmd">SetShowCmd</a>
</td>
<td align="left" width="63%">
Sets the show command for a Shell link object. The show command sets the initial show state of the window.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setshowcmd">SetShowCmd</a>
</td>
<td align="left" width="63%">
Sets the show command for a Shell link object. The show command sets the initial show state of the window.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setshowcmd">SetShowCmd</a>
</td>
<td align="left" width="63%">
Sets the show command for a Shell link object. The show command sets the initial show state of the window.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setworkingdirectory">SetWorkingDirectory</a>
</td>
<td align="left" width="63%">
Sets the name of the working directory for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setworkingdirectory">SetWorkingDirectory</a>
</td>
<td align="left" width="63%">
Sets the name of the working directory for a Shell link object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-ishelllinka-setworkingdirectory">SetWorkingDirectory</a>
</td>
<td align="left" width="63%">
Sets the name of the working directory for a Shell link object.

</td>
</tr>
</table> 


## -remarks



<div class="alert"><b>Note</b>  This interface cannot be used to create a link to a URL.</div>
<div> </div>
The <b>IShellLink</b> interface has an ANSI version (<b>IShellLinkA</b>) and a Unicode version (<b>IShellLinkW</b>). The version that will be used depends on whether you compile for ANSI or Unicode.



