---
UID: NE:shtypes.DEVICE_SCALE_FACTOR
title: DEVICE_SCALE_FACTOR (shtypes.h)
description: Indicates a spoofed device scale factor, as a percent. Used by IApplicationDesignModeSettings::SetApplicationViewState and IApplicationDesignModeSettings::IsApplicationViewStateSupported.
old-location: shell\DEVICE_SCALE_FACTOR.htm
tech.root: shell
ms.assetid: DB42E7D5-4E42-4b78-89F8-0B76320E2C5F
ms.date: 12/05/2018
ms.keywords: DEVICE_SCALE_FACTOR, DEVICE_SCALE_FACTOR enumeration [Windows Shell], SCALE_100_PERCENT, SCALE_120_PERCENT, SCALE_140_PERCENT, SCALE_150_PERCENT, SCALE_160_PERCENT, SCALE_180_PERCENT, SCALE_225_PERCENT, shell.DEVICE_SCALE_FACTOR, shtypes/DEVICE_SCALE_FACTOR, shtypes/SCALE_100_PERCENT, shtypes/SCALE_120_PERCENT, shtypes/SCALE_140_PERCENT, shtypes/SCALE_150_PERCENT, shtypes/SCALE_160_PERCENT, shtypes/SCALE_180_PERCENT, shtypes/SCALE_225_PERCENT
f1_keywords:
- shtypes/DEVICE_SCALE_FACTOR
dev_langs:
- c++
req.header: shtypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Shtypes.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Shtypes.h
api_name:
- DEVICE_SCALE_FACTOR
targetos: Windows
req.typenames: DEVICE_SCALE_FACTOR
req.redist: 
ms.custom: 19H1
---

# DEVICE_SCALE_FACTOR enumeration


## -description


Indicates a spoofed device scale factor, as a percent. Used by <a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-iapplicationdesignmodesettings-setapplicationviewstate">IApplicationDesignModeSettings::SetApplicationViewState</a> and <a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-iapplicationdesignmodesettings-isapplicationviewstatesupported">IApplicationDesignModeSettings::IsApplicationViewStateSupported</a>



## -enum-fields




### -field DEVICE_SCALE_FACTOR_INVALID


### -field SCALE_100_PERCENT

100%. The scale factor for the device is 1x.


### -field SCALE_120_PERCENT

120%. The scale factor for the device is 1.2x.


### -field SCALE_125_PERCENT


### -field SCALE_140_PERCENT

140%. The scale factor for the device is 1.4x.


### -field SCALE_150_PERCENT

150%. The scale factor for the device is 1.5x.


### -field SCALE_160_PERCENT

160%. The scale factor for the device is 1.6x.


### -field SCALE_175_PERCENT


### -field SCALE_180_PERCENT

180%. The scale factor for the device is 1.8x.


### -field SCALE_200_PERCENT


### -field SCALE_225_PERCENT

225%. The scale factor for the device is 2.25x.


### -field SCALE_250_PERCENT


### -field SCALE_300_PERCENT


### -field SCALE_350_PERCENT


### -field SCALE_400_PERCENT


### -field SCALE_450_PERCENT


### -field SCALE_500_PERCENT




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-iapplicationdesignmodesettings-isapplicationviewstatesupported">IApplicationDesignModeSettings::IsApplicationViewStateSupported</a>



<a href="https://docs.microsoft.com/windows/desktop/api/shobjidl_core/nf-shobjidl_core-iapplicationdesignmodesettings-setapplicationviewstate">IApplicationDesignModeSettings::SetApplicationViewState</a>
 

 

