---
UID: NE:slpublic._tagSL_ACTIVATION_TYPE
title: SL_ACTIVATION_TYPE (slpublic.h)
description: Represents the type of offline activation for a license.
old-location: security\sl_activation_type.htm
tech.root: SecSLApi
ms.assetid: e16a4e43-f7ef-43a3-a268-5f644340274c
ms.date: 12/05/2018
ms.keywords: SL_ACTIVATION_TYPE, SL_ACTIVATION_TYPE enumeration [Security], SL_ACTIVATION_TYPE_ACTIVE_DIRECTORY, SL_ACTIVATION_TYPE_DEFAULT, security.sl_activation_type, slpublic/SL_ACTIVATION_TYPE, slpublic/SL_ACTIVATION_TYPE_ACTIVE_DIRECTORY, slpublic/SL_ACTIVATION_TYPE_DEFAULT
f1_keywords:
- slpublic/SL_ACTIVATION_TYPE
dev_langs:
- c++
req.header: slpublic.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- slpublic.h
api_name:
- SL_ACTIVATION_TYPE
targetos: Windows
req.typenames: SL_ACTIVATION_TYPE
req.redist: 
ms.custom: 19H1
---

# SL_ACTIVATION_TYPE enumeration


## -description


Represents the type of offline activation for a license. This 	enumeration is used by the <b>type</b> member of the <a href="https://docs.microsoft.com/windows/desktop/api/slpublic/ns-slpublic-sl_activation_info_header">SL_ACTIVATION_INFO_HEADER</a> structure.


## -enum-fields




### -field SL_ACTIVATION_TYPE_DEFAULT

Retail phone activation.


### -field SL_ACTIVATION_TYPE_ACTIVE_DIRECTORY

The product activation is through Active Directory.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/slpublic/ns-slpublic-sl_activation_info_header">SL_ACTIVATION_INFO_HEADER</a>
 

 

