---
UID: NF:slpublic.SLDepositOfflineConfirmationIdEx
title: SLDepositOfflineConfirmationIdEx function (slpublic.h)
description: Deposits Installation ID (IID) and Confirmation ID (CID) for offline activation.
old-location: security\sldepositofflineconfirmationidex.htm
tech.root: SecSLApi
ms.assetid: 22817dc4-5d06-41bd-980d-b4402f74b82b
ms.date: 12/05/2018
ms.keywords: SLDepositOfflineConfirmationIdEx, SLDepositOfflineConfirmationIdEx function [Security], security.sldepositofflineconfirmationidex, slpublic/SLDepositOfflineConfirmationIdEx
f1_keywords:
- slpublic/SLDepositOfflineConfirmationIdEx
dev_langs:
- c++
req.header: slpublic.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Slc.lib
req.dll: Slc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Slc.dll
api_name:
- SLDepositOfflineConfirmationIdEx
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# SLDepositOfflineConfirmationIdEx function


## -description


Deposits Installation ID (IID) and Confirmation ID (CID) for offline activation.


## -parameters




### -param hSLC [in]

Type: <b>HSLC</b>

The handle to the current SLC context.


### -param pProductSkuId [in, optional]

Type: <b>const SLID*</b>

A pointer to the product ID.


### -param pActivationInfo [in, optional]

Type: <b>const <a href="https://docs.microsoft.com/windows/desktop/api/slpublic/ns-slpublic-sl_activation_info_header">SL_ACTIVATION_INFO_HEADER</a>*</b>

A pointer to additional information.


### -param pwszInstallationId [in]

Type: <b>PCWSTR</b>

The Installation ID generated by the <a href="https://docs.microsoft.com/windows/desktop/api/slpublic/nf-slpublic-slgenerateofflineinstallationid">SLGenerateOfflineInstallationId</a> function.


### -param pwszConfirmationId [in]

Type: <b>PCWSTR</b>

The Confirmation ID CSR.


## -returns



Type: <b>HRESULT WINAPI</b>

If this function succeeds, it return <b>S_OK</b>.  Otherwise,  it returns an <b>HRESULT</b> error code.

<table>
<tr>
<th>Return code/value</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
<dt>0x80070057</dt>
</dl>
</td>
<td width="60%">
One or more arguments are not valid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SL_E_CIDIID_INVALID_CHECK_DIGITS</b></dt>
<dt>0xC004F04D</dt>
</dl>
</td>
<td width="60%">
The Installation ID (IID) or the Confirmation ID (CID) is not valid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SL_E_PRODUCT_SKU_NOT_INSTALLED</b></dt>
<dt>0xC004F015</dt>
</dl>
</td>
<td width="60%">
The license is not installed.

</td>
</tr>
</table>
 



