---
UID: NE:spatialaudiohrtf.SpatialAudioHrtfEnvironmentType
title: SpatialAudioHrtfEnvironmentType (spatialaudiohrtf.h)
description: Specifies the type of acoustic environment that is simulated when audio is processed for an ISpatialAudioObjectForHrtf.
old-location: coreaudio\spatialaudiohrtfenvironmenttype.htm
tech.root: CoreAudio
ms.assetid: 017FC8D4-2B74-4B13-AF5B-D7FFF97A7E45
ms.date: 12/05/2018
ms.keywords: SpatialAudioHrtfEnvironmentType, SpatialAudioHrtfEnvironmentType enumeration [Core Audio], SpatialAudioHrtfEnvironment_Average, SpatialAudioHrtfEnvironment_Large, SpatialAudioHrtfEnvironment_Medium, SpatialAudioHrtfEnvironment_Outdoors, SpatialAudioHrtfEnvironment_Small, coreaudio.spatialaudiohrtfenvironmenttype, spatialaudiohrtf/SpatialAudioHrtfEnvironmentType, spatialaudiohrtf/SpatialAudioHrtfEnvironment_Average, spatialaudiohrtf/SpatialAudioHrtfEnvironment_Large, spatialaudiohrtf/SpatialAudioHrtfEnvironment_Medium, spatialaudiohrtf/SpatialAudioHrtfEnvironment_Outdoors, spatialaudiohrtf/SpatialAudioHrtfEnvironment_Small
f1_keywords:
- spatialaudiohrtf/SpatialAudioHrtfEnvironmentType
dev_langs:
- c++
req.header: spatialaudiohrtf.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- spatialaudiohrtf.h
api_name:
- SpatialAudioHrtfEnvironmentType
targetos: Windows
req.typenames: SpatialAudioHrtfEnvironmentType
req.redist: 
ms.custom: 19H1
---

# SpatialAudioHrtfEnvironmentType enumeration


## -description


Specifies the type of acoustic environment that is simulated when audio is processed for an <a href="https://docs.microsoft.com/windows/desktop/api/spatialaudiohrtf/nn-spatialaudiohrtf-ispatialaudioobjectforhrtf">ISpatialAudioObjectForHrtf</a>.


## -enum-fields




### -field SpatialAudioHrtfEnvironment_Small

A small room.


### -field SpatialAudioHrtfEnvironment_Medium

A medium-sized room.


### -field SpatialAudioHrtfEnvironment_Large

A large room.


### -field SpatialAudioHrtfEnvironment_Outdoors

An outdoor space.


### -field SpatialAudioHrtfEnvironment_Average

Reserved for Microsoft use. Apps should not use this value.

