---
UID: NF:sspi.AcceptSecurityContext
title: AcceptSecurityContext function (sspi.h)
description: Lets the server component of a transport application establish a security context between the server and a remote client.
old-location: security\acceptsecuritycontext__credssp_.htm
tech.root: SecAuthN
ms.assetid: a53f733e-b646-4431-b021-a2c446308849
ms.date: 12/05/2018
ms.keywords: ASC_REQ_ALLOCATE_MEMORY, ASC_REQ_CONNECTION, ASC_REQ_DELEGATE, ASC_REQ_EXTENDED_ERROR, ASC_REQ_REPLAY_DETECT, ASC_REQ_SEQUENCE_DETECT, ASC_REQ_STREAM, AcceptSecurityContext, AcceptSecurityContext (CredSSP), AcceptSecurityContext function [Security], security.acceptsecuritycontext__credssp_, sspi/AcceptSecurityContext
f1_keywords:
- sspi/AcceptSecurityContext
dev_langs:
- c++
req.header: sspi.h
req.include-header: Security.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Secur32.lib
req.dll: Secur32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Secur32.dll
api_name:
- AcceptSecurityContext
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# AcceptSecurityContext function


## -description


The <b>AcceptSecurityContext (CredSSP)</b> function lets the server component of a transport application establish a <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">security context</a> between the server and a remote client. The remote client calls the 
<a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-initializesecuritycontexta">InitializeSecurityContext (CredSSP)</a> function to start the process of establishing a security context. The server can require one or more reply tokens from the remote client to complete establishing the security context.


## -parameters




### -param phCredential [in, optional]

A handle to the server credentials. To retrieve this handle, the server calls the 
<a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-acquirecredentialshandlea">AcquireCredentialsHandle (CredSSP)</a> function with either the SECPKG_CRED_INBOUND or SECPKG_CRED_BOTH flag set.


### -param phContext [in, optional]

A pointer to a 
<a href="https://docs.microsoft.com/windows/desktop/SecAuthN/sspi-handles">CtxtHandle</a> structure. On the first call to <b>AcceptSecurityContext (CredSSP)</b>, this pointer is <b>NULL</b>. On subsequent calls, <i>phContext</i> specifies the partially formed context returned in the <i>phNewContext</i> parameter by the first call.


### -param pInput [in, optional]

A pointer to a 
<a href="https://docs.microsoft.com/windows/desktop/api/sspi/ns-sspi-secbufferdesc">SecBufferDesc</a> structure generated by a client call to 
<a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-initializesecuritycontexta">InitializeSecurityContext (CredSSP)</a>. The structure contains the input buffer descriptor.

The first buffer must be of type <b>SECBUFFER_TOKEN</b> and contain the security token received from the client. The second buffer should be of type <b>SECBUFFER_EMPTY</b>.


### -param fContextReq [in]

-Bit flags that specify the attributes required by the server to establish the context. Bit flags can be combined by using bitwise-<b>OR</b> operations. This parameter can be one or more of the following values.

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="ASC_REQ_ALLOCATE_MEMORY"></a><a id="asc_req_allocate_memory"></a><dl>
<dt><b>ASC_REQ_ALLOCATE_MEMORY</b></dt>
</dl>
</td>
<td width="60%">
Credential Security Support Provider (CredSSP) will allocate output buffers. When you have finished using the output buffers, free them  by calling the <a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-freecontextbuffer">FreeContextBuffer</a> function.

</td>
</tr>
<tr>
<td width="40%"><a id="ASC_REQ_CONNECTION"></a><a id="asc_req_connection"></a><dl>
<dt><b>ASC_REQ_CONNECTION</b></dt>
</dl>
</td>
<td width="60%">
The security context will not handle formatting messages.

</td>
</tr>
<tr>
<td width="40%"><a id="ASC_REQ_DELEGATE"></a><a id="asc_req_delegate"></a><dl>
<dt><b>ASC_REQ_DELEGATE</b></dt>
</dl>
</td>
<td width="60%">
The server is allowed to impersonate the client.  Ignore this flag for <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">constrained delegation</a>.

</td>
</tr>
<tr>
<td width="40%"><a id="ASC_REQ_EXTENDED_ERROR"></a><a id="asc_req_extended_error"></a><dl>
<dt><b>ASC_REQ_EXTENDED_ERROR</b></dt>
</dl>
</td>
<td width="60%">
When errors occur, the remote party will be notified.

</td>
</tr>
<tr>
<td width="40%"><a id="ASC_REQ_REPLAY_DETECT"></a><a id="asc_req_replay_detect"></a><dl>
<dt><b>ASC_REQ_REPLAY_DETECT</b></dt>
</dl>
</td>
<td width="60%">
Detect replayed packets.

</td>
</tr>
<tr>
<td width="40%"><a id="ASC_REQ_SEQUENCE_DETECT"></a><a id="asc_req_sequence_detect"></a><dl>
<dt><b>ASC_REQ_SEQUENCE_DETECT</b></dt>
</dl>
</td>
<td width="60%">
Detect messages received out of sequence.

</td>
</tr>
<tr>
<td width="40%"><a id="ASC_REQ_STREAM"></a><a id="asc_req_stream"></a><dl>
<dt><b>ASC_REQ_STREAM</b></dt>
</dl>
</td>
<td width="60%">
Support a stream-oriented connection.

</td>
</tr>
</table>
 

 For possible attribute flags and their meanings, see 
<a href="https://docs.microsoft.com/windows/desktop/SecAuthN/context-requirements">Context Requirements</a>. Flags used for this parameter are prefixed with ASC_REQ, for example, ASC_REQ_DELEGATE.

The requested attributes may not be supported by the client. For more information, see the <i>pfContextAttr</i> parameter.


### -param TargetDataRep [in]

The data representation, such as byte ordering, on the target. This parameter can be either <b>SECURITY_NATIVE_DREP</b> or <b>SECURITY_NETWORK_DREP</b>.


### -param phNewContext [in, out, optional]

A pointer to a <a href="https://docs.microsoft.com/windows/desktop/SecAuthN/sspi-handles">CtxtHandle</a> structure. On the first call to <b>AcceptSecurityContext (CredSSP)</b>, this pointer receives the new context handle. On subsequent calls, <i>phNewContext</i> can be the same as the handle specified in the <i>phContext</i> parameter.


### -param pOutput [in, out, optional]

A pointer to a 
<a href="https://docs.microsoft.com/windows/desktop/api/sspi/ns-sspi-secbufferdesc">SecBufferDesc</a> structure that contains the output buffer descriptor. This buffer is sent to the client for input into additional calls to <a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-initializesecuritycontexta">InitializeSecurityContext (CredSSP)</a>. An output buffer may be generated even if the function returns SEC_E_OK. Any buffer generated must be sent back to the client application.

On output, this buffer receives a token for the security context. The token must be sent to the client. The function can also return a buffer of type SECBUFFER_EXTRA.


### -param pfContextAttr [out]

A pointer to a set of bit flags that indicate the attributes of the established context. For a description of the various attributes, see 
<a href="https://docs.microsoft.com/windows/desktop/SecAuthN/context-requirements">Context Requirements</a>. Flags used for this parameter are prefixed with ASC_RET, for example, ASC_RET_DELEGATE.

Do not check for security-related attributes until the final function call returns successfully. Attribute flags not related to security, such as the ASC_RET_ALLOCATED_MEMORY flag, can be checked before the final return.


### -param ptsExpiry [out, optional]

A pointer to a <a href="https://docs.microsoft.com/windows/desktop/SecAuthN/timestamp">TimeStamp</a> structure that receives the expiration time of the context. We recommend that the <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">security package</a> always return this value in local time.

<div class="alert"><b>Note</b>  Until the last call of the authentication process, the expiration time for the context can be incorrect because more information will be provided during later stages of the negotiation. Therefore, <i>ptsTimeStamp</i> must be <b>NULL</b> until the last call to the function.</div>
<div> </div>

## -returns



This function returns one of the following values.

<table>
<tr>
<th>Return code/value</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_INCOMPLETE_MESSAGE</b></dt>
<dt>0x80090318L</dt>
</dl>
</td>
<td width="60%">
The function succeeded. The data in the input buffer is incomplete. The application must read additional data from the client and call <a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-acceptsecuritycontext">AcceptSecurityContext (CredSSP)</a> again.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_INSUFFICIENT_MEMORY</b></dt>
<dt>0x80090300L</dt>
</dl>
</td>
<td width="60%">
The function failed. There is not enough memory available to complete the requested action.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_INTERNAL_ERROR</b></dt>
<dt>0x80090304L</dt>
</dl>
</td>
<td width="60%">
The function failed. An error occurred that did not map to an SSPI error code.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_INVALID_HANDLE</b></dt>
<dt>0x80100003L</dt>
</dl>
</td>
<td width="60%">
The function failed. The handle passed to the function is not valid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_INVALID_TOKEN</b></dt>
<dt>0x80090308L</dt>
</dl>
</td>
<td width="60%">
The function failed. The token passed to the function is not valid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_LOGON_DENIED</b></dt>
<dt>0x8009030CL</dt>
</dl>
</td>
<td width="60%">
The logon failed.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_NO_AUTHENTICATING_AUTHORITY</b></dt>
<dt>0x80090311L</dt>
</dl>
</td>
<td width="60%">
The function failed. No authority could be contacted for authentication. This could be due to the following conditions:

<ul>
<li>The domain name of the authenticating party is incorrect.</li>
<li>The domain is unavailable.</li>
<li>The trust relationship has failed.</li>
</ul>
</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_NO_CREDENTIALS</b></dt>
<dt>0x8009030EL</dt>
</dl>
</td>
<td width="60%">
The function failed. The <a href="https://docs.microsoft.com/windows/desktop/SecGloss/c-gly">credentials</a> handle specified in the <i>phCredential</i> parameter is not valid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_OK</b></dt>
<dt>0x00000000L</dt>
</dl>
</td>
<td width="60%">
The function succeeded. The security context received from the client was accepted. If the function generated an output token, the token must be sent to the client process.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_UNSUPPORTED_FUNCTION</b></dt>
<dt>0x80090302L</dt>
</dl>
</td>
<td width="60%">
The function failed. The <i>fContextReq</i> parameter specified a context attribute flag (ASC_REQ_DELEGATE or ASC_REQ_PROMPT_FOR_CREDS) that was not valid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_I_COMPLETE_AND_CONTINUE</b></dt>
<dt>0x00090314L</dt>
</dl>
</td>
<td width="60%">
The function succeeded. The server must call 
<a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-completeauthtoken">CompleteAuthToken</a> and pass the output token to the client. The server must then wait for a return token from the client before making another call to <a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-acceptsecuritycontext">AcceptSecurityContext (CredSSP)</a>.
							

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_I_COMPLETE_NEEDED</b></dt>
<dt>0x00090313L</dt>
</dl>
</td>
<td width="60%">
The function succeeded. The server must finish building the message from the client before calling <a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-completeauthtoken">CompleteAuthToken</a>.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_I_CONTINUE_NEEDED</b></dt>
<dt>0x00090312L</dt>
</dl>
</td>
<td width="60%">
The function succeeded. The server must send the output token to the client and wait for a returned token. The returned token should be passed in <i>pInput</i> for another call to <a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-acceptsecuritycontext">AcceptSecurityContext (CredSSP)</a>.

</td>
</tr>
</table>
 




## -remarks



The <b>AcceptSecurityContext (CredSSP)</b> function is the server counterpart to the 
<a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-initializesecuritycontexta">InitializeSecurityContext (CredSSP)</a> function.

When the server receives a request from a client, it uses the <i>fContextReq</i> parameter to specify what it requires of the session. In this fashion, a server can require that clients be capable of using a confidential or <a href="https://docs.microsoft.com/windows/desktop/SecGloss/i-gly">integrity</a>-checked session; it can reject clients that cannot meet that demand. Alternatively, a server can require nothing; whatever the client requires or can provide is returned in the <i>pfContextAttr</i> parameter.

The <i>fContextReq</i> and <i>pfContextAttr</i> parameters are bitmasks that represent various context attributes. For a description of the various attributes, see 
<a href="https://docs.microsoft.com/windows/desktop/SecAuthN/context-requirements">Context Requirements</a>.

<div class="alert"><b>Note</b>  While the <i>pfContextAttr</i> parameter is valid on any successful return, you should examine the flags pertaining to security aspects of the context only on the final successful return. Intermediate returns can set, for example, the ISC_RET_ALLOCATED_MEMORY flag.</div>
<div> </div>
The caller is responsible for determining whether the final context attributes are sufficient. For example, if confidentiality (encryption) was requested but could not be established, some applications may choose to shut down the connection immediately. If the security context cannot be established, the server must free the partially created context by calling the <a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-deletesecuritycontext">DeleteSecurityContext</a> function. For information about when to call the <b>DeleteSecurityContext</b> function, see <b>DeleteSecurityContext</b>.\

After the security context has been established, the server application can use the <a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-querysecuritycontexttoken">QuerySecurityContextToken</a> function to retrieve a handle to the user account to which the client certificate was mapped. Also, the server can use the <a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-impersonatesecuritycontext">ImpersonateSecurityContext</a> function to impersonate the user.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-deletesecuritycontext">DeleteSecurityContext</a>



<a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-initializesecuritycontexta">InitializeSecurityContext (CredSSP)</a>



<a href="https://docs.microsoft.com/windows/desktop/SecAuthN/authentication-functions">SSPI Functions</a>
 

 

