---
UID: NF:sspi.SaslGetProfilePackageW
title: SaslGetProfilePackageW function (sspi.h)
description: Returns the package information for the specified package.
old-location: security\saslgetprofilepackage.htm
tech.root: SecAuthN
ms.assetid: b7cecc5f-775f-40ba-abfc-27d51b3f5395
ms.date: 12/05/2018
ms.keywords: SaslGetProfilePackage, SaslGetProfilePackage function [Security], SaslGetProfilePackageA, SaslGetProfilePackageW, security.saslgetprofilepackage, sspi/SaslGetProfilePackage, sspi/SaslGetProfilePackageA, sspi/SaslGetProfilePackageW
f1_keywords:
- sspi/SaslGetProfilePackage
dev_langs:
- c++
req.header: sspi.h
req.include-header: Security.h
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: SaslGetProfilePackageW (Unicode) and SaslGetProfilePackageA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Secur32.lib
req.dll: Secur32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Secur32.dll
api_name:
- SaslGetProfilePackage
- SaslGetProfilePackageA
- SaslGetProfilePackageW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# SaslGetProfilePackageW function


## -description


The <b>SaslGetProfilePackage</b> function returns the package information for the specified package.


## -parameters




### -param ProfileName [in]

Unicode or ANSI string that contains the name of the SASL package.


### -param PackageInfo [out]

Pointer to a pointer to a <a href="https://docs.microsoft.com/windows/desktop/api/sspi/ns-sspi-secpkginfoa">SecPkgInfo</a> structure that returns the package information for the package specified by the <i>ProfileName</i> parameter.


## -returns



If the call is completed successfully, this function returns SEC_E_OK. The following table shows some possible failure return values.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_SECPKG_NOT_FOUND</b></dt>
</dl>
</td>
<td width="60%">
The SASL profile specified by the <i>ProfileName</i> parameter could not be found.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>SEC_E_INSUFFICIENT_MEMORY</b></dt>
</dl>
</td>
<td width="60%">
Memory could not be allocated for the <a href="https://docs.microsoft.com/windows/desktop/api/sspi/ns-sspi-secpkginfoa">SecPkgInfo</a> structure.

</td>
</tr>
</table>
 



