---
UID: NE:strmif.tagAnalogVideoStandard
title: AnalogVideoStandard (strmif.h)
description: The AnalogVideoStandard enumeration specifies the format of an analog television signal.
old-location: dshow\analogvideostandard.htm
tech.root: DirectShow
ms.assetid: 6760a40c-550c-4774-a5d1-d7e2a6aa6096
ms.date: 12/05/2018
ms.keywords: AnalogVideoStandard, AnalogVideoStandard enumeration [DirectShow], AnalogVideoStandardEnumeration, AnalogVideo_NTSC_433, AnalogVideo_NTSC_M, AnalogVideo_NTSC_M_J, AnalogVideo_None, AnalogVideo_PAL_60, AnalogVideo_PAL_B, AnalogVideo_PAL_D, AnalogVideo_PAL_H, AnalogVideo_PAL_I, AnalogVideo_PAL_M, AnalogVideo_PAL_N, AnalogVideo_PAL_N_COMBO, AnalogVideo_SECAM_B, AnalogVideo_SECAM_D, AnalogVideo_SECAM_G, AnalogVideo_SECAM_H, AnalogVideo_SECAM_K, AnalogVideo_SECAM_K1, AnalogVideo_SECAM_L, AnalogVideo_SECAM_L1, dshow.analogvideostandard, strmif/AnalogVideoStandard, strmif/AnalogVideo_NTSC_433, strmif/AnalogVideo_NTSC_M, strmif/AnalogVideo_NTSC_M_J, strmif/AnalogVideo_None, strmif/AnalogVideo_PAL_60, strmif/AnalogVideo_PAL_B, strmif/AnalogVideo_PAL_D, strmif/AnalogVideo_PAL_H, strmif/AnalogVideo_PAL_I, strmif/AnalogVideo_PAL_M, strmif/AnalogVideo_PAL_N, strmif/AnalogVideo_PAL_N_COMBO, strmif/AnalogVideo_SECAM_B, strmif/AnalogVideo_SECAM_D, strmif/AnalogVideo_SECAM_G, strmif/AnalogVideo_SECAM_H, strmif/AnalogVideo_SECAM_K, strmif/AnalogVideo_SECAM_K1, strmif/AnalogVideo_SECAM_L, strmif/AnalogVideo_SECAM_L1
f1_keywords:
- strmif/AnalogVideoStandard
dev_langs:
- c++
req.header: strmif.h
req.include-header: Dshow.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- strmif.h
api_name:
- AnalogVideoStandard
targetos: Windows
req.typenames: AnalogVideoStandard
req.redist: 
ms.custom: 19H1
---

# AnalogVideoStandard enumeration


## -description



The <b>AnalogVideoStandard</b> enumeration specifies the format of an analog television signal.




## -enum-fields




### -field AnalogVideo_None

Digital sensor.
          


### -field AnalogVideo_NTSC_M

NTSC (M) standard, 7.5 IRE black.
          


### -field AnalogVideo_NTSC_M_J

NTSC (M) standard, 0 IRE black (Japan).
          


### -field AnalogVideo_NTSC_433

NTSC-433.
          


### -field AnalogVideo_PAL_B

PAL-B standard.
          


### -field AnalogVideo_PAL_D

PAL (D) standard.
          


### -field AnalogVideo_PAL_G


### -field AnalogVideo_PAL_H

PAL (H) standard.
          


### -field AnalogVideo_PAL_I

PAL (I) standard.
          


### -field AnalogVideo_PAL_M

PAL (M) standard.
          


### -field AnalogVideo_PAL_N

PAL (N) standard.
          


### -field AnalogVideo_PAL_60

PAL-60 standard.
          


### -field AnalogVideo_SECAM_B

SECAM (B) standard.
          


### -field AnalogVideo_SECAM_D

SECAM (D) standard.
          


### -field AnalogVideo_SECAM_G

SECAM (G) standard.
          


### -field AnalogVideo_SECAM_H

SECAM (H) standard.
          


### -field AnalogVideo_SECAM_K

SECAM (K) standard.
          


### -field AnalogVideo_SECAM_K1

SECAM (K1) standard.
          


### -field AnalogVideo_SECAM_L

SECAM (L) standard.
          


### -field AnalogVideo_SECAM_L1

SECAM (L1) standard.
          


### -field AnalogVideo_PAL_N_COMBO

Combination (N) PAL standard (Argentina).
          


### -field AnalogVideoMask_MCE_NTSC


### -field AnalogVideoMask_MCE_PAL


### -field AnalogVideoMask_MCE_SECAM




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/directshow-enumerated-types">DirectShow Enumerated Types</a>



<a href="https://docs.microsoft.com/windows/desktop/api/strmif/nn-strmif-iamtvtuner">IAMTVTuner</a>
 

 

