---
UID: NE:strmif.tagDVD_KARAOKE_CONTENTS
title: DVD_KARAOKE_CONTENTS (strmif.h)
description: Specifies flags that, when used in a bitwise OR operation, describe the contents of each channel of an audio stream in a karaoke title.
old-location: dshow\dvd_karaoke_contents.htm
tech.root: DirectShow
ms.assetid: 9d02b0bf-237a-42bf-b946-588b899cd3d9
ms.date: 12/05/2018
ms.keywords: DVD_KARAOKE_CONTENTS, DVD_KARAOKE_CONTENTS , DVD_KARAOKE_CONTENTS enumeration [DirectShow], DVD_KARAOKE_CONTENTSEnumeration, DVD_Karaoke_GuideMelody1, DVD_Karaoke_GuideMelody2, DVD_Karaoke_GuideMelodyA, DVD_Karaoke_GuideMelodyB, DVD_Karaoke_GuideVocal1, DVD_Karaoke_GuideVocal2, DVD_Karaoke_SoundEffectA, DVD_Karaoke_SoundEffectB, dshow.dvd_karaoke_contents, strmif/DVD_KARAOKE_CONTENTS, strmif/DVD_Karaoke_GuideMelody1, strmif/DVD_Karaoke_GuideMelody2, strmif/DVD_Karaoke_GuideMelodyA, strmif/DVD_Karaoke_GuideMelodyB, strmif/DVD_Karaoke_GuideVocal1, strmif/DVD_Karaoke_GuideVocal2, strmif/DVD_Karaoke_SoundEffectA, strmif/DVD_Karaoke_SoundEffectB
f1_keywords:
- strmif/DVD_KARAOKE_CONTENTS
dev_langs:
- c++
req.header: strmif.h
req.include-header: Dshow.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- strmif.h
api_name:
- DVD_KARAOKE_CONTENTS
targetos: Windows
req.typenames: DVD_KARAOKE_CONTENTS
req.redist: 
ms.custom: 19H1
---

# DVD_KARAOKE_CONTENTS enumeration


## -description



Specifies flags that, when used in a bitwise <b>OR</b> operation, describe the contents of each channel of an audio stream in a karaoke title.




## -enum-fields




### -field DVD_Karaoke_GuideVocal1

The channel contains guide vocal 1.
          


### -field DVD_Karaoke_GuideVocal2

The channel contains guide vocal 2.
          


### -field DVD_Karaoke_GuideMelody1

The channel contains guide melody 1.
          


### -field DVD_Karaoke_GuideMelody2

The channel contains guide melody 2.
          


### -field DVD_Karaoke_GuideMelodyA

The channel contains guide melody A.
          


### -field DVD_Karaoke_GuideMelodyB

The channel contains guide melody B.
          


### -field DVD_Karaoke_SoundEffectA

The channel contains sound effect A.
          


### -field DVD_Karaoke_SoundEffectB

The channel contains sound effect B.
          


## -remarks



This enumeration is used in the [DVD_KaraokeAttributes](https://docs.microsoft.com/windows/desktop/api/strmif/ns-strmif-dvd_karaokeattributes) structure.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/directshow-enumerated-types">DirectShow Enumerated Types</a>
 

 

