---
UID: NE:strmif.DVD_TextCharSet
title: DVD_TextCharSet (strmif.h)
description: Defines which character set a specified string is encoded with.
old-location: dshow\dvd_textcharset.htm
tech.root: DirectShow
ms.assetid: ee7d09e1-6274-4993-914e-d8f5efeb5f90
ms.date: 12/05/2018
ms.keywords: DVD_CharSet_ISO646, DVD_CharSet_ISO8859_1, DVD_CharSet_JIS_Roman_Kanji, DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana, DVD_CharSet_Unicode, DVD_TextCharSet, DVD_TextCharSet , DVD_TextCharSet enumeration [DirectShow], DVD_TextCharSetEnumeration, dshow.dvd_textcharset, strmif/DVD_CharSet_ISO646, strmif/DVD_CharSet_ISO8859_1, strmif/DVD_CharSet_JIS_Roman_Kanji, strmif/DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana, strmif/DVD_CharSet_Unicode, strmif/DVD_TextCharSet
f1_keywords:
- strmif/DVD_TextCharSet
dev_langs:
- c++
req.header: strmif.h
req.include-header: Dshow.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- strmif.h
api_name:
- DVD_TextCharSet
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DVD_TextCharSet enumeration


## -description



Defines which character set a specified string is encoded with.




## -enum-fields




### -field DVD_CharSet_Unicode

Unicode character set.
          


### -field DVD_CharSet_ISO646

ISO 646 character set.
          


### -field DVD_CharSet_JIS_Roman_Kanji

Japanese Industrial Standards (JIS) Roman Kanji character set.
          


### -field DVD_CharSet_ISO8859_1

ISO 8859-1 character set.
          


### -field DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana

JIS Kanji-Roman-Katakana character set.
          


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/directshow-enumerated-types">DirectShow Enumerated Types</a>



<a href="https://docs.microsoft.com/windows/desktop/api/strmif/nf-strmif-idvdinfo2-getdvdtextlanguageinfo">IDvdInfo2::GetDVDTextLanguageInfo</a>
 

 

